const mix = require('laravel-mix')
const path = require('path')

const directory = path.basename(path.resolve(__dirname))
const source = `platform/plugins/${directory}`
const dist = `public/vendor/core/plugins/${directory}`

mix
    .sass(`${source}/resources/sass/form-builder.scss`, `${dist}/css`)
    .sass(`${source}/resources/sass/form-builder-rtl.scss`, `${dist}/css`)
    .sass(`${source}/resources/sass/form-admin.scss`, `${dist}/css`)
    .sass(`${source}/resources/sass/form-admin-rtl.scss`, `${dist}/css`)
    .sass(`${source}/resources/sass/form-public.scss`, `${dist}/css`)
    .sass(`${source}/resources/sass/form-public-rtl.scss`, `${dist}/css`)
    .sass(`${source}/resources/sass/license-activation.scss`, `${dist}/css`)
    .js(`${source}/resources/js/form-builder.js`, `${dist}/js`)
    .js(`${source}/resources/js/form-public.js`, `${dist}/js`)
    .js(`${source}/resources/js/embed.js`, `${dist}/js`)
    .js(`${source}/resources/js/license-activation.js`, `${dist}/js`)
    .js(`${source}/resources/js/import-form.js`, `${dist}/js`)

if (mix.inProduction()) {
    mix.copy(`${dist}/css/form-builder.css`, `${source}/public/css`)
    mix.copy(`${dist}/css/form-builder-rtl.css`, `${source}/public/css`)
    mix.copy(`${dist}/css/form-admin.css`, `${source}/public/css`)
    mix.copy(`${dist}/css/form-admin-rtl.css`, `${source}/public/css`)
    mix.copy(`${dist}/css/form-public.css`, `${source}/public/css`)
    mix.copy(`${dist}/css/form-public-rtl.css`, `${source}/public/css`)
    mix.copy(`${dist}/css/license-activation.css`, `${source}/public/css`)
    mix.copy(`${dist}/js/form-builder.js`, `${source}/public/js`)
    mix.copy(`${dist}/js/form-public.js`, `${source}/public/js`)
    mix.copy(`${dist}/js/embed.js`, `${source}/public/js`)
    mix.copy(`${dist}/js/license-activation.js`, `${source}/public/js`)
    mix.copy(`${dist}/js/import-form.js`, `${source}/public/js`)
}
