<?php

namespace Botble\BbFormBuilder\Providers;

use Botble\Base\Facades\DashboardMenu;
use Botble\Base\Facades\PanelSectionManager;
use Botble\Base\PanelSections\PanelSectionItem;
use Botble\Base\Supports\ServiceProvider;
use Botble\Base\Traits\LoadAndPublishDataTrait;
use Botble\BbFormBuilder\Models\FormBuilder;
use Botble\DataSynchronize\PanelSections\ExportPanelSection;
use Botble\LanguageAdvanced\Supports\LanguageAdvancedManager;
use Botble\Setting\PanelSections\SettingOthersPanelSection;

class FormBuilderServiceProvider extends ServiceProvider
{
    use LoadAndPublishDataTrait;

    public function boot(): void
    {
        $this
            ->setNamespace('plugins/bb-form-builder')
            ->publishAssets()
            ->loadAndPublishViews()
            ->loadRoutes()
            ->loadAndPublishConfigurations(['permissions', 'form-builder'])
            ->loadAndPublishTranslations()
            ->loadMigrations();

        $this->registerLanguageAdvanced();

        DashboardMenu::default()->beforeRetrieving(function (): void {
            DashboardMenu::make()
                ->registerItem([
                    'id' => 'cms-plugins-bb-form-builder',
                    'priority' => 98,
                    'name' => 'plugins/bb-form-builder::form.menu.title',
                    'icon' => 'ti ti-forms',
                    'permissions' => ['bb-form-builder.index'],
                ])
                ->registerItem([
                    'id' => 'cms-plugins-bb-form-builder-forms',
                    'priority' => 1,
                    'parent_id' => 'cms-plugins-bb-form-builder',
                    'name' => 'plugins/bb-form-builder::form.menu.forms',
                    'icon' => 'ti ti-clipboard-list',
                    'route' => 'bb-form-builder.forms.index',
                    'permissions' => ['bb-form-builder.forms.index'],
                ])
                ->registerItem([
                    'id' => 'cms-plugins-bb-form-builder-submissions',
                    'priority' => 2,
                    'parent_id' => 'cms-plugins-bb-form-builder',
                    'name' => 'plugins/bb-form-builder::form.menu.submissions',
                    'icon' => 'ti ti-inbox',
                    'route' => 'bb-form-builder.submissions.index',
                    'permissions' => ['bb-form-builder.submissions.index'],
                ])
                ->registerItem([
                    'id' => 'cms-plugins-bb-form-builder-reports',
                    'priority' => 3,
                    'parent_id' => 'cms-plugins-bb-form-builder',
                    'name' => 'plugins/bb-form-builder::form.menu.reports',
                    'icon' => 'ti ti-chart-bar',
                    'route' => 'bb-form-builder.reports.index',
                    'permissions' => ['bb-form-builder.reports.index'],
                ])
                ->registerItem([
                    'id' => 'cms-plugins-bb-form-builder-settings',
                    'priority' => 4,
                    'parent_id' => 'cms-plugins-bb-form-builder',
                    'name' => 'plugins/bb-form-builder::form.menu.settings',
                    'icon' => 'ti ti-settings',
                    'route' => 'bb-form-builder.settings',
                    'permissions' => ['bb-form-builder.settings'],
                ])
                ->registerItem([
                    'id' => 'cms-plugins-bb-form-builder-license',
                    'priority' => 9,
                    'parent_id' => 'cms-plugins-bb-form-builder',
                    'name' => 'plugins/bb-form-builder::form.license.title',
                    'icon' => 'ti ti-key',
                    'url' => fn () => route('bb-form-builder.license.index'),
                    'permissions' => ['bb-form-builder.index'],
                ]);
        });

        PanelSectionManager::default()->beforeRendering(function (): void {
            PanelSectionManager::registerItem(
                SettingOthersPanelSection::class,
                fn () => PanelSectionItem::make('bb-form-builder')
                    ->setTitle(trans('plugins/bb-form-builder::form.settings.title'))
                    ->withDescription(trans('plugins/bb-form-builder::form.settings.description'))
                    ->withIcon('ti ti-forms')
                    ->withPriority(0)
                    ->withRoute('bb-form-builder.settings')
            );
        });

        PanelSectionManager::setGroupId('data-synchronize')->beforeRendering(function (): void {
            PanelSectionManager::default()
                ->registerItem(
                    ExportPanelSection::class,
                    fn () => PanelSectionItem::make('bb-form-builder-submissions')
                        ->setTitle(trans('plugins/bb-form-builder::form.submissions.title'))
                        ->withDescription(trans('plugins/bb-form-builder::form.export.description'))
                        ->withPriority(900)
                        ->withPermission('bb-form-builder.submissions.export')
                        ->withRoute('tools.data-synchronize.export.form-submissions.index')
                );
        });

        $this->app->booted(function (): void {
            $this->app->register(HookServiceProvider::class);
        });
    }

    protected function registerLanguageAdvanced(): void
    {
        if (! is_plugin_active('language-advanced')) {
            return;
        }

        LanguageAdvancedManager::registerModule(FormBuilder::class, [
            'name',
            'content',
            'properties',
            'submission',
        ]);

        LanguageAdvancedManager::initModelRelations();
    }
}
