<?php

namespace Botble\BbFormBuilder\Models;

use Botble\Base\Facades\BaseHelper;
use Botble\Base\Models\BaseModel;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class FormBuilderSubmission extends BaseModel
{
    protected $table = 'fb_form_builder_submissions';

    protected $fillable = [
        'form_id',
        'content',
        'unique_identifier',
        'ip_address',
        'user_agent',
        'page_url',
        'referrer_url',
    ];

    protected $casts = [
        'content' => 'array',
    ];

    public function form(): BelongsTo
    {
        return $this->belongsTo(FormBuilder::class, 'form_id');
    }

    public function getFormattedContent(): array
    {
        if (! $this->form) {
            return $this->maskFileInfoInDemoMode($this->content ?? []);
        }

        $labels = $this->form->getFieldsLabel();
        $formatted = [];

        foreach ($this->content ?? [] as $key => $value) {
            $label = $labels[$key] ?? $key;
            $formatted[$label] = is_array($value) ? implode(', ', $value) : $value;
        }

        return $this->maskFileInfoInDemoMode($formatted);
    }

    protected function maskFileInfoInDemoMode(array $content): array
    {
        if (! BaseHelper::hasDemoModeEnabled()) {
            return $content;
        }

        $maskedContent = [];

        foreach ($content as $key => $value) {
            if (is_string($value) && $this->containsFileLink($value)) {
                $maskedContent[$key] = trans('plugins/bb-form-builder::form.demo.file_hidden');
            } else {
                $maskedContent[$key] = $value;
            }
        }

        return $maskedContent;
    }

    protected function containsFileLink(string $value): bool
    {
        return (bool) preg_match('/<a\s+[^>]*href=["\'][^"\']*\/download\/[^"\']*["\'][^>]*>/i', $value);
    }
}
