<?php

namespace Botble\BbFormBuilder\Http\Requests\Settings;

use Botble\Media\Facades\RvMedia;
use Botble\Support\Http\Requests\Request;

class FormBuilderSettingRequest extends Request
{
    protected function prepareForValidation(): void
    {
        $colorKeys = [
            'fb_form_builder_primary_color',
            'fb_form_builder_primary_hover_color',
            'fb_form_builder_success_color',
            'fb_form_builder_danger_color',
            'fb_form_builder_text_color',
            'fb_form_builder_border_color',
            'fb_form_builder_background_color',
        ];

        foreach ($colorKeys as $colorKey) {
            $value = $this->input($colorKey);

            if (is_string($value)) {
                $value = trim($value);
            }

            $this->merge([
                $colorKey => $value === '' ? null : $value,
            ]);
        }

        $allowedMimes = $this->input('fb_form_builder_allowed_mimes');

        if ($allowedMimes) {
            $rvMediaAllowed = RvMedia::getConfig('allowed_mime_types');
            $rvMediaExtensions = collect(explode(',', $rvMediaAllowed))
                ->map(fn ($ext) => strtolower(trim($ext)))
                ->filter()
                ->toArray();

            $requestedExtensions = collect(explode(',', $allowedMimes))
                ->map(fn ($ext) => strtolower(ltrim(trim($ext), '.')))
                ->filter()
                ->toArray();

            $filteredExtensions = array_intersect($requestedExtensions, $rvMediaExtensions);

            $this->merge([
                'fb_form_builder_allowed_mimes' => implode(',', $filteredExtensions),
            ]);
        }
    }

    public function rules(): array
    {
        return [
            'fb_form_builder_allowed_mimes' => ['nullable', 'string', 'max:500'],
            'fb_form_builder_max_file_size' => ['nullable', 'integer', 'min:1', 'max:100'],
            'fb_form_builder_primary_color' => ['nullable', 'string', 'min:4', 'max:24'],
            'fb_form_builder_primary_hover_color' => ['nullable', 'string', 'min:4', 'max:24'],
            'fb_form_builder_success_color' => ['nullable', 'string', 'min:4', 'max:24'],
            'fb_form_builder_danger_color' => ['nullable', 'string', 'min:4', 'max:24'],
            'fb_form_builder_text_color' => ['nullable', 'string', 'min:4', 'max:24'],
            'fb_form_builder_border_color' => ['nullable', 'string', 'min:4', 'max:24'],
            'fb_form_builder_background_color' => ['nullable', 'string', 'min:4', 'max:24'],
            'fb_form_builder_border_radius' => ['nullable', 'string', 'in:0,4px,8px,12px,16px,9999px'],
            'fb_form_builder_enable_shadow' => ['nullable'],
            'fb_form_builder_button_radius' => ['nullable', 'string', 'in:0,4px,8px,50px'],
            'fb_form_builder_success_message_timeout' => ['nullable', 'integer', 'min:0', 'max:3600'],
            'fb_form_builder_mailchimp_api_key' => ['nullable', 'string', 'max:255'],
            'fb_form_builder_getresponse_api_key' => ['nullable', 'string', 'max:255'],
        ];
    }
}
