<?php

namespace Botble\BbFormBuilder\Http\Controllers;

use Botble\Base\Http\Actions\DeleteResourceAction;
use Botble\Base\Supports\Breadcrumb;
use Botble\BbFormBuilder\Models\FormBuilderSubmission;
use Botble\BbFormBuilder\Tables\SubmissionTable;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\HttpFoundation\StreamedResponse;

class SubmissionController extends BaseFormBuilderController
{
    protected function breadcrumb(): Breadcrumb
    {
        return parent::breadcrumb()
            ->add(trans('plugins/bb-form-builder::form.menu.title'))
            ->add(trans('plugins/bb-form-builder::form.submissions.title'), route('bb-form-builder.submissions.index'));
    }

    public function index(SubmissionTable $table)
    {
        $this->pageTitle(trans('plugins/bb-form-builder::form.submissions.title'));

        return $table->renderTable();
    }

    public function show(FormBuilderSubmission $submission): string
    {
        $this->pageTitle(trans('plugins/bb-form-builder::form.submissions.view'));

        $submission->load('form');

        return view('plugins/bb-form-builder::submissions.show', compact('submission'))->render();
    }

    public function destroy(FormBuilderSubmission $submission)
    {
        return DeleteResourceAction::make($submission);
    }

    public function download(FormBuilderSubmission $submission, string $filename): StreamedResponse
    {
        $disk = Storage::disk('local');
        $path = 'form-builder/' . $submission->id . '/' . $filename;

        abort_unless($disk->exists($path), 404);

        return $disk->download($path, $filename);
    }
}
