<?php

namespace Botble\BbFormBuilder\Http\Controllers;

use Botble\BbFormBuilder\Classes\Integrations\GetResponseIntegration;
use Botble\BbFormBuilder\Classes\Integrations\MailchimpIntegration;
use Illuminate\Http\JsonResponse;

class IntegrationController extends BaseFormBuilderController
{
    public function getMailchimpLists(): JsonResponse
    {
        $apiKey = setting('fb_form_builder_mailchimp_api_key');

        if (! $apiKey) {
            return response()->json([
                'error' => true,
                'message' => trans('plugins/bb-form-builder::form.actions.mailchimp.api_key_not_configured'),
                'data' => [],
            ]);
        }

        $integration = new MailchimpIntegration($apiKey);
        $lists = $integration->getLists();

        return response()->json([
            'error' => false,
            'data' => $lists,
        ]);
    }

    public function getGetResponseCampaigns(): JsonResponse
    {
        $apiKey = setting('fb_form_builder_getresponse_api_key');

        if (! $apiKey) {
            return response()->json([
                'error' => true,
                'message' => trans('plugins/bb-form-builder::form.actions.getresponse.api_key_not_configured'),
                'data' => [],
            ]);
        }

        $integration = new GetResponseIntegration($apiKey);
        $campaigns = $integration->getLists();

        return response()->json([
            'error' => false,
            'data' => $campaigns,
        ]);
    }
}
