<?php

namespace Botble\BbFormBuilder\Http\Controllers;

use Botble\BbFormBuilder\Exporters\FormSubmissionExporter;
use Botble\DataSynchronize\Exporter\Exporter;
use Botble\DataSynchronize\Http\Controllers\ExportController;
use Botble\DataSynchronize\Http\Requests\ExportRequest;

class ExportSubmissionController extends ExportController
{
    protected function allowsSelectColumns(): bool
    {
        return ! request()->boolean('content_only');
    }

    protected function getExporter(): Exporter
    {
        $exporter = FormSubmissionExporter::make();

        if (request()->filled('form_id')) {
            $exporter->setFormId((string) request()->input('form_id'));
        }

        if (request()->filled('limit')) {
            $exporter->setLimit((int) request()->input('limit'));
        }

        if (request()->boolean('content_only')) {
            $exporter->contentOnly();
            $exporter->acceptedColumns(null);
        }

        $exporter->setDateRange(
            request()->input('start_date'),
            request()->input('end_date')
        );

        return $exporter;
    }

    public function store(ExportRequest $request)
    {
        $request->validate([
            'form_id' => ['nullable', 'string'],
            'limit' => ['nullable', 'integer', 'min:1', 'max:10000'],
            'start_date' => ['nullable', 'date'],
            'end_date' => ['nullable', 'date'],
            'content_only' => ['nullable', 'boolean'],
        ]);

        return parent::store($request);
    }
}
