<?php

namespace Botble\BbFormBuilder\Http\Controllers;

use Botble\Base\Facades\Assets;
use Botble\Base\Facades\BaseHelper;
use Botble\Base\Http\Controllers\BaseController;

abstract class BaseFormBuilderController extends BaseController
{
    public function __construct()
    {
        $version = get_cms_version();

        if (BaseHelper::adminLanguageDirection() === 'rtl') {
            Assets::addStylesDirectly("vendor/core/plugins/bb-form-builder/css/form-admin-rtl.css?v={$version}");
        } else {
            Assets::addStylesDirectly("vendor/core/plugins/bb-form-builder/css/form-admin.css?v={$version}");
        }
    }
}
