<?php

namespace Botble\BbFormBuilder\Forms\Settings;

use Botble\Base\Forms\FieldOptions\ColorFieldOption;
use Botble\Base\Forms\FieldOptions\HtmlFieldOption;
use Botble\Base\Forms\FieldOptions\NumberFieldOption;
use Botble\Base\Forms\FieldOptions\OnOffFieldOption;
use Botble\Base\Forms\FieldOptions\SelectFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\ColorField;
use Botble\Base\Forms\Fields\HtmlField;
use Botble\Base\Forms\Fields\NumberField;
use Botble\Base\Forms\Fields\OnOffField;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\Fields\TextField;
use Botble\BbFormBuilder\Http\Requests\Settings\FormBuilderSettingRequest;
use Botble\Setting\Forms\SettingForm;

class FormBuilderSettingForm extends SettingForm
{
    public function setup(): void
    {
        parent::setup();

        $this
            ->setValidatorClass(FormBuilderSettingRequest::class)
            ->setSectionTitle(trans('plugins/bb-form-builder::form.settings.title'))
            ->setSectionDescription(trans('plugins/bb-form-builder::form.settings.description'))
            ->add(
                'fb_form_builder_allowed_mimes',
                TextField::class,
                TextFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.allowed_mimes'))
                    ->helperText(trans('plugins/bb-form-builder::form.settings.allowed_mimes_help'))
                    ->placeholder('.pdf,.doc,.docx,.xls,.xlsx')
                    ->value(setting('fb_form_builder_allowed_mimes', config('plugins.bb-form-builder.form-builder.mimes')))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_max_file_size',
                NumberField::class,
                NumberFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.max_file_size'))
                    ->placeholder('10')
                    ->value(setting('fb_form_builder_max_file_size', config('plugins.bb-form-builder.form-builder.max_file_size', 10)))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_success_message_timeout',
                NumberField::class,
                NumberFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.success_message_timeout'))
                    ->helperText(trans('plugins/bb-form-builder::form.settings.success_message_timeout_help'))
                    ->placeholder('5')
                    ->min(0)
                    ->value(setting('fb_form_builder_success_message_timeout', config('plugins.bb-form-builder.form-builder.success_message_timeout', 5)))
                    ->toArray()
            )
            ->add(
                'appearance_section_heading',
                HtmlField::class,
                HtmlFieldOption::make()
                    ->content('<h4 class="mt-4 mb-3">' . trans('plugins/bb-form-builder::form.settings.appearance.title') . '</h4><p class="text-muted mb-3">' . trans('plugins/bb-form-builder::form.settings.appearance.description') . '</p>')
                    ->toArray()
            )
            ->add(
                'fb_form_builder_primary_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.appearance.primary_color'))
                    ->helperText(trans('plugins/bb-form-builder::form.settings.appearance.primary_color_help'))
                    ->value(setting('fb_form_builder_primary_color', '#6366f1'))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_primary_hover_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.appearance.primary_hover_color'))
                    ->value(setting('fb_form_builder_primary_hover_color', '#4f46e5'))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_success_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.appearance.success_color'))
                    ->helperText(trans('plugins/bb-form-builder::form.settings.appearance.success_color_help'))
                    ->value(setting('fb_form_builder_success_color', '#10b981'))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_danger_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.appearance.danger_color'))
                    ->helperText(trans('plugins/bb-form-builder::form.settings.appearance.danger_color_help'))
                    ->value(setting('fb_form_builder_danger_color', '#ef4444'))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.appearance.text_color'))
                    ->value(setting('fb_form_builder_text_color', '#1f2937'))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_border_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.appearance.border_color'))
                    ->value(setting('fb_form_builder_border_color', '#e5e7eb'))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.appearance.background_color'))
                    ->value(setting('fb_form_builder_background_color', '#ffffff'))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_border_radius',
                SelectField::class,
                SelectFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.appearance.border_radius'))
                    ->choices([
                        '0' => trans('plugins/bb-form-builder::form.settings.appearance.border_radius_options.none'),
                        '4px' => trans('plugins/bb-form-builder::form.settings.appearance.border_radius_options.small'),
                        '8px' => trans('plugins/bb-form-builder::form.settings.appearance.border_radius_options.medium'),
                        '12px' => trans('plugins/bb-form-builder::form.settings.appearance.border_radius_options.large'),
                        '16px' => trans('plugins/bb-form-builder::form.settings.appearance.border_radius_options.extra_large'),
                        '9999px' => trans('plugins/bb-form-builder::form.settings.appearance.border_radius_options.pill'),
                    ])
                    ->selected(setting('fb_form_builder_border_radius', '8px'))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_enable_shadow',
                OnOffField::class,
                OnOffFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.appearance.enable_shadow'))
                    ->helperText(trans('plugins/bb-form-builder::form.settings.appearance.enable_shadow_help'))
                    ->value(setting('fb_form_builder_enable_shadow', true))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_button_radius',
                SelectField::class,
                SelectFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.appearance.button_radius'))
                    ->choices([
                        '0' => trans('plugins/bb-form-builder::form.settings.appearance.border_radius_options.none'),
                        '4px' => trans('plugins/bb-form-builder::form.settings.appearance.border_radius_options.small'),
                        '8px' => trans('plugins/bb-form-builder::form.settings.appearance.border_radius_options.medium'),
                        '50px' => trans('plugins/bb-form-builder::form.settings.appearance.border_radius_options.pill'),
                    ])
                    ->selected(setting('fb_form_builder_button_radius', '50px'))
                    ->toArray()
            )
            ->add(
                'integrations_section_heading',
                HtmlField::class,
                HtmlFieldOption::make()
                    ->content('<h4 class="mt-4 mb-3">' . trans('plugins/bb-form-builder::form.settings.integrations.title') . '</h4><p class="text-muted mb-3">' . trans('plugins/bb-form-builder::form.settings.integrations.description') . '</p>')
                    ->toArray()
            )
            ->add(
                'fb_form_builder_mailchimp_api_key',
                TextField::class,
                TextFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.integrations.mailchimp_api_key'))
                    ->helperText(trans('plugins/bb-form-builder::form.settings.integrations.mailchimp_api_key_help'))
                    ->placeholder(trans('plugins/bb-form-builder::form.settings.integrations.mailchimp_api_key_placeholder'))
                    ->value(setting('fb_form_builder_mailchimp_api_key'))
                    ->toArray()
            )
            ->add(
                'fb_form_builder_getresponse_api_key',
                TextField::class,
                TextFieldOption::make()
                    ->label(trans('plugins/bb-form-builder::form.settings.integrations.getresponse_api_key'))
                    ->helperText(trans('plugins/bb-form-builder::form.settings.integrations.getresponse_api_key_help'))
                    ->placeholder(trans('plugins/bb-form-builder::form.settings.integrations.getresponse_api_key_placeholder'))
                    ->value(setting('fb_form_builder_getresponse_api_key'))
                    ->toArray()
            );
    }
}
