<?php

namespace Botble\BbFormBuilder\Classes\Integrations;

class GetResponseIntegration extends BaseIntegration
{
    public function __construct(string $apiKey)
    {
        parent::__construct($apiKey);

        $this->baseUrl = 'https://api.getresponse.com/v3';
    }

    public function getLists(): array
    {
        if (! $this->isConfigured()) {
            return [];
        }

        $response = $this->get('/campaigns?perPage=100');

        if (empty($response)) {
            return [];
        }

        return collect($response)
            ->map(fn ($campaign) => [
                'id' => $campaign['campaignId'],
                'name' => $campaign['name'],
            ])
            ->toArray();
    }

    public function subscribe(string $listId, string $email, ?string $name = null): bool
    {
        if (! $this->isConfigured()) {
            return false;
        }

        $data = [
            'email' => $email,
            'campaign' => [
                'campaignId' => $listId,
            ],
        ];

        if ($name) {
            $data['name'] = $name;
        }

        $response = $this->post('/contacts', $data);

        if (isset($response['error'])) {
            if ($response['status'] === 409) {
                return true;
            }

            return false;
        }

        return true;
    }

    protected function getHeaders(array $additional = []): array
    {
        return array_merge(parent::getHeaders($additional), [
            'X-Auth-Token' => 'api-key ' . $this->apiKey,
        ]);
    }
}
