<?php

use Botble\Base\Facades\AdminHelper;
use Botble\Base\Http\Middleware\HttpSecurityHeaders;
use Botble\BbFormBuilder\Http\Controllers\ExportSubmissionController;
use Botble\BbFormBuilder\Http\Controllers\FormBuilderController;
use Botble\BbFormBuilder\Http\Controllers\IntegrationController;
use Botble\BbFormBuilder\Http\Controllers\LicenseController;
use Botble\BbFormBuilder\Http\Controllers\PublicController;
use Botble\BbFormBuilder\Http\Controllers\ReportsController;
use Botble\BbFormBuilder\Http\Controllers\Settings\FormBuilderSettingController;
use Botble\BbFormBuilder\Http\Controllers\SubmissionController;
use Botble\Theme\Facades\Theme;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Support\Facades\Route;

AdminHelper::registerRoutes(function (): void {
    Route::group(['prefix' => 'bb-form-builder', 'as' => 'bb-form-builder.'], function (): void {
        Route::group(['prefix' => 'reports', 'as' => 'reports.', 'permission' => 'bb-form-builder.reports.index'], function (): void {
            Route::get('', [ReportsController::class, 'index'])->name('index');
        });

        Route::group(['prefix' => 'submissions', 'as' => 'submissions.'], function (): void {
            Route::resource('', SubmissionController::class)
                ->parameters(['' => 'submission'])
                ->only(['index', 'destroy']);
            Route::get('{submission}', [SubmissionController::class, 'show'])->name('show');
            Route::get('{submission}/download/{filename}', [SubmissionController::class, 'download'])
                ->name('download')
                ->where('filename', '.*')
                ->middleware('preventDemo');
        });

        Route::group(['prefix' => 'forms', 'as' => 'forms.'], function (): void {
            Route::resource('', FormBuilderController::class)->parameters(['' => 'form']);
            Route::post('import', [FormBuilderController::class, 'import'])
                ->name('import')
                ->permission('bb-form-builder.forms.create');
            Route::match(['get', 'post'], '{form}', [FormBuilderController::class, 'show'])->name('show');
            Route::post('{form}/translation', [FormBuilderController::class, 'saveTranslation'])
                ->name('translation.save')
                ->permission('bb-form-builder.forms.edit');
            Route::get('{form}/export', [FormBuilderController::class, 'export'])
                ->name('export')
                ->permission('bb-form-builder.forms.edit');
        });

        Route::group(['prefix' => 'integrations', 'as' => 'integrations.', 'permission' => 'bb-form-builder.forms.create'], function (): void {
            Route::get('mailchimp/lists', [IntegrationController::class, 'getMailchimpLists'])->name('mailchimp.lists');
            Route::get('getresponse/campaigns', [IntegrationController::class, 'getGetResponseCampaigns'])->name('getresponse.campaigns');
        });
    });

    Route::group(['prefix' => 'settings', 'as' => 'bb-form-builder.', 'permission' => 'bb-form-builder.settings'], function (): void {
        Route::get('bb-form-builder', [FormBuilderSettingController::class, 'edit'])->name('settings');
        Route::put('bb-form-builder', [FormBuilderSettingController::class, 'update'])->name('settings.update');
    });

    Route::group(['prefix' => 'bb-form-builder/license', 'as' => 'bb-form-builder.license.'], function (): void {
        Route::get('/', [LicenseController::class, 'index'])->name('index');
        Route::post('activate', [LicenseController::class, 'activate'])
            ->name('activate')
            ->middleware('preventDemo');
        Route::post('deactivate', [LicenseController::class, 'deactivate'])
            ->name('deactivate')
            ->middleware('preventDemo');
    });

    Route::prefix('tools/data-synchronize')->name('tools.data-synchronize.')->group(function (): void {
        Route::prefix('export/form-submissions')->name('export.form-submissions.')->group(function (): void {
            Route::get('/', [ExportSubmissionController::class, 'index'])
                ->name('index')
                ->permission('bb-form-builder.submissions.export');
            Route::post('/', [ExportSubmissionController::class, 'store'])
                ->name('store')
                ->permission('bb-form-builder.submissions.export')
                ->middleware('preventDemo');
        });
    });
});

Theme::registerRoutes(function (): void {
    Route::prefix('forms')->name('public.bb-form-builder.')->group(function (): void {
        Route::get('{hash}/embed', [PublicController::class, 'embed'])
            ->name('embed')
            ->withoutMiddleware(HttpSecurityHeaders::class);
        Route::post('{hash}/submit', [PublicController::class, 'submit'])->name('submit');
    });

    Route::get('form/{code}', [PublicController::class, 'embedByCode'])
        ->name('public.bb-form-builder.embed-by-code')
        ->withoutMiddleware(HttpSecurityHeaders::class);

    Route::prefix('api/bb-form-builder')->name('api.bb-form-builder.')->group(function (): void {
        Route::get('form/{code}', [PublicController::class, 'getFormByCode'])->name('form');
        Route::get('form/{code}/assets', [PublicController::class, 'getFormAssets'])->name('form.assets');
        Route::post('form/{hash}/submit', [PublicController::class, 'apiSubmit'])
            ->name('form.submit')
            ->withoutMiddleware([VerifyCsrfToken::class]);
    });
});
