@extends(BaseHelper::getAdminMasterLayoutTemplate())

@section('content')
    <div class="fb-admin-page">
    <x-core::card>
        <x-core::card.header>
            <x-core::card.title>
                {{ trans('plugins/bb-form-builder::form.submissions.view') }}
            </x-core::card.title>
        </x-core::card.header>

        <x-core::card.body>
            <x-core::datagrid>
                <x-core::datagrid.item>
                    <x-slot:title>{{ trans('plugins/bb-form-builder::form.submissions.form') }}</x-slot:title>
                    @if($submission->form)
                        <a href="{{ route('bb-form-builder.forms.edit', $submission->form->id) }}">
                            {{ $submission->form->name }}
                        </a>
                    @else
                        -
                    @endif
                </x-core::datagrid.item>

                <x-core::datagrid.item>
                    <x-slot:title>{{ trans('plugins/bb-form-builder::form.submissions.submitted_at') }}</x-slot:title>
                    {{ $submission->created_at->translatedFormat('d M Y H:i:s') }}
                </x-core::datagrid.item>

                <x-core::datagrid.item>
                    <x-slot:title>{{ trans('plugins/bb-form-builder::form.submissions.ip_address') }}</x-slot:title>
                    {{ $submission->ip_address ?? '-' }}
                </x-core::datagrid.item>

                @if($submission->user_agent)
                    <x-core::datagrid.item>
                        <x-slot:title>{{ trans('plugins/bb-form-builder::form.submissions.user_agent') }}</x-slot:title>
                        <span class="text-muted small" style="word-break: break-all;">{{ $submission->user_agent }}</span>
                    </x-core::datagrid.item>
                @endif

                @if($submission->page_url)
                    <x-core::datagrid.item>
                        <x-slot:title>{{ trans('plugins/bb-form-builder::form.submissions.page_url') }}</x-slot:title>
                        <a href="{{ $submission->page_url }}" target="_blank" rel="noopener noreferrer" class="text-break">
                            {{ $submission->page_url }}
                            <x-core::icon name="ti ti-external-link" class="ms-1" />
                        </a>
                    </x-core::datagrid.item>
                @endif

                @if($submission->referrer_url)
                    <x-core::datagrid.item>
                        <x-slot:title>{{ trans('plugins/bb-form-builder::form.submissions.referrer_url') }}</x-slot:title>
                        <a href="{{ $submission->referrer_url }}" target="_blank" rel="noopener noreferrer" class="text-break">
                            {{ $submission->referrer_url }}
                            <x-core::icon name="ti ti-external-link" class="ms-1" />
                        </a>
                    </x-core::datagrid.item>
                @endif
            </x-core::datagrid>

            @if(!empty($submission->content))
                <hr class="my-3">
                <h4 class="mb-3">{{ trans('plugins/bb-form-builder::form.submissions.data') }}</h4>
                <x-core::datagrid>
                    @foreach($submission->getFormattedContent() as $label => $value)
                        <x-core::datagrid.item>
                            <x-slot:title>{{ $label }}</x-slot:title>
                            @php
                                $displayValue = is_array($value) ? implode(', ', $value) : $value;
                            @endphp
                            {!! BaseHelper::clean(nl2br($displayValue)) !!}
                        </x-core::datagrid.item>
                    @endforeach
                </x-core::datagrid>
            @endif
        </x-core::card.body>

        <x-core::card.footer>
            <a href="{{ route('bb-form-builder.submissions.index') }}" class="btn btn-secondary">
                <x-core::icon name="ti ti-arrow-left" class="me-1" />
                {{ trans('plugins/bb-form-builder::form.submissions.back') }}
            </a>
            <x-core::button
                type="button"
                color="danger"
                data-bb-toggle="confirm-delete"
                data-bb-resource="submission"
                :data-bb-resource-url="route('bb-form-builder.submissions.destroy', $submission->id)"
            >
                <x-core::icon name="ti ti-trash" class="me-1" />
                {{ trans('plugins/bb-form-builder::form.submissions.delete') }}
            </x-core::button>
        </x-core::card.footer>
    </x-core::card>
    </div>
@endsection
