@extends('packages/data-synchronize::export')

@section('export_extra_filters_after')
    @php
        $forms = Botble\BbFormBuilder\Models\FormBuilder::query()
            ->select(['id', 'name'])
            ->orderByDesc('created_at')
            ->pluck('name', 'id')
            ->toArray();
    @endphp

    <div class="row mb-3">
        <div class="col-md-4">
            <x-core::form.select
                name="form_id"
                :label="trans('plugins/bb-form-builder::form.export.form')"
                :options="['' => trans('plugins/bb-form-builder::form.export.all_forms')] + $forms"
            />
        </div>
        <div class="col-md-2">
            <x-core::form.text-input
                name="limit"
                type="number"
                :label="trans('plugins/bb-form-builder::form.export.limit')"
                :placeholder="trans('plugins/bb-form-builder::form.export.limit_placeholder')"
                min="1"
                max="10000"
            />
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 mb-3">
            <x-core::form.on-off.checkbox
                name="content_only"
                :label="trans('plugins/bb-form-builder::form.export.content_only')"
                :helperText="trans('plugins/bb-form-builder::form.export.content_only_help')"
                value="1"
            />
        </div>
        <div class="col-md-3">
            <label for="start_date" class="form-label">{{ trans('plugins/bb-form-builder::form.export.start_date') }}</label>
            {!! Form::datePicker('start_date', null, [
                'placeholder' => trans('plugins/bb-form-builder::form.export.start_date_placeholder'),
            ]) !!}
        </div>
        <div class="col-md-3">
            <label for="end_date" class="form-label">{{ trans('plugins/bb-form-builder::form.export.end_date') }}</label>
            {!! Form::datePicker('end_date', null, [
                'placeholder' => trans('plugins/bb-form-builder::form.export.end_date_placeholder'),
            ]) !!}
        </div>
    </div>
@stop
