@extends(BaseHelper::getAdminMasterLayoutTemplate())

@section('content')
    <div class="fb-admin-page">
    <div class="row row-deck row-cards">
        <div class="col-12">
            <x-core::stat-widget>
                <x-core::stat-widget.item
                    :label="trans('plugins/bb-form-builder::form.reports.total_forms')"
                    :value="$totalForms"
                    icon="ti ti-forms"
                    color="primary"
                    column="col-6 col-sm-4 col-lg-2"
                />
                <x-core::stat-widget.item
                    :label="trans('plugins/bb-form-builder::form.reports.total_submissions')"
                    :value="$totalSubmissions"
                    icon="ti ti-mail"
                    color="azure"
                    column="col-6 col-sm-4 col-lg-2"
                />
                <x-core::stat-widget.item
                    :label="trans('plugins/bb-form-builder::form.reports.active_forms')"
                    :value="$activeForms"
                    icon="ti ti-bolt"
                    color="success"
                    column="col-6 col-sm-4 col-lg-2"
                />
                <x-core::stat-widget.item
                    :label="trans('plugins/bb-form-builder::form.reports.today')"
                    :value="$todaySubmissions"
                    icon="ti ti-sun"
                    color="warning"
                    column="col-6 col-sm-4 col-lg-2"
                />
                <x-core::stat-widget.item
                    :label="trans('plugins/bb-form-builder::form.reports.this_week')"
                    :value="$weekSubmissions"
                    icon="ti ti-calendar-week"
                    color="teal"
                    column="col-6 col-sm-4 col-lg-2"
                />
                <x-core::stat-widget.item
                    :label="trans('plugins/bb-form-builder::form.reports.this_month')"
                    :value="$monthSubmissions"
                    icon="ti ti-calendar-stats"
                    color="purple"
                    column="col-6 col-sm-4 col-lg-2"
                />
            </x-core::stat-widget>
        </div>

        <div class="col-12 col-xl-8">
            <div class="card h-100">
                <div class="card-header">
                    <h3 class="card-title">{{ trans('plugins/bb-form-builder::form.reports.submissions_chart') }}</h3>
                </div>
                <div class="card-body">
                    <div id="submissions-chart" style="height: 300px;"></div>
                </div>
            </div>
        </div>
        <div class="col-12 col-xl-4">
            <div class="card h-100">
                <div class="card-header">
                    <h3 class="card-title">{{ trans('plugins/bb-form-builder::form.reports.top_forms') }}</h3>
                </div>
                @if($topForms->count() > 0)
                    <div class="list-group list-group-flush list-group-hoverable">
                        @foreach($topForms as $index => $topForm)
                            <div class="list-group-item">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <span @class([
                                            'avatar avatar-rounded',
                                            'bg-primary-lt text-primary' => $index === 0,
                                            'bg-azure-lt text-azure' => $index === 1,
                                            'bg-teal-lt text-teal' => $index === 2,
                                            'bg-secondary-lt' => $index > 2
                                        ])>{{ $index + 1 }}</span>
                                    </div>
                                    <div class="col text-truncate">
                                        <a href="{{ route('bb-form-builder.forms.show', $topForm) }}" class="text-reset d-block text-truncate fw-medium">{{ $topForm->name }}</a>
                                        <div class="d-flex align-items-center gap-2 text-secondary small">
                                            {!! $topForm->status->toHtml() !!}
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <span class="badge bg-primary-lt">{{ number_format($topForm->submissions_count) }}</span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="card-body">
                        <div class="empty">
                            <div class="empty-icon">
                                <x-core::icon name="ti ti-inbox" />
                            </div>
                            <p class="empty-title">{{ trans('plugins/bb-form-builder::form.reports.no_data') }}</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <div class="col-12 col-xl-4">
            <div class="card h-100">
                <div class="card-header">
                    <h3 class="card-title">{{ trans('plugins/bb-form-builder::form.reports.recent_submissions') }}</h3>
                </div>
                @if($recentSubmissions->count() > 0)
                    <div class="list-group list-group-flush list-group-hoverable overflow-auto" style="max-height: 400px;">
                        @foreach($recentSubmissions as $submission)
                            <a href="{{ route('bb-form-builder.submissions.show', $submission) }}" class="list-group-item list-group-item-action py-3">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <span class="avatar avatar-sm bg-primary-lt text-primary">
                                            <x-core::icon name="ti ti-mail" />
                                        </span>
                                    </div>
                                    <div class="col text-truncate">
                                        <div class="text-reset d-block text-truncate">{{ $submission->form->name ?? 'N/A' }}</div>
                                        <div class="text-secondary small">{{ $submission->created_at->diffForHumans() }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <x-core::icon name="ti ti-chevron-right" class="text-secondary" />
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    </div>
                @else
                    <div class="card-body">
                        <div class="empty">
                            <div class="empty-icon">
                                <x-core::icon name="ti ti-inbox" />
                            </div>
                            <p class="empty-title">{{ trans('plugins/bb-form-builder::form.reports.no_data') }}</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <div class="col-12 col-xl-8">
            <div class="card h-100">
                <div class="card-header">
                    <h3 class="card-title">{{ trans('plugins/bb-form-builder::form.reports.form_stats') }}</h3>
                </div>
                @if($formStats->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-vcenter card-table table-hover">
                            <thead>
                                <tr>
                                    <th>{{ trans('plugins/bb-form-builder::form.reports.form_name') }}</th>
                                    <th>{{ trans('plugins/bb-form-builder::form.reports.status') }}</th>
                                    <th class="text-end">{{ trans('plugins/bb-form-builder::form.reports.total') }}</th>
                                    <th class="text-end">{{ trans('plugins/bb-form-builder::form.reports.today') }}</th>
                                    <th class="text-end">{{ trans('plugins/bb-form-builder::form.reports.this_week') }}</th>
                                    <th class="text-end">{{ trans('plugins/bb-form-builder::form.reports.this_month') }}</th>
                                    <th class="w-1"></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($formStats as $stat)
                                    <tr>
                                        <td>
                                            <a href="{{ route('bb-form-builder.forms.show', $stat['id']) }}" class="text-reset fw-medium">{{ $stat['name'] }}</a>
                                        </td>
                                        <td>{!! $stat['status']->toHtml() !!}</td>
                                        <td class="text-end"><span class="badge bg-primary-lt">{{ number_format($stat['total']) }}</span></td>
                                        <td class="text-end text-secondary">{{ number_format($stat['today']) }}</td>
                                        <td class="text-end text-secondary">{{ number_format($stat['week']) }}</td>
                                        <td class="text-end text-secondary">{{ number_format($stat['month']) }}</td>
                                        <td>
                                            <a href="{{ route('bb-form-builder.forms.show', $stat['id']) }}" class="text-primary" title="{{ trans('plugins/bb-form-builder::form.reports.view_form') }}">
                                                <x-core::icon name="ti ti-eye" />
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="card-body">
                        <div class="empty">
                            <div class="empty-icon">
                                <x-core::icon name="ti ti-inbox" />
                            </div>
                            <p class="empty-title">{{ trans('plugins/bb-form-builder::form.reports.no_data') }}</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
    </div>
@endsection

@push('footer')
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var chartElement = document.querySelector("#submissions-chart");
            if (!chartElement) return;

            var chartData = @json($chartData);
            var dates = Object.keys(chartData);
            var values = Object.values(chartData);

            var options = {
                series: [{
                    name: '{{ trans('plugins/bb-form-builder::form.reports.submissions') }}',
                    data: values
                }],
                chart: {
                    type: 'area',
                    height: 300,
                    toolbar: {
                        show: false
                    },
                    zoom: {
                        enabled: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    curve: 'smooth',
                    width: 2
                },
                fill: {
                    type: 'gradient',
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.4,
                        opacityTo: 0.1,
                        stops: [0, 90, 100]
                    }
                },
                xaxis: {
                    categories: dates,
                    labels: {
                        formatter: function(value) {
                            if (!value) return '';
                            var date = new Date(value);
                            return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric' });
                        },
                        rotate: -45,
                        rotateAlways: false,
                        hideOverlappingLabels: true
                    },
                    tickAmount: 10
                },
                yaxis: {
                    min: 0,
                    forceNiceScale: true,
                    labels: {
                        formatter: function(value) {
                            return Math.round(value);
                        }
                    }
                },
                tooltip: {
                    x: {
                        formatter: function(value, { dataPointIndex }) {
                            var date = new Date(dates[dataPointIndex]);
                            return date.toLocaleDateString('en-US', { weekday: 'short', month: 'short', day: 'numeric', year: 'numeric' });
                        }
                    }
                },
                colors: ['#206bc4'],
                grid: {
                    borderColor: '#e9ecef',
                    strokeDashArray: 4
                }
            };

            var chart = new ApexCharts(chartElement, options);
            chart.render();
        });
    </script>
@endpush
