<div class="fb-action-card" data-action-type="{{ $actionKey }}" data-action-id="{{ $actionId }}">
    <div class="fb-action-card-header" data-bs-toggle="collapse" data-bs-target="#action-body-{{ $actionId }}">
        <div class="fb-action-card-icon">
            <x-core::icon :name="$actionConfig['icon'] ?? 'ti ti-bolt'" />
        </div>
        <div class="fb-action-card-title">
            <strong>{{ trans($actionConfig['name'] ?? $actionKey) }}</strong>
        </div>
        <div class="fb-action-card-actions">
            <button type="button" class="fb-action-card-toggle">
                <x-core::icon name="ti ti-chevron-down" class="toggle-icon" />
            </button>
            <button type="button" class="fb-action-card-remove remove-action-btn">
                <x-core::icon name="ti ti-trash" />
            </button>
        </div>
    </div>
    <div class="fb-action-card-body collapse show" id="action-body-{{ $actionId }}">
        @foreach(($actionConfig['fields'] ?? []) as $fieldKey => $fieldConfig)
            <div class="fb-action-field">
                <label class="fb-action-field-label {{ ($fieldConfig['required'] ?? false) ? 'required' : '' }}">
                    {{ trans($fieldConfig['label'] ?? $fieldKey) }}
                </label>
                @if(($fieldConfig['type'] ?? 'text') === 'textarea')
                    <textarea
                        name="actions[{{ $actionKey }}][{{ $actionId }}][{{ $fieldKey }}]"
                        class="form-control form-control-sm"
                        rows="{{ $fieldConfig['rows'] ?? 3 }}"
                        {{ ($fieldConfig['required'] ?? false) ? 'required' : '' }}
                        placeholder="{{ trans($fieldConfig['placeholder'] ?? '') }}"
                    >{{ $actionData[$fieldKey] ?? '' }}</textarea>
                @elseif(($fieldConfig['type'] ?? 'text') === 'select')
                    @if(!empty($fieldConfig['options_url']))
                        <select
                            name="actions[{{ $actionKey }}][{{ $actionId }}][{{ $fieldKey }}]"
                            class="form-select form-select-sm dynamic-options-select"
                            data-options-url="{{ route('bb-form-builder.integrations.' . str_replace('/', '.', $fieldConfig['options_url'])) }}"
                            data-selected-value="{{ $actionData[$fieldKey] ?? '' }}"
                            {{ ($fieldConfig['required'] ?? false) ? 'required' : '' }}
                        >
                            <option value="">{{ trans('plugins/bb-form-builder::form.actions.loading_options') }}</option>
                        </select>
                    @else
                        <select
                            name="actions[{{ $actionKey }}][{{ $actionId }}][{{ $fieldKey }}]"
                            class="form-select form-select-sm"
                            {{ ($fieldConfig['required'] ?? false) ? 'required' : '' }}
                        >
                            @foreach(($fieldConfig['options'] ?? []) as $optionValue => $optionLabel)
                                <option value="{{ $optionValue }}" {{ ($actionData[$fieldKey] ?? '') === $optionValue ? 'selected' : '' }}>
                                    {{ $optionLabel }}
                                </option>
                            @endforeach
                        </select>
                    @endif
                @else
                    <input
                        type="{{ $fieldConfig['type'] ?? 'text' }}"
                        name="actions[{{ $actionKey }}][{{ $actionId }}][{{ $fieldKey }}]"
                        class="form-control form-control-sm"
                        value="{{ $actionData[$fieldKey] ?? '' }}"
                        {{ ($fieldConfig['required'] ?? false) ? 'required' : '' }}
                        placeholder="{{ trans($fieldConfig['placeholder'] ?? '') }}"
                    >
                @endif
                @if(!empty($fieldConfig['help']))
                    <small class="fb-action-field-help">{{ trans($fieldConfig['help']) }}</small>
                @endif
            </div>
        @endforeach
    </div>
</div>
