@extends(BaseHelper::getAdminMasterLayoutTemplate())

@section('content')
    @php
        $translatedName = $translation->name ?? '';
        $translatedContent = $translation && $translation->content
            ? (is_string($translation->content) ? json_decode($translation->content, true) : $translation->content)
            : [];
        $translatedProperties = $translation && $translation->properties
            ? (is_string($translation->properties) ? json_decode($translation->properties, true) : $translation->properties)
            : [];
        $translatedSubmission = $translation && $translation->submission
            ? (is_string($translation->submission) ? json_decode($translation->submission, true) : $translation->submission)
            : [];
    @endphp

    {!! Form::open([
        'route' => ['bb-form-builder.forms.translation.save', $model->id],
        'method' => 'POST',
        'class' => 'bb-form-translation-form',
    ]) !!}
    @csrf
    <input type="hidden" name="ref_lang" value="{{ $refLang }}">

    <div class="row">
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h4 class="card-title mb-0">
                        <x-core::icon name="ti ti-language" class="me-2" />
                        {{ trans('plugins/bb-form-builder::form.translation.title') }}
                    </h4>
                    <div class="d-flex align-items-center gap-2">
                        {!! language_flag($currentLanguage->lang_flag, $currentLanguage->lang_name) !!}
                        <span class="fw-medium">{{ $currentLanguage->lang_name }}</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="alert alert-info mb-4">
                        <x-core::icon name="ti ti-info-circle" class="me-1" />
                        {{ trans('plugins/bb-form-builder::form.translation.description') }}
                    </div>

                    <div class="mb-4">
                        <label class="form-label required">{{ trans('core/base::forms.name') }}</label>
                        <input type="text" name="name" class="form-control" value="{{ $translatedName ?: $model->name }}" placeholder="{{ $model->name }}" required>
                    </div>

                    <hr class="my-4">

                    <h5 class="mb-3">
                        <x-core::icon name="ti ti-forms" class="me-2" />
                        {{ trans('plugins/bb-form-builder::form.translation.field_labels') }}
                    </h5>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 30%">{{ trans('plugins/bb-form-builder::form.translation.field_name') }}</th>
                                    <th style="width: 35%">{{ trans('plugins/bb-form-builder::form.translation.original_label') }}</th>
                                    <th style="width: 35%">{{ trans('plugins/bb-form-builder::form.translation.translated_label') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($model->getAllFields() as $field)
                                    @php
                                        $fieldName = $field['name'] ?? '';
                                        $originalLabel = $field['label'] ?? $fieldName;
                                        $translatedLabel = '';

                                        foreach ($translatedContent as $step => $stepFields) {
                                            if (is_array($stepFields)) {
                                                foreach ($stepFields as $tField) {
                                                    if (($tField['name'] ?? '') === $fieldName && isset($tField['label'])) {
                                                        $translatedLabel = $tField['label'];
                                                        break 2;
                                                    }
                                                }
                                            }
                                        }
                                    @endphp
                                    <tr>
                                        <td><code>{{ $fieldName }}</code></td>
                                        <td class="text-muted">{{ $originalLabel }}</td>
                                        <td>
                                            <input type="text" name="field_labels[{{ $fieldName }}]" class="form-control form-control-sm" value="{{ $translatedLabel }}" placeholder="{{ $originalLabel }}">
                                        </td>
                                    </tr>

                                    @if(in_array($field['type'] ?? '', ['select', 'radio', 'checkbox']) && !empty($field['options']))
                                        @php
                                            $translatedOptions = [];
                                            foreach ($translatedContent as $step => $stepFields) {
                                                if (is_array($stepFields)) {
                                                    foreach ($stepFields as $tField) {
                                                        if (($tField['name'] ?? '') === $fieldName && isset($tField['options'])) {
                                                            foreach ($tField['options'] as $tOpt) {
                                                                $translatedOptions[$tOpt['value'] ?? ''] = $tOpt['label'] ?? '';
                                                            }
                                                            break 2;
                                                        }
                                                    }
                                                }
                                            }
                                        @endphp
                                        @foreach($field['options'] as $option)
                                            @php
                                                $optValue = $option['value'] ?? '';
                                                $optLabel = $option['label'] ?? $optValue;
                                                $optTranslated = $translatedOptions[$optValue] ?? '';
                                            @endphp
                                            <tr class="table-light">
                                                <td class="ps-4"><small class="text-muted">{{ trans('plugins/bb-form-builder::form.translation.option') }}:</small> <code>{{ $optValue }}</code></td>
                                                <td class="text-muted">{{ $optLabel }}</td>
                                                <td>
                                                    <input type="text" name="field_options[{{ $fieldName }}][{{ $optValue }}]" class="form-control form-control-sm" value="{{ $optTranslated }}" placeholder="{{ $optLabel }}">
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif

                                    @if(!empty($field['placeholder']))
                                        @php
                                            $translatedPlaceholder = '';
                                            foreach ($translatedContent as $step => $stepFields) {
                                                if (is_array($stepFields)) {
                                                    foreach ($stepFields as $tField) {
                                                        if (($tField['name'] ?? '') === $fieldName && isset($tField['placeholder'])) {
                                                            $translatedPlaceholder = $tField['placeholder'];
                                                            break 2;
                                                        }
                                                    }
                                                }
                                            }
                                        @endphp
                                        <tr class="table-light">
                                            <td class="ps-4"><small class="text-muted">{{ trans('plugins/bb-form-builder::form.translation.placeholder') }}:</small></td>
                                            <td class="text-muted">{{ $field['placeholder'] }}</td>
                                            <td>
                                                <input type="text" name="field_placeholders[{{ $fieldName }}]" class="form-control form-control-sm" value="{{ $translatedPlaceholder }}" placeholder="{{ $field['placeholder'] }}">
                                            </td>
                                        </tr>
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    @php
                        $originalContent = $model->getRawOriginal('content');
                        $originalContent = is_string($originalContent) ? json_decode($originalContent, true) : $originalContent;
                        $hasMultipleSteps = is_array($originalContent) && count($originalContent) > 1 && !isset($originalContent[0]);
                    @endphp

                    @if($hasMultipleSteps)
                        <hr class="my-4">

                        <h5 class="mb-3">
                            <x-core::icon name="ti ti-list-numbers" class="me-2" />
                            {{ trans('plugins/bb-form-builder::form.translation.step_titles') }}
                        </h5>

                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="table-light">
                                    <tr>
                                        <th style="width: 30%">{{ trans('plugins/bb-form-builder::form.translation.step_id') }}</th>
                                        <th style="width: 35%">{{ trans('plugins/bb-form-builder::form.translation.original_label') }}</th>
                                        <th style="width: 35%">{{ trans('plugins/bb-form-builder::form.translation.translated_label') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $originalStepTitles = $model->properties['step_titles'] ?? [];
                                        $translatedStepTitles = $translatedProperties['step_titles'] ?? [];
                                    @endphp
                                    @foreach(array_keys($originalContent) as $stepKey)
                                        @php
                                            $originalTitle = $originalStepTitles[$stepKey] ?? ucfirst(str_replace(['-', '_'], ' ', $stepKey));
                                            $translatedTitle = $translatedStepTitles[$stepKey] ?? '';
                                        @endphp
                                        <tr>
                                            <td><code>{{ $stepKey }}</code></td>
                                            <td class="text-muted">{{ $originalTitle }}</td>
                                            <td>
                                                <input type="text" name="properties[step_titles][{{ $stepKey }}]" class="form-control form-control-sm" value="{{ $translatedTitle }}" placeholder="{{ $originalTitle }}">
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif

                    <hr class="my-4">

                    <h5 class="mb-3">
                        <x-core::icon name="ti ti-settings" class="me-2" />
                        {{ trans('plugins/bb-form-builder::form.translation.properties') }}
                    </h5>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.form_title') }}</label>
                                <input type="text" name="properties[form_title]" class="form-control" value="{{ $translatedProperties['form_title'] ?? '' }}" placeholder="{{ $model->properties['form_title'] ?? '' }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.form_description') }}</label>
                                <textarea name="properties[form_description]" class="form-control" rows="2" placeholder="{{ $model->properties['form_description'] ?? '' }}">{{ $translatedProperties['form_description'] ?? '' }}</textarea>
                            </div>
                        </div>
                    </div>

                    @if(($model->properties['display_mode'] ?? 'inline') === 'popup')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.popup_button_text') }}</label>
                                    <input type="text" name="properties[popup_button_text]" class="form-control" value="{{ $translatedProperties['popup_button_text'] ?? '' }}" placeholder="{{ $model->properties['popup_button_text'] ?? trans('plugins/bb-form-builder::form.builder.popup_button_text_default') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.popup_title') }}</label>
                                    <input type="text" name="properties[popup_title]" class="form-control" value="{{ $translatedProperties['popup_title'] ?? '' }}" placeholder="{{ $model->properties['popup_title'] ?? '' }}">
                                </div>
                            </div>
                        </div>
                    @endif

                    <hr class="my-4">

                    <h5 class="mb-3">
                        <x-core::icon name="ti ti-send" class="me-2" />
                        {{ trans('plugins/bb-form-builder::form.translation.submission_messages') }}
                    </h5>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.submission_config.on_success') }}</label>
                                <textarea name="submission[on_success][content]" class="form-control" rows="3" placeholder="{{ $model->submission['on_success']['content'] ?? trans('plugins/bb-form-builder::form.messages.submission_success') }}">{{ $translatedSubmission['on_success']['content'] ?? '' }}</textarea>
                                <small class="text-muted">{{ trans('plugins/bb-form-builder::form.translation.leave_empty_for_default') }}</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.submission_config.on_failure') }}</label>
                                <textarea name="submission[on_failure][content]" class="form-control" rows="3" placeholder="{{ $model->submission['on_failure']['content'] ?? trans('plugins/bb-form-builder::form.messages.submission_failed') }}">{{ $translatedSubmission['on_failure']['content'] ?? '' }}</textarea>
                                <small class="text-muted">{{ trans('plugins/bb-form-builder::form.translation.leave_empty_for_default') }}</small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">
                        <x-core::icon name="ti ti-device-floppy" class="me-1" />
                        {{ trans('core/base::forms.save_and_continue') }}
                    </button>
                    <a href="{{ route('bb-form-builder.forms.edit', $model->id) }}" class="btn btn-secondary ms-2">
                        <x-core::icon name="ti ti-arrow-left" class="me-1" />
                        {{ trans('plugins/bb-form-builder::form.translation.back_to_default') }}
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h4 class="card-title mb-0">{{ trans('plugins/language::language.name') }}</h4>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        @foreach($languages as $language)
                            @php
                                $isDefault = $language->lang_code === \Botble\Language\Facades\Language::getDefaultLocaleCode();
                                $isCurrent = $language->lang_code === $refLang || ($language->lang_locale ?? '') === $refLang;
                                $url = $isDefault
                                    ? route('bb-form-builder.forms.edit', $model->id)
                                    : route('bb-form-builder.forms.edit', $model->id) . '?ref_lang=' . $language->lang_code;
                            @endphp
                            <a href="{{ $url }}" class="list-group-item list-group-item-action d-flex align-items-center gap-2 {{ $isCurrent ? 'active' : '' }}">
                                {!! language_flag($language->lang_flag, $language->lang_name) !!}
                                <span>{{ $language->lang_name }}</span>
                                @if($isDefault)
                                    <span class="badge bg-blue text-blue-fg ms-auto">{{ trans('plugins/bb-form-builder::form.translation.default_language') }}</span>
                                @endif
                            </a>
                        @endforeach
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">{{ trans('plugins/bb-form-builder::form.translation.form_preview') }}</h4>
                </div>
                <div class="card-body">
                    <p class="text-muted mb-2"><strong>{{ trans('core/base::forms.name') }}:</strong> {{ $model->name }}</p>
                    <p class="text-muted mb-2"><strong>{{ trans('plugins/bb-form-builder::form.forms.code') }}:</strong> <code>{{ $model->code }}</code></p>
                    <p class="text-muted mb-0"><strong>{{ trans('plugins/bb-form-builder::form.translation.total_fields') }}:</strong> {{ count($model->getAllFields()) }}</p>
                </div>
            </div>
        </div>
    </div>

    {!! Form::close() !!}
@endsection

@push('header')
    <style>
        .bb-form-translation-form .table td,
        .bb-form-translation-form .table th {
            vertical-align: middle;
        }
        .bb-form-translation-form .table-light td {
            background-color: #f8f9fa;
        }
    </style>
@endpush
