@extends(BaseHelper::getAdminMasterLayoutTemplate())

@section('content')
    <div class="fb-admin-page">
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{ trans('plugins/bb-form-builder::form.view.form_info') }}</h4>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label text-muted small">{{ trans('plugins/bb-form-builder::form.forms.name') }}</label>
                        <div class="fw-semibold">{{ $form->name }}</div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label text-muted small">{{ trans('plugins/bb-form-builder::form.forms.code') }}</label>
                        <div><code>{{ $form->code }}</code></div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label text-muted small">{{ trans('plugins/bb-form-builder::form.forms.status') }}</label>
                        <div>{!! $form->status->toHtml() !!}</div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label text-muted small">{{ trans('plugins/bb-form-builder::form.view.fields_count') }}</label>
                        <div>{{ count($form->getAllFields()) }}</div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label text-muted small">{{ trans('core/base::tables.created_at') }}</label>
                        <div>{{ $form->created_at->format('M d, Y H:i') }}</div>
                    </div>

                    <div class="mt-4 d-flex gap-2">
                        <a href="{{ route('bb-form-builder.forms.edit', $form) }}" class="btn btn-primary">
                            <x-core::icon name="ti ti-edit" class="me-1" />
                            {{ trans('core/base::forms.edit') }}
                        </a>
                        <a href="{{ route('bb-form-builder.forms.index') }}" class="btn btn-secondary">
                            <x-core::icon name="ti ti-arrow-left" class="me-1" />
                            {{ trans('core/base::forms.back') }}
                        </a>
                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h4 class="card-title">{{ trans('plugins/bb-form-builder::form.embed.title') }}</h4>
                </div>
                <div class="card-body">
                    @php
                        $shortcodeValue = '[bb-form-builder code="' . $form->code . '"][/bb-form-builder]';
                        $embedUrl = route('public.bb-form-builder.embed', $form->hash);
                        $allowEmbed = $form->properties['allow_embed'] ?? true;
                    @endphp
                    <div class="mb-3">
                        <label class="form-label small">{{ trans('plugins/bb-form-builder::form.embed.shortcode') }}:</label>
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" value="{{ $shortcodeValue }}" readonly>
                            <x-core::copy :copyable-state="$shortcodeValue" class="btn btn-outline-secondary" />
                        </div>
                    </div>
                    @if($allowEmbed)
                        <div class="mb-0">
                            <label class="form-label small">{{ trans('plugins/bb-form-builder::form.embed.url') }}:</label>
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control" value="{{ $embedUrl }}" readonly>
                                <x-core::copy :copyable-state="$embedUrl" class="btn btn-outline-secondary" />
                            </div>
                        </div>
                    @else
                        <div class="text-muted small">
                            <x-core::icon name="ti ti-info-circle" class="me-1" />
                            {{ trans('plugins/bb-form-builder::form.embed.disabled_hint') }}
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="row mb-3">
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader text-muted">{{ trans('plugins/bb-form-builder::form.view.total_submissions') }}</div>
                            </div>
                            <div class="h1 mb-0">{{ number_format($stats['total']) }}</div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader text-muted">{{ trans('plugins/bb-form-builder::form.view.today') }}</div>
                            </div>
                            <div class="h1 mb-0">{{ number_format($stats['today']) }}</div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader text-muted">{{ trans('plugins/bb-form-builder::form.view.this_week') }}</div>
                            </div>
                            <div class="h1 mb-0">{{ number_format($stats['week']) }}</div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader text-muted">{{ trans('plugins/bb-form-builder::form.view.this_month') }}</div>
                            </div>
                            <div class="h1 mb-0">{{ number_format($stats['month']) }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mb-3">
                <div class="card-header">
                    <h4 class="card-title">{{ trans('plugins/bb-form-builder::form.view.submissions_chart') }}</h4>
                </div>
                <div class="card-body">
                    <div id="submissions-chart" style="height: 250px;"></div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{ trans('plugins/bb-form-builder::form.view.recent_submissions') }}</h4>
                </div>
                <div class="card-body">
                    {!! $table->renderTable() !!}
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection

@push('footer')
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var chartElement = document.querySelector("#submissions-chart");
            if (!chartElement) return;

            var chartData = @json($stats['chart_data']);
            var dates = Object.keys(chartData);
            var values = Object.values(chartData);

            var options = {
                series: [{
                    name: '{{ trans('plugins/bb-form-builder::form.view.submissions') }}',
                    data: values
                }],
                chart: {
                    type: 'area',
                    height: 250,
                    toolbar: {
                        show: false
                    },
                    zoom: {
                        enabled: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    curve: 'smooth',
                    width: 2
                },
                fill: {
                    type: 'gradient',
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.4,
                        opacityTo: 0.1,
                        stops: [0, 90, 100]
                    }
                },
                xaxis: {
                    categories: dates,
                    labels: {
                        formatter: function(value) {
                            if (!value) return '';
                            var date = new Date(value);
                            return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric' });
                        },
                        rotate: -45,
                        rotateAlways: false,
                        hideOverlappingLabels: true
                    },
                    tickAmount: 10
                },
                yaxis: {
                    min: 0,
                    forceNiceScale: true,
                    labels: {
                        formatter: function(value) {
                            return Math.round(value);
                        }
                    }
                },
                tooltip: {
                    x: {
                        formatter: function(value, { dataPointIndex }) {
                            var date = new Date(dates[dataPointIndex]);
                            return date.toLocaleDateString('en-US', { weekday: 'short', month: 'short', day: 'numeric', year: 'numeric' });
                        }
                    }
                },
                colors: ['#206bc4'],
                grid: {
                    borderColor: '#e9ecef',
                    strokeDashArray: 4
                }
            };

            var chart = new ApexCharts(chartElement, options);
            chart.render();
        });
    </script>
@endpush
