@php
    $formContent = $form->getTranslatedContent();
    $formProperties = $form->getTranslatedProperties();
    $hasMultipleSteps = is_array($formContent) && count($formContent) > 1 && !isset($formContent[0]);
    $formHash = $form->hash;
    $isEmbed = $isEmbed ?? false;
    $wizardLayout = $formProperties['layout'] ?? 'horizontal';

    $hasPhoneField = false;
    foreach ($form->getAllFields() as $field) {
        if (($field['type'] ?? '') === 'phone') {
            $hasPhoneField = true;
            break;
        }
    }

    if (!$isEmbed && class_exists('Theme')) {
        Theme::asset()->add('bb-form-builder-css', asset('vendor/core/plugins/bb-form-builder/css/form-public.css'), version: '1.2.0');

        if (BaseHelper::isRtlEnabled()) {
            Theme::asset()->add('bb-form-builder-rtl-css', asset('vendor/core/plugins/bb-form-builder/css/form-public-rtl.css'), ['bb-form-builder-css'], version: '1.2.0');
        }

        Theme::asset()->container('footer')->add('bb-form-builder-js', asset('vendor/core/plugins/bb-form-builder/js/form-public.js'), ['jquery'], version: '1.2.0');

        if ($hasPhoneField) {
            Theme::asset()->add('intl-tel-input-css', asset('vendor/core/core/base/libraries/intl-tel-input/css/intlTelInput.min.css'));
            Theme::asset()->container('footer')->add('intl-tel-input-js', asset('vendor/core/core/base/libraries/intl-tel-input/js/intlTelInput.min.js'));
        }
    }

    $stepKeys = $hasMultipleSteps ? array_keys($formContent) : [];

    // Get custom step titles from properties
    $stepTitles = $formProperties['step_titles'] ?? [];
    $getStepTitle = function($stepKey) use ($stepTitles) {
        return $stepTitles[$stepKey] ?? ucfirst(str_replace(['-', '_'], ' ', $stepKey));
    };

    // Get step conditions from properties
    $stepConditions = $formProperties['step_conditions'] ?? [];

    $primaryColor = setting('fb_form_builder_primary_color', '#6366f1');
    $primaryHoverColor = setting('fb_form_builder_primary_hover_color', '#4f46e5');
    $successColor = setting('fb_form_builder_success_color', '#10b981');
    $dangerColor = setting('fb_form_builder_danger_color', '#ef4444');
    $textColor = setting('fb_form_builder_text_color', '#1f2937');
    $borderColor = setting('fb_form_builder_border_color', '#e5e7eb');
    $backgroundColor = setting('fb_form_builder_background_color', '#ffffff');
    $borderRadius = setting('fb_form_builder_border_radius', '8px');
    $enableShadow = setting('fb_form_builder_enable_shadow', true);
    $buttonRadius = setting('fb_form_builder_button_radius', '50px');
    $successMessageTimeout = max(0, (int) setting(
        'fb_form_builder_success_message_timeout',
        config('plugins.bb-form-builder.form-builder.success_message_timeout', 5)
    ));

    $displayMode = $formProperties['display_mode'] ?? 'inline';
    $isPopup = $displayMode === 'popup';
    $popupTrigger = $formProperties['popup_trigger'] ?? 'button';
    $popupButtonText = $formProperties['popup_button_text'] ?? trans('plugins/bb-form-builder::form.builder.popup_button_text_default');
    $popupDelay = (int) ($formProperties['popup_delay'] ?? 3);
    $popupScrollPercentage = (int) ($formProperties['popup_scroll_percentage'] ?? 50);
    $popupTitle = $formProperties['popup_title'] ?? '';
    $popupMaxWidth = $formProperties['popup_max_width'] ?? 'md';
    $popupCloseOnOverlay = (bool) ($formProperties['popup_close_on_overlay'] ?? true);
    $popupShowCloseButton = (bool) ($formProperties['popup_show_close_button'] ?? true);

    $adjustBrightness = function($hex, $percent) {
        $hex = ltrim($hex, '#');
        if (strlen($hex) !== 6) return '#' . $hex;
        $r = hexdec(substr($hex, 0, 2));
        $g = hexdec(substr($hex, 2, 2));
        $b = hexdec(substr($hex, 4, 2));
        $r = max(0, min(255, $r + ($r * $percent / 100)));
        $g = max(0, min(255, $g + ($g * $percent / 100)));
        $b = max(0, min(255, $b + ($b * $percent / 100)));
        return sprintf('#%02x%02x%02x', $r, $g, $b);
    };

    $successHover = $adjustBrightness($successColor, -15);
    $textLight = $adjustBrightness($textColor, 40);
    $bgLight = $adjustBrightness($backgroundColor, -3);

    $containerRadius = $borderRadius === '0' ? '0' : (intval($borderRadius) + 4) . 'px';

    $formSize = $formProperties['form_size'] ?? 'large';
    $formAlignment = $formProperties['form_alignment'] ?? 'center';
    $formStyle = ($styleOverride ?? null) ?: ($formProperties['form_style'] ?? 'default');
    $formMargin = $formProperties['form_margin'] ?? '';
    $formPadding = $formProperties['form_padding'] ?? '';

    $formTitle = $formProperties['form_title'] ?? '';
    $formDescription = $formProperties['form_description'] ?? '';
@endphp

@if($isPopup)
    @if($popupTrigger === 'button')
        <button type="button" class="fb-popup-trigger-btn" data-popup-target="fb-popup-{{ $form->id }}"
            style="
            --fb-primary: {{ $primaryColor }};
            --fb-primary-hover: {{ $primaryHoverColor }};
            --fb-btn-radius: {{ $buttonRadius }};
            ">
            {{ $popupButtonText }}
        </button>
    @endif

    <div class="fb-popup-overlay" id="fb-popup-{{ $form->id }}"
        data-trigger="{{ $popupTrigger }}"
        data-delay="{{ $popupDelay }}"
        data-scroll-percentage="{{ $popupScrollPercentage }}"
        data-close-on-overlay="{{ $popupCloseOnOverlay ? 'true' : 'false' }}"
        @if($disableAutoTrigger ?? false) data-disable-auto-trigger="true" @endif
        aria-hidden="true"
        style="
        --fb-primary: {{ $primaryColor }};
        --fb-primary-hover: {{ $primaryHoverColor }};
        --fb-bg: {{ $backgroundColor }};
        --fb-text: {{ $textColor }};
        --fb-border: {{ $borderColor }};
        --fb-radius: {{ $borderRadius }};
        --fb-radius-lg: {{ $containerRadius }};
        ">
        <div class="fb-popup-modal fb-popup-modal-{{ $popupMaxWidth }}">
            @if($popupShowCloseButton)
                <button type="button" class="fb-popup-close" aria-label="{{ trans('plugins/bb-form-builder::form.popup.close') }}">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                    </svg>
                </button>
            @endif
            @if($popupTitle)
                <div class="fb-popup-header">
                    <h3 class="fb-popup-title">{{ $popupTitle }}</h3>
                </div>
            @endif
            <div class="fb-popup-body">
@endif

<div class="fb-form-container fb-form-size-{{ $formSize }} fb-form-alignment-{{ $formAlignment }} fb-form-style-{{ $formStyle }}{{ $hasMultipleSteps && $wizardLayout === 'vertical' ? ' fb-wizard-vertical' : '' }}{{ $isPopup ? ' fb-form-in-popup' : '' }}"
    data-form-hash="{{ $formHash }}"
    data-success-timeout="{{ $successMessageTimeout }}"
    style="
    --fb-primary: {{ $primaryColor }};
    --fb-primary-hover: {{ $primaryHoverColor }};
    --fb-primary-light: {{ $primaryColor }}26;
    --fb-success: {{ $successColor }};
    --fb-success-hover: {{ $successHover }};
    --fb-danger: {{ $dangerColor }};
    --fb-danger-light: {{ $dangerColor }}1a;
    --fb-text: {{ $textColor }};
    --fb-text-light: {{ $textLight }};
    --fb-border: {{ $borderColor }};
    --fb-bg: {{ $backgroundColor }};
    --fb-bg-light: {{ $bgLight }};
    --fb-radius: {{ $borderRadius }};
    --fb-radius-lg: {{ $containerRadius }};
    --fb-btn-radius: {{ $buttonRadius }};
    --fb-shadow: {{ $enableShadow ? '0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06)' : 'none' }};
    @if($formMargin)margin: {{ $formMargin }};@endif
    @if($formPadding)--fb-form-padding: {{ $formPadding }};@endif
">
    @if($formTitle || $formDescription)
        <div class="fb-form-header">
            @if($formTitle)
                <h2 class="fb-form-title">{{ $formTitle }}</h2>
            @endif
            @if($formDescription)
                <p class="fb-form-description">{{ $formDescription }}</p>
            @endif
        </div>
    @endif

    <form class="fb-form" id="fb-form-{{ $form->id }}" method="POST" action="{{ $isEmbed ? route('api.bb-form-builder.form.submit', $formHash) : route('public.bb-form-builder.submit', $formHash) }}" enctype="multipart/form-data"
        data-msg-required="{{ trans('plugins/bb-form-builder::form.validation.required') }}"
        data-msg-email="{{ trans('plugins/bb-form-builder::form.validation.email') }}"
        data-msg-phone="{{ trans('plugins/bb-form-builder::form.validation.phone') }}"
        data-msg-progress-restored="{{ trans('plugins/bb-form-builder::form.wizard.progress_restored') }}"
        data-msg-start-fresh="{{ trans('plugins/bb-form-builder::form.wizard.start_fresh') }}"
        @if($isEmbed) data-is-embed="true" @endif
    >
        @if(!$isEmbed)@csrf @endif

        <input type="hidden" name="_fb_page_url" class="fb-page-url" value="">
        <input type="hidden" name="_fb_referrer_url" class="fb-referrer-url" value="">

        <div class="fb-form-message"></div>

        @if($hasMultipleSteps)
            <div id="fb-form-wizard-{{ $form->id }}" class="fb-form-wizard fb-wizard-{{ $wizardLayout }}" data-steps="{{ count($stepKeys) }}" data-layout="{{ $wizardLayout }}">
                @if($wizardLayout === 'vertical')
                    <div class="fb-wizard-vertical-container">
                        <div class="fb-wizard-sidebar">
                            <ul class="fb-wizard-steps">
                                @foreach($stepKeys as $index => $stepKey)
                                    <li class="fb-wizard-step{{ $index === 0 ? ' active' : '' }}" data-step="{{ $index }}">
                                        <div class="step-indicator-wrapper">
                                            <span class="step-indicator"></span>
                                            @if($index < count($stepKeys) - 1)
                                                <span class="step-connector"></span>
                                            @endif
                                        </div>
                                        <div class="step-info">
                                            <span class="step-title">{{ $getStepTitle($stepKey) }}</span>
                                            <span class="step-subtitle">{{ trans('plugins/bb-form-builder::form.wizard.step_number', ['current' => $index + 1, 'total' => count($stepKeys)]) }}</span>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>

                        <div class="fb-wizard-main">
                            <div class="fb-restore-notification d-none" role="alert"></div>

                            <div class="fb-wizard-content">
                                @foreach($formContent as $stepKey => $stepFields)
                                    @php
                                        $stepIndex = array_search($stepKey, $stepKeys);
                                        $stepCondition = $stepConditions[$stepKey] ?? null;
                                    @endphp
                                    <div id="fb-panel-{{ $stepKey }}" class="fb-wizard-panel{{ $stepIndex === 0 ? ' active' : '' }}" data-step="{{ $stepIndex }}"
                                        @if($stepCondition && !empty($stepCondition['field']))
                                            data-condition-field="{{ $stepCondition['field'] }}"
                                            data-condition-operator="{{ $stepCondition['operator'] ?? 'checked' }}"
                                            data-condition-value="{{ $stepCondition['value'] ?? '' }}"
                                        @endif
                                    >
                                        <div class="fb-wizard-panel-header">
                                            <h3 class="fb-wizard-panel-title">{{ $getStepTitle($stepKey) }}</h3>
                                        </div>
                                        <div class="row">
                                            @include('plugins/bb-form-builder::forms.partials.fields', ['fields' => $stepFields])
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            @if($form->has_captcha && is_plugin_active('captcha') && Captcha::reCaptchaEnabled())
                                <div class="fb-form-group mt-3">
                                    {!! Captcha::display() !!}
                                </div>
                            @endif

                            @if($form->has_math_captcha && is_plugin_active('captcha') && Captcha::mathCaptchaEnabled())
                                <div class="fb-form-group mt-3">
                                    <label class="form-label">{{ app('math-captcha')->label() }}</label>
                                    {!! app('math-captcha')->input([
                                        'class' => 'form-control',
                                        'placeholder' => app('math-captcha')->getMathLabelOnly() . ' = ?',
                                    ]) !!}
                                </div>
                            @endif

                            <div class="fb-wizard-nav">
                                <div class="fb-wizard-nav-left">
                                    <button type="button" class="fb-wizard-prev" style="display: none;">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m15 18-6-6 6-6"/></svg>
                                        {{ trans('plugins/bb-form-builder::form.wizard.previous') }}
                                    </button>
                                </div>
                                <div class="fb-wizard-nav-right">
                                    <button type="button" class="fb-wizard-next">
                                        {{ trans('plugins/bb-form-builder::form.wizard.next') }}
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m9 18 6-6-6-6"/></svg>
                                    </button>
                                    <button type="submit" class="fb-wizard-submit" style="display: none;">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>
                                        {{ trans('plugins/bb-form-builder::form.submit') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <ul class="fb-wizard-steps">
                        @foreach($stepKeys as $index => $stepKey)
                            <li class="fb-wizard-step{{ $index === 0 ? ' active' : '' }}" data-step="{{ $index }}">
                                <span class="step-indicator"></span>
                                <span class="step-title">{{ $getStepTitle($stepKey) }}</span>
                            </li>
                        @endforeach
                    </ul>

                    <div class="fb-wizard-content">
                        @foreach($formContent as $stepKey => $stepFields)
                            @php
                                $stepIndex = array_search($stepKey, $stepKeys);
                                $stepCondition = $stepConditions[$stepKey] ?? null;
                            @endphp
                            <div id="fb-panel-{{ $stepKey }}" class="fb-wizard-panel{{ $stepIndex === 0 ? ' active' : '' }}" data-step="{{ $stepIndex }}"
                                @if($stepCondition && !empty($stepCondition['field']))
                                    data-condition-field="{{ $stepCondition['field'] }}"
                                    data-condition-operator="{{ $stepCondition['operator'] ?? 'checked' }}"
                                    data-condition-value="{{ $stepCondition['value'] ?? '' }}"
                                @endif
                            >
                                <div class="row">
                                    @include('plugins/bb-form-builder::forms.partials.fields', ['fields' => $stepFields])
                                </div>
                            </div>
                        @endforeach
                    </div>

                    @if($form->has_captcha && is_plugin_active('captcha') && Captcha::reCaptchaEnabled())
                        <div class="fb-form-group mt-3">
                            {!! Captcha::display() !!}
                        </div>
                    @endif

                    @if($form->has_math_captcha && is_plugin_active('captcha') && Captcha::mathCaptchaEnabled())
                        <div class="fb-form-group mt-3">
                            <label class="form-label">{{ app('math-captcha')->label() }}</label>
                            {!! app('math-captcha')->input([
                                'class' => 'form-control',
                                'placeholder' => app('math-captcha')->getMathLabelOnly() . ' = ?',
                            ]) !!}
                        </div>
                    @endif

                    <div class="fb-wizard-nav">
                        <div class="fb-wizard-nav-left">
                            <button type="button" class="fb-wizard-prev" style="display: none;">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m15 18-6-6 6-6"/></svg>
                                {{ trans('plugins/bb-form-builder::form.wizard.previous') }}
                            </button>
                        </div>
                        <div class="fb-wizard-nav-right">
                            <button type="button" class="fb-wizard-next">
                                {{ trans('plugins/bb-form-builder::form.wizard.next') }}
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m9 18 6-6-6-6"/></svg>
                            </button>
                            <button type="submit" class="fb-wizard-submit" style="display: none;">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>
                                {{ trans('plugins/bb-form-builder::form.submit') }}
                            </button>
                        </div>
                    </div>
                @endif
            </div>
        @else
            @if(is_array($formContent) && count($formContent) > 0)
                @php
                    $fields = isset($formContent[0]) ? $formContent : reset($formContent);
                @endphp
                <div class="row">
                    @include('plugins/bb-form-builder::forms.partials.fields', ['fields' => $fields])
                </div>
            @endif
        @endif

        @if(!$hasMultipleSteps)
            @if($form->has_captcha && is_plugin_active('captcha') && Captcha::reCaptchaEnabled())
                <div class="fb-form-group mt-3">
                    {!! Captcha::display() !!}
                </div>
            @endif

            @if($form->has_math_captcha && is_plugin_active('captcha') && Captcha::mathCaptchaEnabled())
                <div class="fb-form-group mt-3">
                    <label class="form-label">{{ app('math-captcha')->label() }}</label>
                    {!! app('math-captcha')->input([
                        'class' => 'form-control',
                        'placeholder' => app('math-captcha')->getMathLabelOnly() . ' = ?',
                    ]) !!}
                </div>
            @endif

            <div class="fb-form-submit">
                <button type="submit" class="fb-form-submit-btn">
                    {{ trans('plugins/bb-form-builder::form.submit') }}
                </button>
            </div>
        @endif
    </form>
</div>

@if($isPopup)
            </div>
        </div>
    </div>
@endif

@if($hasPhoneField && view()->exists('core/base::forms.fields.phone-number-script'))
    @include('core/base::forms.fields.phone-number-script')
@endif
