@foreach($fields as $field)
    @php
        $fieldType = $field['type'] ?? 'text';
        $fieldName = $field['name'] ?? '';
        $fieldLabel = $field['label'] ?? $fieldName;
        $fieldRequired = $field['required'] ?? false;
        $fieldHideLabel = $field['hide_label'] ?? false;
        $shouldShowLabel = ! $fieldHideLabel && trim($fieldLabel) !== '';
        $fieldPlaceholder = $field['placeholder'] ?? '';
        $fieldWidth = $field['width'] ?? '12';
        $fieldOptions = $field['options'] ?? $field['values'] ?? [];
        $fieldDefaultValue = $field['default_value'] ?? null;
    @endphp

    @if($fieldType === 'hidden')
        <input type="hidden" name="{{ $fieldName }}" value="{{ $field['value'] ?? '' }}">
    @elseif($fieldType === 'html')
        <div class="col-md-{{ $fieldWidth }} mb-3 fb-form-field fb-form-field-html">
            <div class="fb-html-content">{!! BaseHelper::clean($field['content'] ?? '') !!}</div>
        </div>
    @else
        <div class="col-md-{{ $fieldWidth }} mb-3 fb-form-field fb-form-field-{{ $fieldType }}">
            @if(!in_array($fieldType, ['checkbox', 'checkbox-group', 'radio', 'radio-group']) && $shouldShowLabel)
                <label class="form-label {{ $fieldRequired ? 'required' : '' }}">{{ $fieldLabel }}</label>
            @endif

            @if($fieldType === 'text' || $fieldType === 'email' || $fieldType === 'number' || $fieldType === 'date' || $fieldType === 'time' || $fieldType === 'datetime')
                <input
                    type="{{ $fieldType === 'datetime' ? 'datetime-local' : $fieldType }}"
                    name="{{ $fieldName }}"
                    class="form-control"
                    placeholder="{{ $fieldPlaceholder }}"
                    {{ $fieldRequired ? 'required' : '' }}
                    @if($fieldDefaultValue) value="{{ $fieldDefaultValue }}" @endif
                    @if(isset($field['min'])) min="{{ $field['min'] }}" @endif
                    @if(isset($field['max'])) max="{{ $field['max'] }}" @endif
                >
                <div class="invalid-feedback"></div>
            @elseif($fieldType === 'phone')
                @php
                    $phoneFieldId = 'fb-phone-' . $fieldName . '-' . Str::random(6);
                    $countryCodeEnabled = $field['enable_country_code'] ?? true;
                @endphp
                <input
                    type="tel"
                    name="{{ $countryCodeEnabled ? $fieldName . '_display' : $fieldName }}"
                    id="{{ $phoneFieldId }}"
                    class="form-control js-phone-number-mask"
                    placeholder="{{ $fieldPlaceholder }}"
                    {{ $fieldRequired ? 'required' : '' }}
                    @if($fieldDefaultValue) value="{{ $fieldDefaultValue }}" @endif
                    @if($countryCodeEnabled) data-country-code-selection="true" @endif
                >
                @if($countryCodeEnabled)
                    <input type="hidden" name="{{ $fieldName }}" id="{{ $phoneFieldId }}-full" class="js-phone-number-full" @if($fieldDefaultValue) value="{{ $fieldDefaultValue }}" @endif>
                @endif
                <div class="invalid-feedback"></div>
            @elseif($fieldType === 'textarea')
                <textarea
                    name="{{ $fieldName }}"
                    class="form-control"
                    rows="{{ $field['rows'] ?? 4 }}"
                    placeholder="{{ $fieldPlaceholder }}"
                    {{ $fieldRequired ? 'required' : '' }}
                >{{ $fieldDefaultValue ?? '' }}</textarea>
                <div class="invalid-feedback"></div>
            @elseif($fieldType === 'select')
                <select name="{{ $fieldName }}" class="form-select" {{ $fieldRequired ? 'required' : '' }}>
                    <option value="">{{ $fieldPlaceholder ?: trans('core/base::forms.select_placeholder') }}</option>
                    @foreach($fieldOptions as $option)
                        @php
                            $optionValue = is_array($option) ? ($option['value'] ?? '') : $option;
                            $optionLabel = is_array($option) ? ($option['label'] ?? $optionValue) : $option;
                            $isSelected = $fieldDefaultValue && $fieldDefaultValue === $optionValue;
                        @endphp
                        <option value="{{ $optionValue }}" {{ $isSelected ? 'selected' : '' }}>{{ $optionLabel }}</option>
                    @endforeach
                </select>
                <div class="invalid-feedback"></div>
            @elseif($fieldType === 'radio' || $fieldType === 'radio-group')
                @php
                    $showRequiredOnOption = $fieldRequired && !$shouldShowLabel;
                @endphp
                @if($shouldShowLabel)
                    <label class="form-label {{ $fieldRequired ? 'required' : '' }}">{{ $fieldLabel }}</label>
                @endif
                @foreach($fieldOptions as $index => $option)
                    @php
                        $optionValue = is_array($option) ? ($option['value'] ?? '') : $option;
                        $optionLabel = is_array($option) ? ($option['label'] ?? $optionValue) : $option;
                        $isChecked = $fieldDefaultValue && $fieldDefaultValue === $optionValue;
                    @endphp
                    <div class="form-check">
                        <input
                            type="radio"
                            name="{{ $fieldName }}"
                            value="{{ $optionValue }}"
                            class="form-check-input"
                            id="{{ $fieldName }}-{{ $index }}"
                            {{ $fieldRequired && $index === 0 ? 'required' : '' }}
                            {{ $isChecked ? 'checked' : '' }}
                        >
                        <label class="form-check-label {{ $showRequiredOnOption && $index === 0 ? 'required' : '' }}" for="{{ $fieldName }}-{{ $index }}">
                            {{ $optionLabel }}
                        </label>
                    </div>
                @endforeach
                <div class="invalid-feedback"></div>
            @elseif($fieldType === 'checkbox' || $fieldType === 'checkbox-group')
                @php
                    $defaultValues = is_array($fieldDefaultValue) ? $fieldDefaultValue : ($fieldDefaultValue ? [$fieldDefaultValue] : []);
                    $showRequiredOnOption = $fieldRequired && !$shouldShowLabel;
                @endphp
                @if($shouldShowLabel)
                    <label class="form-label {{ $fieldRequired ? 'required' : '' }}">{{ $fieldLabel }}</label>
                @endif
                @foreach($fieldOptions as $index => $option)
                    @php
                        $optionValue = is_array($option) ? ($option['value'] ?? '') : $option;
                        $optionLabel = is_array($option) ? ($option['label'] ?? $optionValue) : $option;
                        $isChecked = in_array($optionValue, $defaultValues);
                    @endphp
                    <div class="form-check">
                        <input
                            type="checkbox"
                            name="{{ $fieldName }}[]"
                            value="{{ $optionValue }}"
                            class="form-check-input"
                            id="{{ $fieldName }}-{{ $index }}"
                            {{ $isChecked ? 'checked' : '' }}
                        >
                        <label class="form-check-label {{ $showRequiredOnOption && $index === 0 ? 'required' : '' }}" for="{{ $fieldName }}-{{ $index }}">
                            {{ $optionLabel }}
                        </label>
                    </div>
                @endforeach
                <div class="invalid-feedback"></div>
            @elseif($fieldType === 'file' || $fieldType === 'image')
                @php
                    $isImage = $fieldType === 'image';
                    $defaultAccept = $isImage ? '.jpg,.jpeg,.png,.gif,.webp' : setting('fb_form_builder_allowed_mimes', '.pdf,.doc,.docx,.xls,.xlsx');
                    $fieldAccept = $field['accept'] ?? $defaultAccept;
                    $maxSize = setting('fb_form_builder_max_file_size', 2);

                    $allowedMimeTypes = RvMedia::getConfig('allowed_mime_types');
                    $allowedExtensions = collect(explode(',', $allowedMimeTypes))
                        ->map(fn ($ext) => '.' . ltrim(trim($ext), '.'))
                        ->filter()
                        ->toArray();

                    $requestedExtensions = collect(explode(',', $fieldAccept))
                        ->map(fn ($ext) => '.' . ltrim(trim($ext), '.'))
                        ->filter()
                        ->toArray();

                    $acceptTypes = implode(',', array_intersect($requestedExtensions, $allowedExtensions));

                    if (empty($acceptTypes)) {
                        $acceptTypes = $isImage ? '.jpg,.jpeg,.png,.gif,.webp' : '.pdf,.doc,.docx';
                    }
                @endphp
                <div class="fb-file-upload-wrapper" data-type="{{ $fieldType }}">
                    <div class="fb-file-dropzone">
                        <input
                            type="file"
                            name="{{ $fieldName }}"
                            id="fb-file-{{ $fieldName }}"
                            class="fb-file-input"
                            {{ $fieldRequired ? 'required' : '' }}
                            @if(isset($field['multiple'])) multiple @endif
                            accept="{{ $acceptTypes }}"
                        >
                        <div class="fb-file-dropzone-content">
                            @if($isImage)
                                <svg class="fb-file-icon" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="3" width="18" height="18" rx="2" ry="2"/>
                                    <circle cx="8.5" cy="8.5" r="1.5"/>
                                    <polyline points="21 15 16 10 5 21"/>
                                </svg>
                            @else
                                <svg class="fb-file-icon" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>
                                    <polyline points="17 8 12 3 7 8"/>
                                    <line x1="12" y1="3" x2="12" y2="15"/>
                                </svg>
                            @endif
                            <span class="fb-file-text">{{ trans('plugins/bb-form-builder::form.file_upload.' . ($isImage ? 'choose_image' : 'choose_file')) }}</span>
                        </div>
                        <button type="button" class="fb-file-browse-btn">{{ trans('plugins/bb-form-builder::form.file_upload.browse') }}</button>
                    </div>
                    <div class="fb-file-list"></div>
                    <p class="fb-file-help">{{ trans('plugins/bb-form-builder::form.file_upload.help', ['types' => $acceptTypes, 'size' => $maxSize]) }}</p>
                    <div class="invalid-feedback"></div>
                </div>
            @elseif($fieldType === 'autocomplete')
                @php
                    $autocompleteId = 'fb-autocomplete-' . $fieldName . '-' . Str::random(6);
                    $autocompleteOptions = collect($fieldOptions)->map(function($option) {
                        return is_array($option) ? ($option['label'] ?? $option['value'] ?? '') : $option;
                    })->toJson();
                @endphp
                <div class="fb-autocomplete-wrapper" id="{{ $autocompleteId }}-wrapper">
                    <input
                        type="text"
                        name="{{ $fieldName }}"
                        id="{{ $autocompleteId }}"
                        class="form-control fb-autocomplete-input"
                        placeholder="{{ $fieldPlaceholder }}"
                        {{ $fieldRequired ? 'required' : '' }}
                        @if($fieldDefaultValue) value="{{ $fieldDefaultValue }}" @endif
                        autocomplete="off"
                        data-options="{{ $autocompleteOptions }}"
                    >
                    <div class="fb-autocomplete-dropdown" style="display: none;"></div>
                    <div class="invalid-feedback"></div>
                </div>
            @elseif($fieldType === 'starRating')
                <div class="fb-star-rating" data-field-name="{{ $fieldName }}">
                    <input type="hidden" name="{{ $fieldName }}" value="">
                    <div class="star-rating-container" data-rateyo></div>
                    <div class="invalid-feedback"></div>
                </div>
            @else
                <input
                    type="text"
                    name="{{ $fieldName }}"
                    class="form-control"
                    placeholder="{{ $fieldPlaceholder }}"
                    {{ $fieldRequired ? 'required' : '' }}
                    @if($fieldDefaultValue) value="{{ $fieldDefaultValue }}" @endif
                >
                <div class="invalid-feedback"></div>
            @endif
        </div>
    @endif
@endforeach
