@php
    $hasPhoneField = false;
    foreach ($form->getAllFields() as $field) {
        if (($field['type'] ?? '') === 'phone') {
            $hasPhoneField = true;
            break;
        }
    }
@endphp
<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $form->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('vendor/core/plugins/bb-form-builder/css/form-public.css') }}">
    @if(count($form->content ?? []) > 1)
        <link rel="stylesheet" href="{{ asset('vendor/core/plugins/bb-form-builder/css/smart_wizard.min.css') }}">
    @endif
    @if($hasPhoneField)
        <link rel="stylesheet" href="{{ asset('vendor/core/core/base/libraries/intl-tel-input/css/intlTelInput.min.css') }}">
    @endif
    <style>
        body {
            background: transparent;
            padding: 1rem;
        }
    </style>
</head>
<body>
    @include('plugins/bb-form-builder::forms.render', ['form' => $form, 'isEmbed' => true])

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.0/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    @if(count($form->content ?? []) > 1)
        <script src="{{ asset('vendor/core/plugins/bb-form-builder/js/jquery.smartWizard.min.js') }}"></script>
    @endif
    @if($hasPhoneField)
        <script src="{{ asset('vendor/core/core/base/libraries/intl-tel-input/js/intlTelInput.min.js') }}"></script>
    @endif
    <script src="{{ asset('vendor/core/plugins/bb-form-builder/js/form-public.js') }}"></script>

    <script>
        function notifyParentOfHeight() {
            if (window.parent !== window) {
                window.parent.postMessage({
                    type: 'fb-form-resize',
                    height: document.body.scrollHeight
                }, '*');
            }
        }

        notifyParentOfHeight();

        const observer = new MutationObserver(notifyParentOfHeight);
        observer.observe(document.body, { childList: true, subtree: true, attributes: true });

        window.addEventListener('resize', notifyParentOfHeight);
    </script>
</body>
</html>
