@extends(BaseHelper::getAdminMasterLayoutTemplate())

@section('content')
    @php
        $isEditing = $model && $model->id;
        $formContent = $model->content ?? [];
        $formActions = $model->actions ?? [];
        $formSubmission = $model->submission ?? [
            'on_success' => ['action' => 'show_message', 'content' => trans('plugins/bb-form-builder::form.messages.submission_success')],
            'on_failure' => ['action' => 'show_message', 'content' => trans('plugins/bb-form-builder::form.messages.submission_failed')],
        ];

        $hasMultipleLanguages = false;
        $languages = collect();
        $defaultLanguage = null;

        if ($isEditing && is_plugin_active('language-advanced') && is_plugin_active('language')) {
            $languages = \Botble\Language\Facades\Language::getActiveLanguage(['lang_code', 'lang_flag', 'lang_name', 'lang_is_default']);
            $hasMultipleLanguages = $languages->count() > 1;
            $defaultLanguage = $languages->firstWhere('lang_is_default', 1) ?? $languages->first();
        }
    @endphp

    {!! Form::open([
        'route' => $isEditing ? ['bb-form-builder.forms.update', $model->id] : 'bb-form-builder.forms.store',
        'method' => 'POST',
        'class' => 'bb-form-builder-form',
    ]) !!}
    <input type="hidden" name="active_tab" value="#tab-builder">
    <div id="fb-step-titles-container">
        @if(!empty($model->properties['step_titles']))
            @foreach($model->properties['step_titles'] as $stepId => $stepTitle)
                <input type="hidden" name="properties[step_titles][{{ $stepId }}]" value="{{ $stepTitle }}">
            @endforeach
        @endif
        @if(!empty($model->properties['step_conditions']))
            @foreach($model->properties['step_conditions'] as $stepId => $condition)
                @if(!empty($condition['field']))
                    <input type="hidden" name="properties[step_conditions][{{ $stepId }}][field]" value="{{ $condition['field'] }}">
                    <input type="hidden" name="properties[step_conditions][{{ $stepId }}][operator]" value="{{ $condition['operator'] ?? 'checked' }}">
                    <input type="hidden" name="properties[step_conditions][{{ $stepId }}][value]" value="{{ $condition['value'] ?? '' }}">
                @endif
            @endforeach
        @endif
    </div>

    <div class="fb-builder-wrapper">
        <div class="fb-builder-header">
            <div class="fb-header-left">
                <input type="text" name="name" class="fb-form-name-input" value="{{ $model->name ?? '' }}" placeholder="{{ trans('plugins/bb-form-builder::form.forms.name_placeholder') }}" required>
            </div>
            <div class="fb-header-center">
                <ul class="nav fb-header-tabs" data-bs-toggle="tabs">
                    <li class="nav-item">
                        <a href="#tab-builder" class="nav-link active" data-bs-toggle="tab">
                            {{ trans('plugins/bb-form-builder::form.tabs.builder') }}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#tab-actions" class="nav-link" data-bs-toggle="tab">
                            {{ trans('plugins/bb-form-builder::form.tabs.actions') }}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#tab-settings" class="nav-link" data-bs-toggle="tab">
                            {{ trans('plugins/bb-form-builder::form.tabs.settings') }}
                        </a>
                    </li>
                </ul>
            </div>
            <div class="fb-header-right">
                @if($hasMultipleLanguages)
                    <div class="dropdown me-2">
                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            @if($defaultLanguage)
                                {!! language_flag($defaultLanguage->lang_flag, $defaultLanguage->lang_name) !!}
                                <span class="ms-1">{{ $defaultLanguage->lang_name }}</span>
                            @else
                                <x-core::icon name="ti ti-language" class="me-1" />
                                {{ trans('plugins/language::language.name') }}
                            @endif
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            @foreach($languages as $language)
                                @php
                                    $isDefault = $language->lang_code === \Botble\Language\Facades\Language::getDefaultLocaleCode();
                                    $url = $isDefault
                                        ? route('bb-form-builder.forms.edit', $model->id)
                                        : route('bb-form-builder.forms.edit', $model->id) . '?ref_lang=' . $language->lang_code;
                                @endphp
                                <li>
                                    <a class="dropdown-item d-flex align-items-center gap-2{{ $isDefault ? ' active' : '' }}" href="{{ $url }}">
                                        {!! language_flag($language->lang_flag, $language->lang_name) !!}
                                        <span>{{ $language->lang_name }}</span>
                                        @if($isDefault)
                                            <span class="badge bg-blue text-blue-fg ms-auto">{{ trans('plugins/bb-form-builder::form.translation.default_language') }}</span>
                                        @endif
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <div class="fb-history-buttons">
                    <button type="button" class="btn btn-ghost-secondary" id="btn-undo" disabled title="{{ trans('plugins/bb-form-builder::form.builder.undo') }} (Ctrl+Z)">
                        <x-core::icon name="ti ti-arrow-back-up" />
                    </button>
                    <button type="button" class="btn btn-ghost-secondary" id="btn-redo" disabled title="{{ trans('plugins/bb-form-builder::form.builder.redo') }} (Ctrl+Shift+Z)">
                        <x-core::icon name="ti ti-arrow-forward-up" />
                    </button>
                </div>
                <button type="button" class="btn btn-outline-primary me-2" id="btn-preview-form">
                    <x-core::icon name="ti ti-eye" class="me-1" />
                    {{ trans('plugins/bb-form-builder::form.builder.preview') }}
                </button>
                <button type="submit" class="btn btn-primary">
                    <x-core::icon name="ti ti-device-floppy" class="me-1" />
                    {{ trans('core/base::forms.save_and_continue') }}
                </button>
            </div>
        </div>

        <div class="tab-content fb-tab-content">
            <div class="tab-pane active show" id="tab-builder">
                <div class="fb-builder-layout">
                    <div class="fb-sidebar">
                        <div class="fb-sidebar-header">
                            <h3 class="fb-sidebar-title">{{ trans('plugins/bb-form-builder::form.builder.components') }}</h3>
                            <button type="button" class="btn-close fb-sidebar-close d-lg-none"></button>
                        </div>
                        <div class="fb-sidebar-body">
                            <div class="fb-component-grid" id="fb-component-palette"></div>
                        </div>
                    </div>

                    <div class="fb-canvas">
                        <div class="fb-canvas-header">
                            <div class="fb-canvas-title-wrap">
                                <span class="fb-canvas-title">{{ $model->name ?? trans('plugins/bb-form-builder::form.builder.untitled_form') }}</span>
                            </div>
                            <div class="d-flex align-items-center gap-2">
                                <button type="button" class="btn btn-primary btn-sm fb-mobile-components-toggle d-lg-none my-2">
                                    <x-core::icon name="ti ti-plus" class="me-1" />
                                    {{ trans('plugins/bb-form-builder::form.builder.components') }}
                                </button>
                            </div>
                            <p class="fb-canvas-hint">{{ trans('plugins/bb-form-builder::form.builder.drag_hint') }} {{ trans('plugins/bb-form-builder::form.builder.step_title_hint') }}</p>
                        </div>

                        <div class="fb-canvas-body">
                            <div class="fb-steps-tabs">
                                <div class="fb-steps-nav" id="fb-steps-nav">
                                </div>
                                <button type="button" class="btn btn-ghost-primary btn-sm add-step-btn">
                                    <x-core::icon name="ti ti-plus" />
                                </button>
                            </div>

                            <div id="bb-form-builder">
                                <div id="fb-steps-container"></div>
                            </div>
                        </div>

                        <input type="hidden" name="content" id="form-content">
                    </div>

                    <div class="fb-settings-panel" id="fb-field-settings" style="display: none;">
                        <div class="fb-settings-header">
                            <h3 class="fb-settings-title">{{ trans('plugins/bb-form-builder::form.builder.field_settings') }}</h3>
                            <button type="button" class="btn-close fb-settings-close"></button>
                        </div>
                        <div class="fb-settings-body" id="fb-field-settings-body">
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane" id="tab-actions">
                <div class="fb-actions-layout">
                    <div class="fb-actions-sidebar">
                        <div class="fb-actions-sidebar-header">
                            <h3 class="fb-actions-sidebar-title">{{ trans('plugins/bb-form-builder::form.actions.available_actions') }}</h3>
                        </div>
                        <div class="fb-actions-sidebar-body">
                            <div class="fb-actions-category">
                                <div class="fb-actions-category-title">{{ trans('plugins/bb-form-builder::form.actions.category_notifications') }}</div>
                                @foreach(['email'] as $actionKey)
                                    @if(isset($actions[$actionKey]))
                                        <div class="fb-action-item add-action-btn" data-action="{{ $actionKey }}">
                                            <div class="fb-action-item-icon">
                                                <x-core::icon :name="$actions[$actionKey]['icon'] ?? 'ti ti-bolt'" />
                                            </div>
                                            <div class="fb-action-item-content">
                                                <div class="fb-action-item-name">{{ trans($actions[$actionKey]['name']) }}</div>
                                                <div class="fb-action-item-desc">{{ trans('plugins/bb-form-builder::form.actions.email.description') }}</div>
                                            </div>
                                            <div class="fb-action-item-add">
                                                <x-core::icon name="ti ti-plus" />
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>

                            <div class="fb-actions-category">
                                <div class="fb-actions-category-title">{{ trans('plugins/bb-form-builder::form.actions.category_storage') }}</div>
                                @foreach(['database', 'api'] as $actionKey)
                                    @if(isset($actions[$actionKey]))
                                        <div class="fb-action-item add-action-btn" data-action="{{ $actionKey }}">
                                            <div class="fb-action-item-icon">
                                                <x-core::icon :name="$actions[$actionKey]['icon'] ?? 'ti ti-bolt'" />
                                            </div>
                                            <div class="fb-action-item-content">
                                                <div class="fb-action-item-name">{{ trans($actions[$actionKey]['name']) }}</div>
                                                <div class="fb-action-item-desc">{{ trans('plugins/bb-form-builder::form.actions.' . $actionKey . '.description') }}</div>
                                            </div>
                                            <div class="fb-action-item-add">
                                                <x-core::icon name="ti ti-plus" />
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>

                            <div class="fb-actions-category">
                                <div class="fb-actions-category-title">{{ trans('plugins/bb-form-builder::form.actions.category_integrations') }}</div>
                                @foreach(['mailchimp', 'getresponse'] as $actionKey)
                                    @if(isset($actions[$actionKey]))
                                        <div class="fb-action-item add-action-btn" data-action="{{ $actionKey }}">
                                            <div class="fb-action-item-icon">
                                                <x-core::icon :name="$actions[$actionKey]['icon'] ?? 'ti ti-bolt'" />
                                            </div>
                                            <div class="fb-action-item-content">
                                                <div class="fb-action-item-name">{{ trans($actions[$actionKey]['name']) }}</div>
                                                <div class="fb-action-item-desc">{{ trans('plugins/bb-form-builder::form.actions.' . $actionKey . '.description') }}</div>
                                            </div>
                                            <div class="fb-action-item-add">
                                                <x-core::icon name="ti ti-plus" />
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>

                            <div class="fb-actions-help">
                                <div class="fb-actions-help-title">
                                    <x-core::icon name="ti ti-info-circle" class="me-1" />
                                    {{ trans('plugins/bb-form-builder::form.actions.available_placeholders') }}
                                </div>
                                <p class="fb-actions-help-text">{{ trans('plugins/bb-form-builder::form.actions.placeholder_hint') }}</p>
                                <code class="fb-actions-help-code">[field_name]</code>
                                <p class="fb-actions-help-example">{{ trans('plugins/bb-form-builder::form.actions.placeholder_example') }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="fb-actions-main">
                        <div class="fb-actions-main-header">
                            <h3 class="fb-actions-main-title">{{ trans('plugins/bb-form-builder::form.actions.configured_actions') }}</h3>
                            <span class="fb-actions-count" id="actions-count">{{ collect($formActions)->flatten(1)->count() }}</span>
                        </div>

                        <div class="fb-actions-main-body">
                            @php $hasDatabaseAction = !empty($formActions['database']); @endphp
                            <div class="alert alert-warning d-flex align-items-start gap-2 mb-3" id="no-database-action-warning" style="{{ $hasDatabaseAction ? 'display: none !important;' : '' }}">
                                <x-core::icon name="ti ti-alert-triangle" class="flex-shrink-0 mt-1" />
                                <div>
                                    <strong>{{ trans('plugins/bb-form-builder::form.actions.no_database_action_warning') }}</strong>
                                    <p class="mb-0 small">{{ trans('plugins/bb-form-builder::form.actions.no_database_action_warning_hint') }}</p>
                                </div>
                            </div>

                            <div id="actions-container" class="fb-configured-actions">
                                @php $hasActions = false; @endphp
                                @foreach($formActions as $actionType => $actionInstances)
                                    @foreach($actionInstances as $actionId => $actionData)
                                        @php $hasActions = true; @endphp
                                        @include('plugins/bb-form-builder::partials.action-template', [
                                            'actionKey' => $actionType,
                                            'actionId' => $actionId,
                                            'actionConfig' => $actions[$actionType] ?? [],
                                            'actionData' => $actionData,
                                        ])
                                    @endforeach
                                @endforeach
                            </div>

                            <div class="fb-actions-empty" id="actions-empty-state" style="{{ $hasActions ? 'display: none;' : '' }}">
                                <div class="fb-actions-empty-icon">
                                    <x-core::icon name="ti ti-bolt-off" />
                                </div>
                                <div class="fb-actions-empty-title">{{ trans('plugins/bb-form-builder::form.actions.no_actions') }}</div>
                                <div class="fb-actions-empty-text">{{ trans('plugins/bb-form-builder::form.actions.no_actions_hint') }}</div>
                            </div>

                            <div class="fb-submission-config">
                                <div class="fb-submission-config-header">
                                    <x-core::icon name="ti ti-send" class="me-2" />
                                    <span>{{ trans('plugins/bb-form-builder::form.submission_config.title') }}</span>
                                </div>
                                <div class="fb-submission-config-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="fb-submission-section fb-submission-success">
                                                <div class="fb-submission-section-header">
                                                    <x-core::icon name="ti ti-circle-check" class="me-1" />
                                                    {{ trans('plugins/bb-form-builder::form.submission_config.on_success') }}
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.submission_config.action') }}</label>
                                                    <select name="submission[on_success][action]" class="form-select form-select-sm">
                                                        <option value="show_message" {{ ($formSubmission['on_success']['action'] ?? '') === 'show_message' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.submission_config.show_message') }}
                                                        </option>
                                                        <option value="redirect_to" {{ ($formSubmission['on_success']['action'] ?? '') === 'redirect_to' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.submission_config.redirect_to') }}
                                                        </option>
                                                    </select>
                                                </div>
                                                <div class="mb-0">
                                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.submission_config.content') }}</label>
                                                    <textarea name="submission[on_success][content]" class="form-control form-control-sm" rows="2" placeholder="{{ trans('plugins/bb-form-builder::form.submission_config.message_placeholder') }}">{{ $formSubmission['on_success']['content'] ?? '' }}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="fb-submission-section fb-submission-failure">
                                                <div class="fb-submission-section-header">
                                                    <x-core::icon name="ti ti-circle-x" class="me-1" />
                                                    {{ trans('plugins/bb-form-builder::form.submission_config.on_failure') }}
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.submission_config.action') }}</label>
                                                    <select name="submission[on_failure][action]" class="form-select form-select-sm">
                                                        <option value="show_message" {{ ($formSubmission['on_failure']['action'] ?? '') === 'show_message' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.submission_config.show_message') }}
                                                        </option>
                                                        <option value="redirect_to" {{ ($formSubmission['on_failure']['action'] ?? '') === 'redirect_to' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.submission_config.redirect_to') }}
                                                        </option>
                                                    </select>
                                                </div>
                                                <div class="mb-0">
                                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.submission_config.content') }}</label>
                                                    <textarea name="submission[on_failure][content]" class="form-control form-control-sm" rows="2" placeholder="{{ trans('plugins/bb-form-builder::form.submission_config.failure_placeholder') }}">{{ $formSubmission['on_failure']['content'] ?? '' }}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane" id="tab-settings">
                <div class="fb-settings-container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">{{ trans('plugins/bb-form-builder::form.forms.settings') }}</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.forms.code') }}</label>
                                                <input type="text" name="code" class="form-control" value="{{ $model->code ?? '' }}" placeholder="{{ trans('plugins/bb-form-builder::form.forms.code_placeholder') }}">
                                                <small class="text-muted">{{ trans('plugins/bb-form-builder::form.forms.code_help') }}</small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.forms.status') }}</label>
                                                <select name="status" class="form-select">
                                                    @foreach(Botble\Base\Enums\BaseStatusEnum::labels() as $value => $label)
                                                        <option value="{{ $value }}" {{ ($model->status?->getValue() ?? 'published') === $value ? 'selected' : '' }}>{{ $label }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.form_title') }}</label>
                                                <input type="text" name="properties[form_title]" class="form-control" value="{{ $model->properties['form_title'] ?? '' }}" placeholder="{{ trans('plugins/bb-form-builder::form.builder.form_title_placeholder') }}">
                                                <small class="text-muted">{{ trans('plugins/bb-form-builder::form.builder.form_title_help') }}</small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.form_description') }}</label>
                                                <textarea name="properties[form_description]" class="form-control" rows="2" placeholder="{{ trans('plugins/bb-form-builder::form.builder.form_description_placeholder') }}">{{ $model->properties['form_description'] ?? '' }}</textarea>
                                                <small class="text-muted">{{ trans('plugins/bb-form-builder::form.builder.form_description_help') }}</small>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.wizard_layout') }}</label>
                                                <select name="properties[layout]" class="form-select">
                                                    <option value="horizontal" {{ ($model->properties['layout'] ?? 'horizontal') === 'horizontal' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.layout_horizontal') }}
                                                    </option>
                                                    <option value="vertical" {{ ($model->properties['layout'] ?? 'horizontal') === 'vertical' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.layout_vertical') }}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.form_size') }}</label>
                                                <select name="properties[form_size]" class="form-select">
                                                    <option value="full" {{ ($model->properties['form_size'] ?? 'full') === 'full' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_size_full') }}
                                                    </option>
                                                    <option value="xxl" {{ ($model->properties['form_size'] ?? 'full') === 'xxl' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_size_xxl') }}
                                                    </option>
                                                    <option value="xl" {{ ($model->properties['form_size'] ?? 'full') === 'xl' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_size_xl') }}
                                                    </option>
                                                    <option value="lg" {{ ($model->properties['form_size'] ?? 'full') === 'lg' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_size_lg') }}
                                                    </option>
                                                    <option value="md" {{ ($model->properties['form_size'] ?? 'full') === 'md' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_size_md') }}
                                                    </option>
                                                    <option value="sm" {{ ($model->properties['form_size'] ?? 'full') === 'sm' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_size_sm') }}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.form_alignment') }}</label>
                                                <select name="properties[form_alignment]" class="form-select">
                                                    <option value="start" {{ ($model->properties['form_alignment'] ?? 'center') === 'start' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_alignment_start') }}
                                                    </option>
                                                    <option value="center" {{ ($model->properties['form_alignment'] ?? 'center') === 'center' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_alignment_center') }}
                                                    </option>
                                                    <option value="end" {{ ($model->properties['form_alignment'] ?? 'center') === 'end' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_alignment_end') }}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.form_style') }}</label>
                                                <select name="properties[form_style]" class="form-select">
                                                    <option value="default" {{ ($model->properties['form_style'] ?? 'default') === 'default' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_style_default') }}
                                                    </option>
                                                    <option value="modern" {{ ($model->properties['form_style'] ?? 'default') === 'modern' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_style_modern') }}
                                                    </option>
                                                    <option value="minimal" {{ ($model->properties['form_style'] ?? 'default') === 'minimal' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_style_minimal') }}
                                                    </option>
                                                    <option value="bold" {{ ($model->properties['form_style'] ?? 'default') === 'bold' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_style_bold') }}
                                                    </option>
                                                    <option value="glass" {{ ($model->properties['form_style'] ?? 'default') === 'glass' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.form_style_glass') }}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.form_margin') }}</label>
                                                <input type="text" name="properties[form_margin]" class="form-control" value="{{ $model->properties['form_margin'] ?? '' }}" placeholder="e.g., 20px, 1rem, 20px 0">
                                                <small class="text-muted">{{ trans('plugins/bb-form-builder::form.builder.form_margin_help') }}</small>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.form_padding') }}</label>
                                                <input type="text" name="properties[form_padding]" class="form-control" value="{{ $model->properties['form_padding'] ?? '' }}" placeholder="e.g., 30px, 2rem">
                                                <small class="text-muted">{{ trans('plugins/bb-form-builder::form.builder.form_padding_help') }}</small>
                                            </div>
                                        </div>
                                    </div>

                                    <hr class="my-4">

                                    <h5 class="mb-3">{{ trans('plugins/bb-form-builder::form.builder.popup_settings') }}</h5>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.display_mode') }}</label>
                                                <select name="properties[display_mode]" class="form-select" id="display-mode-select">
                                                    <option value="inline" {{ ($model->properties['display_mode'] ?? 'inline') === 'inline' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.display_mode_inline') }}
                                                    </option>
                                                    <option value="popup" {{ ($model->properties['display_mode'] ?? 'inline') === 'popup' ? 'selected' : '' }}>
                                                        {{ trans('plugins/bb-form-builder::form.builder.display_mode_popup') }}
                                                    </option>
                                                </select>
                                                <small class="text-muted">{{ trans('plugins/bb-form-builder::form.builder.display_mode_help') }}</small>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="popup-settings-container" style="{{ ($model->properties['display_mode'] ?? 'inline') !== 'popup' ? 'display: none;' : '' }}">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.popup_trigger') }}</label>
                                                    <select name="properties[popup_trigger]" class="form-select" id="popup-trigger-select">
                                                        <option value="button" {{ ($model->properties['popup_trigger'] ?? 'button') === 'button' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.builder.popup_trigger_button') }}
                                                        </option>
                                                        <option value="time_delay" {{ ($model->properties['popup_trigger'] ?? 'button') === 'time_delay' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.builder.popup_trigger_time_delay') }}
                                                        </option>
                                                        <option value="scroll" {{ ($model->properties['popup_trigger'] ?? 'button') === 'scroll' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.builder.popup_trigger_scroll') }}
                                                        </option>
                                                        <option value="exit_intent" {{ ($model->properties['popup_trigger'] ?? 'button') === 'exit_intent' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.builder.popup_trigger_exit_intent') }}
                                                        </option>
                                                    </select>
                                                    <small class="text-warning" id="popup-exit-intent-help" style="{{ ($model->properties['popup_trigger'] ?? 'button') !== 'exit_intent' ? 'display: none;' : '' }}">
                                                        <x-core::icon name="ti ti-info-circle" class="me-1" />
                                                        {{ trans('plugins/bb-form-builder::form.builder.popup_trigger_exit_intent_help') }}
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="col-md-4" id="popup-button-text-container" style="{{ ($model->properties['popup_trigger'] ?? 'button') !== 'button' ? 'display: none;' : '' }}">
                                                <div class="mb-3">
                                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.popup_button_text') }}</label>
                                                    <input type="text" name="properties[popup_button_text]" class="form-control" value="{{ $model->properties['popup_button_text'] ?? trans('plugins/bb-form-builder::form.builder.popup_button_text_default') }}" placeholder="{{ trans('plugins/bb-form-builder::form.builder.popup_button_text_default') }}">
                                                </div>
                                            </div>
                                            <div class="col-md-4" id="popup-delay-container" style="{{ ($model->properties['popup_trigger'] ?? 'button') !== 'time_delay' ? 'display: none;' : '' }}">
                                                <div class="mb-3">
                                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.popup_delay') }}</label>
                                                    <input type="number" name="properties[popup_delay]" class="form-control" value="{{ $model->properties['popup_delay'] ?? 3 }}" min="1" max="300">
                                                    <small class="text-muted">{{ trans('plugins/bb-form-builder::form.builder.popup_delay_help') }}</small>
                                                </div>
                                            </div>
                                            <div class="col-md-4" id="popup-scroll-container" style="{{ ($model->properties['popup_trigger'] ?? 'button') !== 'scroll' ? 'display: none;' : '' }}">
                                                <div class="mb-3">
                                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.popup_scroll_percentage') }}</label>
                                                    <input type="number" name="properties[popup_scroll_percentage]" class="form-control" value="{{ $model->properties['popup_scroll_percentage'] ?? 50 }}" min="1" max="100">
                                                    <small class="text-muted">{{ trans('plugins/bb-form-builder::form.builder.popup_scroll_percentage_help') }}</small>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.popup_title') }}</label>
                                                    <input type="text" name="properties[popup_title]" class="form-control" value="{{ $model->properties['popup_title'] ?? '' }}" placeholder="{{ trans('plugins/bb-form-builder::form.builder.popup_title_placeholder') }}">
                                                    <small class="text-muted">{{ trans('plugins/bb-form-builder::form.builder.popup_title_help') }}</small>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label class="form-label">{{ trans('plugins/bb-form-builder::form.builder.popup_max_width') }}</label>
                                                    <select name="properties[popup_max_width]" class="form-select">
                                                        <option value="sm" {{ ($model->properties['popup_max_width'] ?? 'md') === 'sm' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.builder.popup_max_width_sm') }}
                                                        </option>
                                                        <option value="md" {{ ($model->properties['popup_max_width'] ?? 'md') === 'md' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.builder.popup_max_width_md') }}
                                                        </option>
                                                        <option value="lg" {{ ($model->properties['popup_max_width'] ?? 'md') === 'lg' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.builder.popup_max_width_lg') }}
                                                        </option>
                                                        <option value="xl" {{ ($model->properties['popup_max_width'] ?? 'md') === 'xl' ? 'selected' : '' }}>
                                                            {{ trans('plugins/bb-form-builder::form.builder.popup_max_width_xl') }}
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-6">
                                                <label class="form-check form-switch mb-0">
                                                    <input type="hidden" name="properties[popup_close_on_overlay]" value="0">
                                                    <input type="checkbox" name="properties[popup_close_on_overlay]" class="form-check-input" value="1" {{ ($model->properties['popup_close_on_overlay'] ?? true) ? 'checked' : '' }}>
                                                    <span class="form-check-label">{{ trans('plugins/bb-form-builder::form.builder.popup_close_on_overlay') }}</span>
                                                </label>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-check form-switch mb-0">
                                                    <input type="hidden" name="properties[popup_show_close_button]" value="0">
                                                    <input type="checkbox" name="properties[popup_show_close_button]" class="form-check-input" value="1" {{ ($model->properties['popup_show_close_button'] ?? true) ? 'checked' : '' }}>
                                                    <span class="form-check-label">{{ trans('plugins/bb-form-builder::form.builder.popup_show_close_button') }}</span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <hr class="my-4">

                                    <h5 class="mb-3">{{ trans('plugins/bb-form-builder::form.builder.other_settings') }}</h5>

                                    <div class="row">
                                        @if(is_plugin_active('captcha'))
                                            @if(Captcha::reCaptchaEnabled())
                                                <div class="col-md-4 mb-3">
                                                    <label class="form-check form-switch mb-0">
                                                        <input type="hidden" name="properties[has_captcha]" value="0">
                                                        <input type="checkbox" name="properties[has_captcha]" class="form-check-input" value="1" {{ ($model->properties['has_captcha'] ?? false) ? 'checked' : '' }}>
                                                        <span class="form-check-label">{{ trans('plugins/bb-form-builder::form.builder.has_captcha') }}</span>
                                                    </label>
                                                </div>
                                            @else
                                                <input type="hidden" name="properties[has_captcha]" value="0">
                                            @endif
                                            @if(Captcha::mathCaptchaEnabled())
                                                <div class="col-md-4 mb-3">
                                                    <label class="form-check form-switch mb-0">
                                                        <input type="hidden" name="properties[has_math_captcha]" value="0">
                                                        <input type="checkbox" name="properties[has_math_captcha]" class="form-check-input" value="1" {{ ($model->properties['has_math_captcha'] ?? false) ? 'checked' : '' }}>
                                                        <span class="form-check-label">{{ trans('plugins/bb-form-builder::form.builder.has_math_captcha') }}</span>
                                                    </label>
                                                </div>
                                            @else
                                                <input type="hidden" name="properties[has_math_captcha]" value="0">
                                            @endif
                                        @else
                                            <input type="hidden" name="properties[has_captcha]" value="0">
                                            <input type="hidden" name="properties[has_math_captcha]" value="0">
                                        @endif
                                        <div class="col-md-4 mb-3">
                                            <label class="form-check form-switch mb-0">
                                                <input type="hidden" name="properties[allow_embed]" value="0">
                                                <input type="checkbox" name="properties[allow_embed]" class="form-check-input" value="1" {{ ($model->properties['allow_embed'] ?? true) ? 'checked' : '' }}>
                                                <span class="form-check-label">{{ trans('plugins/bb-form-builder::form.builder.allow_embed') }}</span>
                                            </label>
                                            <small class="text-muted d-block mt-1">{{ trans('plugins/bb-form-builder::form.builder.allow_embed_help') }}</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            @if($isEditing)
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h4 class="card-title mb-0">{{ trans('plugins/bb-form-builder::form.embed.title') }}</h4>
                                    </div>
                                    <div class="card-body">
                                        <p class="text-muted small">{{ trans('plugins/bb-form-builder::form.embed.description') }}</p>
                                        @php
                                            $shortcodeValue = '[bb-form-builder code="' . $model->code . '"][/bb-form-builder]';
                                            $embedUrlFriendly = route('public.bb-form-builder.embed-by-code', $model->code);
                                            $embedUrlSecure = route('public.bb-form-builder.embed', $model->hash);
                                            $allowEmbed = $model->properties['allow_embed'] ?? true;
                                        @endphp
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label class="form-label small">{{ trans('plugins/bb-form-builder::form.embed.shortcode') }}:</label>
                                                    <div class="input-group input-group-sm">
                                                        <input type="text" class="form-control" value="{{ $shortcodeValue }}" readonly>
                                                        <x-core::copy :copyable-state="$shortcodeValue" class="btn btn-outline-secondary" />
                                                    </div>
                                                </div>
                                                <div class="embed-url-section mb-3" style="{{ !$allowEmbed ? 'opacity: 0.5;' : '' }}">
                                                    <label class="form-label small">
                                                        {{ trans('plugins/bb-form-builder::form.embed.url_friendly') }}:
                                                        <span class="badge bg-green-lt ms-1">{{ trans('plugins/bb-form-builder::form.embed.friendly') }}</span>
                                                    </label>
                                                    <div class="input-group input-group-sm">
                                                        <input type="text" class="form-control" value="{{ $embedUrlFriendly }}" readonly>
                                                        <x-core::copy :copyable-state="$embedUrlFriendly" class="btn btn-outline-secondary" />
                                                    </div>
                                                </div>
                                                <div class="embed-url-section mb-3" style="{{ !$allowEmbed ? 'opacity: 0.5;' : '' }}">
                                                    <label class="form-label small">
                                                        {{ trans('plugins/bb-form-builder::form.embed.url_secure') }}:
                                                        <span class="badge bg-blue-lt ms-1">{{ trans('plugins/bb-form-builder::form.embed.secure') }}</span>
                                                    </label>
                                                    <div class="input-group input-group-sm">
                                                        <input type="text" class="form-control" value="{{ $embedUrlSecure }}" readonly>
                                                        <x-core::copy :copyable-state="$embedUrlSecure" class="btn btn-outline-secondary" />
                                                    </div>
                                                    @if(!$allowEmbed)
                                                        <small class="text-warning">{{ trans('plugins/bb-form-builder::form.embed.disabled_hint') }}</small>
                                                    @endif
                                                </div>
                                                <div class="export-section">
                                                    <label class="form-label small">{{ trans('plugins/bb-form-builder::form.export_import.title') }}:</label>
                                                    <a href="{{ route('bb-form-builder.forms.export', $model->id) }}" class="btn btn-outline-primary btn-sm w-100">
                                                        <x-core::icon name="ti ti-download" class="me-1" />
                                                        {{ trans('plugins/bb-form-builder::form.export_import.export') }}
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="col-md-8">
                                                <div class="iframe-embed-section" style="{{ !$allowEmbed ? 'opacity: 0.5;' : '' }}">
                                                    <label class="form-label small">{{ trans('plugins/bb-form-builder::form.embed.iframe_code') }}:</label>
                                                    <p class="text-muted small mb-2">{{ trans('plugins/bb-form-builder::form.embed.iframe_code_hint') }}</p>
                                                    @php
                                                        $iframeCodeFriendly = '<iframe' . "\n" .
                                                            '    src="' . $embedUrlFriendly . '"' . "\n" .
                                                            '    width="100%"' . "\n" .
                                                            '    height="500"' . "\n" .
                                                            '    frameborder="0"' . "\n" .
                                                            '></iframe>';
                                                        $iframeCodeSecure = '<iframe' . "\n" .
                                                            '    src="' . $embedUrlSecure . '"' . "\n" .
                                                            '    width="100%"' . "\n" .
                                                            '    height="500"' . "\n" .
                                                            '    frameborder="0"' . "\n" .
                                                            '></iframe>';
                                                    @endphp
                                                    <div class="mb-2">
                                                        <span class="badge bg-green-lt mb-1">{{ trans('plugins/bb-form-builder::form.embed.friendly') }}</span>
                                                        <div class="position-relative">
                                                            <pre class="bg-dark text-white border rounded p-2 mb-0" style="font-size: 12px; white-space: pre-wrap; word-break: break-all;"><code>{{ $iframeCodeFriendly }}</code></pre>
                                                            <x-core::copy :copyable-state="$iframeCodeFriendly" class="btn btn-sm btn-outline-secondary position-absolute" style="top: 5px; right: 5px;" />
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <span class="badge bg-blue-lt mb-1">{{ trans('plugins/bb-form-builder::form.embed.secure') }}</span>
                                                        <div class="position-relative">
                                                            <pre class="bg-dark text-white border rounded p-2 mb-0" style="font-size: 12px; white-space: pre-wrap; word-break: break-all;"><code>{{ $iframeCodeSecure }}</code></pre>
                                                            <x-core::copy :copyable-state="$iframeCodeSecure" class="btn btn-sm btn-outline-secondary position-absolute" style="top: 5px; right: 5px;" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="js-embed-section mt-4" style="{{ !$allowEmbed ? 'opacity: 0.5;' : '' }}">
                                                    <label class="form-label small">{{ trans('plugins/bb-form-builder::form.embed.js_embed') }}:</label>
                                                    <p class="text-muted small mb-2">{{ trans('plugins/bb-form-builder::form.embed.js_embed_hint') }}</p>
                                                    @php
                                                        $embedVersion = '1.2.0';
                                                        $jsEmbedCodeFriendly = '<div id="bb-form-' . $model->code . '"></div>' . "\n" .
                                                            '<script src="' . url('/vendor/core/plugins/bb-form-builder/js/embed.js') . '?v=' . $embedVersion . '"></script>' . "\n" .
                                                            '<script>' . "\n" .
                                                            '    document.addEventListener("DOMContentLoaded", function() {' . "\n" .
                                                            '        BbFormBuilder.embed({' . "\n" .
                                                            '            container: "#bb-form-' . $model->code . '",' . "\n" .
                                                            '            formCode: "' . $model->code . '",' . "\n" .
                                                            '            version: "' . $embedVersion . '"' . "\n" .
                                                            '        });' . "\n" .
                                                            '    });' . "\n" .
                                                            '</script>';
                                                        $jsEmbedCodeSecure = '<div id="bb-form-' . $model->hash . '"></div>' . "\n" .
                                                            '<script src="' . url('/vendor/core/plugins/bb-form-builder/js/embed.js') . '?v=' . $embedVersion . '"></script>' . "\n" .
                                                            '<script>' . "\n" .
                                                            '    document.addEventListener("DOMContentLoaded", function() {' . "\n" .
                                                            '        BbFormBuilder.embed({' . "\n" .
                                                            '            container: "#bb-form-' . $model->hash . '",' . "\n" .
                                                            '            formCode: "' . $model->hash . '",' . "\n" .
                                                            '            version: "' . $embedVersion . '"' . "\n" .
                                                            '        });' . "\n" .
                                                            '    });' . "\n" .
                                                            '</script>';
                                                    @endphp
                                                    <div class="mb-2">
                                                        <span class="badge bg-green-lt mb-1">{{ trans('plugins/bb-form-builder::form.embed.friendly') }}</span>
                                                        <div class="position-relative">
                                                            <pre class="bg-dark text-white border rounded p-2 mb-0" style="font-size: 12px; white-space: pre-wrap; word-break: break-all;"><code>{{ $jsEmbedCodeFriendly }}</code></pre>
                                                            <x-core::copy :copyable-state="$jsEmbedCodeFriendly" class="btn btn-sm btn-outline-secondary position-absolute" style="top: 5px; right: 5px;" />
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <span class="badge bg-blue-lt mb-1">{{ trans('plugins/bb-form-builder::form.embed.secure') }}</span>
                                                        <div class="position-relative">
                                                            <pre class="bg-dark text-white border rounded p-2 mb-0" style="font-size: 12px; white-space: pre-wrap; word-break: break-all;"><code>{{ $jsEmbedCodeSecure }}</code></pre>
                                                            <x-core::copy :copyable-state="$jsEmbedCodeSecure" class="btn btn-sm btn-outline-secondary position-absolute" style="top: 5px; right: 5px;" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="embed-instructions mt-3">
                                                    <label class="form-label small">
                                                        <x-core::icon name="ti ti-info-circle" class="me-1" />
                                                        {{ trans('plugins/bb-form-builder::form.embed.botble_site_instructions') }}:
                                                    </label>
                                                    <div class="alert alert-info small mb-0 p-2 d-block">
                                                        <p class="mb-2">{{ trans('plugins/bb-form-builder::form.embed.botble_site_step_1') }}</p>
                                                        <pre class="bg-dark text-white rounded p-2 mb-2" style="font-size: 11px;">CMS_IFRAME_ALLOWED_URLS={{ parse_url(url('/'), PHP_URL_HOST) }}</pre>
                                                        <p class="mb-0">{{ trans('plugins/bb-form-builder::form.embed.botble_site_step_2') }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Screen reader announcements for keyboard navigation (accessibility) --}}
        <div aria-live="polite" id="fb-announcer" class="visually-hidden"></div>
    </div>

    {!! Form::close() !!}

    <div class="modal modal-blur fade" id="form-preview-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ trans('plugins/bb-form-builder::form.builder.preview') }}</h5>
                    <div class="fb-preview-device-switcher">
                        <button type="button" class="btn btn-ghost-secondary btn-sm active" data-device="desktop" title="Desktop">
                            <x-core::icon name="ti ti-device-desktop" />
                        </button>
                        <button type="button" class="btn btn-ghost-secondary btn-sm" data-device="tablet" title="Tablet">
                            <x-core::icon name="ti ti-device-tablet" />
                        </button>
                        <button type="button" class="btn btn-ghost-secondary btn-sm" data-device="mobile" title="Mobile">
                            <x-core::icon name="ti ti-device-mobile" />
                        </button>
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body fb-preview-body">
                    <div class="fb-preview-frame" data-device="desktop">
                        <div class="fb-preview-content" id="fb-preview-content"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @foreach($actions as $actionKey => $actionConfig)
        <template id="action-template-{{ $actionKey }}">
            @include('plugins/bb-form-builder::partials.action-template', [
                'actionKey' => $actionKey,
                'actionId' => '__ACTION_ID__',
                'actionConfig' => $actionConfig,
                'actionData' => [],
            ])
        </template>
    @endforeach
@endsection

@push('header')
    @if (BaseHelper::adminLanguageDirection() === 'rtl')
        <link rel="stylesheet" href="{{ asset('vendor/core/plugins/bb-form-builder/css/form-builder-rtl.css') }}?v={{ get_cms_version() }}">
        <link rel="stylesheet" href="{{ asset('vendor/core/plugins/bb-form-builder/css/form-public-rtl.css') }}?v={{ get_cms_version() }}">
    @else
        <link rel="stylesheet" href="{{ asset('vendor/core/plugins/bb-form-builder/css/form-builder.css') }}?v={{ get_cms_version() }}">
        <link rel="stylesheet" href="{{ asset('vendor/core/plugins/bb-form-builder/css/form-public.css') }}?v={{ get_cms_version() }}">
    @endif
@endpush

@push('footer')
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <script src="{{ asset('vendor/core/plugins/bb-form-builder/js/form-builder.js') }}"></script>
    <script>
        window.fbFormBuilderConfig = {
            formContent: @json($formContent ?? []),
            actions: @json($actions ?? []),
        };
    </script>
    {!! $form->renderValidatorJs() !!}
    <script>
        $(document).ready(function() {
            var activeTab = window.location.hash;
            if (!activeTab) {
                activeTab = localStorage.getItem('fb_active_tab');
            }

            if (activeTab && $(activeTab).length > 0) {
                var tabTrigger = $('.nav-link[href="' + activeTab + '"]');
                if (tabTrigger.length > 0) {
                    var tabInstance = new bootstrap.Tab(tabTrigger[0]);
                    tabInstance.show();
                    $('input[name="active_tab"]').val(activeTab);
                }
            }

            $('a[data-bs-toggle="tab"]').on('shown.bs.tab', function (e) {
                var tab = $(e.target).attr('href');
                $('input[name="active_tab"]').val(tab);
                localStorage.setItem('fb_active_tab', tab);

                if(history.pushState) {
                    history.pushState(null, null, tab);
                } else {
                    window.location.hash = tab;
                }
            });

            $('#display-mode-select').on('change', function() {
                var isPopup = $(this).val() === 'popup';
                $('#popup-settings-container').toggle(isPopup);
            });

            $('#popup-trigger-select').on('change', function() {
                var trigger = $(this).val();
                $('#popup-button-text-container').toggle(trigger === 'button');
                $('#popup-delay-container').toggle(trigger === 'time_delay');
                $('#popup-scroll-container').toggle(trigger === 'scroll');
                $('#popup-exit-intent-help').toggle(trigger === 'exit_intent');
            });
        });
    </script>
@endpush
