<?php

return [
    'menu' => [
        'title' => '表單生成器',
        'forms' => '表單',
        'submissions' => '提交',
        'reports' => 'Reports',
        'settings' => '設置',
    ],
    'forms' => [
        'title' => '表單',
        'create' => '創建表單',
        'edit' => '編輯表單',
        'view' => 'View: :name',
        'name' => '表單名稱',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => '代碼',
        'code_help' => '留空以自動生成。在短代碼中使用：[bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => '例如：contact-form',
        'status' => '狀態',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => '提交數',
        'created_at' => '創建時間',
        'actions' => '操作',
        'settings' => '設置',
        'fields' => '字段',
        'short_code' => '短代碼',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => '提交',
    'tabs' => [
        'builder' => '生成器',
        'actions' => '操作',
        'submission' => '提交',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => '表單生成器',
        'components' => 'Form Components',
        'has_captcha' => '啟用 reCAPTCHA',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => '添加步驟',
        'form_title' => '表單標題',
        'form_title_placeholder' => '例如：聯繫我們',
        'form_title_help' => '顯示在表單上方的可選標題',
        'form_description' => '表單描述',
        'form_description_placeholder' => '例如：填寫以下表單，我們將在24小時內回覆您。',
        'form_description_help' => '顯示在標題下方的可選描述',
        'field_types' => '字段類型',
        'field_settings' => 'Field Settings',
        'wizard_layout' => '嚮導佈局',
        'wizard_layout_help' => '選擇多步驟表單如何顯示其進度指示器',
        'layout_horizontal' => '水平（頂部步驟）',
        'layout_vertical' => '垂直（左側步驟）',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'Form Alignment',
        'form_alignment_start' => 'Left (Start)',
        'form_alignment_center' => 'Center',
        'form_alignment_end' => 'Right (End)',
        'form_spacing' => '間距',
        'form_margin' => '外邊距',
        'form_margin_help' => '表單外部的空間（例如：20px、1rem、20px 0）',
        'form_padding' => '內邊距',
        'form_padding_help' => '表單內部的空間（例如：20px、1rem、30px 20px）',
        'form_style' => 'Form Style',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => '離開意圖',
        'popup_trigger_exit_intent_help' => '僅適用於有滑鼠的桌面裝置。當用戶將游標移出頁面時觸發。每次會話顯示一次。',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => '表單提交',
        'view' => '查看提交',
        'info' => '提交信息',
        'form' => '表單',
        'identifier' => 'Identifier',
        'data' => '提交數據',
        'submitted_at' => '提交時間',
        'ip_address' => 'IP 地址',
        'user_agent' => '用戶代理',
        'page_url' => '頁面URL',
        'referrer_url' => '來源URL',
        'url_tracking_title' => '提交來源',
        'no_submissions' => '未找到提交。',
        'back' => '返回',
        'delete' => '刪除',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => '提交設置',
        'on_success' => '成功時',
        'on_failure' => '失敗時',
        'action' => '操作',
        'content' => '內容',
        'show_message' => '顯示消息',
        'redirect_to' => '重定向到',
        'message_placeholder' => '感謝您的提交！',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://example.com/thank-you',
    ],
    'actions' => [
        'title' => '表單操作',
        'add' => '添加操作',
        'configure' => '配置操作',
        'placeholder_hint' => '使用 [field_name] 插入字段值',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => '點擊左側面板中的操作將其添加到表單',
        'no_database_action_warning' => '未配置「儲存到資料庫」操作',
        'no_database_action_warning_hint' => '表單提交資料將不會儲存在資料庫中，也不會出現在提交頁面。',

        'email' => [
            'name' => '電子郵件通知',
            'description' => 'Send email notifications when form is submitted',
            'to' => '收件人',
            'to_help' => '輸入收件人電子郵件地址，用逗號分隔',
            'subject' => '主題',
            'subject_help' => '使用 [field_name] 插入字段值',
            'body' => '正文',
            'body_help' => '使用 [field_name] 插入字段值',
        ],
        'database' => [
            'name' => '保存到數據庫',
            'description' => 'Store submissions in the database',
            'unique_field' => '唯一字段',
            'unique_field_help' => '用於防止重複提交的字段名稱（可選）',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => '端點 URL',
            'method' => 'HTTP 方法',
            'body' => '請求正文 (JSON)',
            'body_help' => '使用 [field_name] 在 JSON 中插入字段值',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => '表單',
        'description' => '顯示表單',
        'form' => '選擇表單',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => '表單生成器設置',
        'description' => '配置表單生成器設置',
        'allowed_mimes' => '允許的文件類型',
        'allowed_mimes_help' => '允許的文件擴展名的逗號分隔列表',
        'max_file_size' => '最大文件大小 (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => '外觀設置',
            'description' => '自定義表單的外觀',
            'primary_color' => '主色',
            'primary_color_help' => '用於按鈕、活動狀態和焦點環',
            'primary_hover_color' => '主色懸停',
            'success_color' => '成功色',
            'success_color_help' => '用於成功消息和已完成步驟',
            'danger_color' => '危險色',
            'danger_color_help' => '用於錯誤消息和驗證錯誤',
            'text_color' => '文本顏色',
            'border_color' => '邊框顏色',
            'background_color' => '背景色',
            'border_radius' => '邊框半徑',
            'border_radius_options' => [
                'none' => '無 (0)',
                'small' => '小 (4px)',
                'medium' => '中 (8px)',
                'large' => '大 (12px)',
                'extra_large' => '特大 (16px)',
                'pill' => '藥丸',
            ],
            'enable_shadow' => '啟用陰影',
            'enable_shadow_help' => '為表單容器添加微妙的陰影效果',
            'button_radius' => '按鈕邊框半徑',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => '未找到表單。',
        'form_inactive' => '此表單未激活。',
        'submission_success' => '感謝您的提交！',
        'submission_failed' => '發生錯誤。請重試。',
        'captcha_invalid' => '請完成驗證碼。',
        'duplicate_submission' => '您已經提交過此表單。',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => '激活',
            'inactive' => '未激活',
        ],
    ],
    'embed' => [
        'title' => '嵌入代碼',
        'description' => '複製此代碼以在外部網站上嵌入表單',
        'copy' => '複製',
        'copied' => '已複製！',
        'shortcode' => '短代碼',
        'url' => '嵌入 URL',
                'url_friendly' => '嵌入URL',
        'url_secure' => '嵌入URL',
        'friendly' => '友好',
        'secure' => '安全',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => '然後在平台管理 → 快取管理中清除快取配置。',
        'botble_site_step_1' => '將此添加到目標Botble網站的.env文件中:',
        'botble_site_instructions' => '嵌入到另一個Botble網站',
        'iframe_code_hint' => '使用編輯器中的HTML按鈕或自定義HTML UI塊來嵌入此iframe。',
        'js_embed' => '透過JavaScript嵌入',
        'js_embed_hint' => '為了更好的控制和響應能力，請使用我們的JavaScript嵌入代碼:',
        'iframe_code' => 'Iframe嵌入代碼',
    ],

    'export_import' => [
        'title' => '匯出 / 匯入',
        'description' => '將此表單匯出為JSON或從其他網站匯入',
        'export' => '匯出為JSON',
        'export_description' => '下載此表單的JSON檔案以在其他網站使用',
        'import' => '匯入表單',
        'import_description' => '從JSON檔案匯入表單',
        'import_button' => '從JSON匯入',
        'select_file' => '選擇JSON檔案',
        'import_success' => '表單匯入成功！',
        'import_error' => '表單匯入失敗。請檢查檔案格式。',
        'invalid_file' => '檔案格式無效。請上傳有效的JSON檔案。',
        'invalid_format' => '表單資料格式無效。',
        'exported_at' => '匯出時間',
        'exported_from' => '匯出自',
        'version' => '版本',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => '翻譯表單',
        'description' => '編輯此表單的翻譯內容。無法在此更改欄位結構，只能翻譯標籤、預留位置文字和文字內容。',
        'field_labels' => '欄位標籤',
        'field_name' => '欄位名稱',
        'original_label' => '原文',
        'translated_label' => '翻譯',
        'placeholder' => '預留位置',
        'option' => '選項',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => '表單屬性',
        'no_popup_properties' => '此表單未使用彈出模式。沒有可翻譯的屬性。',
        'submission_messages' => '提交訊息',
        'leave_empty_for_default' => '留空以使用預設訊息',
        'back_to_default' => '返回預設語言',
        'form_preview' => '表單資訊',
        'total_fields' => '欄位總數',
        'invalid_language' => '指定的語言無效。',
        'default_language' => '預設',
    ],

    'wizard' => [
        'previous' => '上一步',
        'next' => '下一步',
        'step_number' => '第 :current 步，共 :total 步',
        'progress_restored' => '您之前的進度已恢復。',
        'start_fresh' => '重新開始',
    ],
    'file_upload' => [
        'choose_file' => '選擇文件或拖放到此處',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => '瀏覽',
        'help' => '您可以上傳以下文件類型：:types，最大文件大小為 :sizeMB。',
        'remove' => '刪除',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[檔案在演示模式下隱藏]',
    ],
];
