<?php

return [
    'menu' => [
        'title' => '表单生成器',
        'forms' => '表单',
        'submissions' => '提交',
        'reports' => 'Reports',
        'settings' => '设置',
    ],
    'forms' => [
        'title' => '表单',
        'create' => '创建表单',
        'edit' => '编辑表单',
        'view' => 'View: :name',
        'name' => '表单名称',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => '代码',
        'code_help' => '留空以自动生成。在短代码中使用：[bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => '例如：contact-form',
        'status' => '状态',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => '提交数',
        'created_at' => '创建时间',
        'actions' => '操作',
        'settings' => '设置',
        'fields' => '字段',
        'short_code' => '短代码',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => '提交',
    'tabs' => [
        'builder' => '生成器',
        'actions' => '操作',
        'submission' => '提交',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => '表单生成器',
        'components' => 'Form Components',
        'has_captcha' => '启用 reCAPTCHA',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => '添加步骤',
        'form_title' => '表单标题',
        'form_title_placeholder' => '例如：联系我们',
        'form_title_help' => '显示在表单上方的可选标题',
        'form_description' => '表单描述',
        'form_description_placeholder' => '例如：请填写下方表单，我们将在24小时内回复您。',
        'form_description_help' => '显示在标题下方的可选描述',
        'field_types' => '字段类型',
        'field_settings' => 'Field Settings',
        'wizard_layout' => '向导布局',
        'wizard_layout_help' => '选择多步骤表单如何显示其进度指示器',
        'layout_horizontal' => '水平（顶部步骤）',
        'layout_vertical' => '垂直（左侧步骤）',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => '表单对齐',
        'form_alignment_start' => '左对齐（开始）',
        'form_alignment_center' => '居中',
        'form_alignment_end' => '右对齐（结束）',
        'form_spacing' => '间距',
        'form_margin' => '外边距',
        'form_margin_help' => '表单外部间距（例如：20px、1rem、20px 0）',
        'form_padding' => '内边距',
        'form_padding_help' => '表单内部间距（例如：20px、1rem、30px 20px）',
        'form_style' => '表单样式',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => '退出意图',
        'popup_trigger_exit_intent_help' => '仅适用于有鼠标的桌面设备。当用户将光标移出页面时触发。每次会话显示一次。',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => '表单提交',
        'view' => '查看提交',
        'info' => '提交信息',
        'form' => '表单',
        'identifier' => 'Identifier',
        'data' => '提交数据',
        'submitted_at' => '提交时间',
        'ip_address' => 'IP 地址',
        'user_agent' => '用户代理',
        'page_url' => '页面URL',
        'referrer_url' => '来源URL',
        'url_tracking_title' => '提交来源',
        'no_submissions' => '未找到提交。',
        'back' => '返回',
        'delete' => '删除',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => '提交设置',
        'on_success' => '成功时',
        'on_failure' => '失败时',
        'action' => '操作',
        'content' => '内容',
        'show_message' => '显示消息',
        'redirect_to' => '重定向到',
        'message_placeholder' => '感谢您的提交！',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://example.com/thank-you',
    ],
    'actions' => [
        'title' => '表单操作',
        'add' => '添加操作',
        'configure' => '配置操作',
        'placeholder_hint' => '使用 [field_name] 插入字段值',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => '点击左侧面板中的操作将其添加到表单',
        'no_database_action_warning' => '未配置"保存到数据库"操作',
        'no_database_action_warning_hint' => '表单提交数据将不会存储在数据库中，也不会出现在提交页面。',

        'email' => [
            'name' => '电子邮件通知',
            'description' => 'Send email notifications when form is submitted',
            'to' => '收件人',
            'to_help' => '输入收件人电子邮件地址，用逗号分隔',
            'subject' => '主题',
            'subject_help' => '使用 [field_name] 插入字段值',
            'body' => '正文',
            'body_help' => '使用 [field_name] 插入字段值',
        ],
        'database' => [
            'name' => '保存到数据库',
            'description' => 'Store submissions in the database',
            'unique_field' => '唯一字段',
            'unique_field_help' => '用于防止重复提交的字段名称（可选）',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => '端点 URL',
            'method' => 'HTTP 方法',
            'body' => '请求正文 (JSON)',
            'body_help' => '使用 [field_name] 在 JSON 中插入字段值',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => '表单',
        'description' => '显示表单',
        'form' => '选择表单',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => '表单生成器设置',
        'description' => '配置表单生成器设置',
        'allowed_mimes' => '允许的文件类型',
        'allowed_mimes_help' => '允许的文件扩展名的逗号分隔列表',
        'max_file_size' => '最大文件大小 (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => '外观设置',
            'description' => '自定义表单的外观',
            'primary_color' => '主色',
            'primary_color_help' => '用于按钮、活动状态和焦点环',
            'primary_hover_color' => '主色悬停',
            'success_color' => '成功色',
            'success_color_help' => '用于成功消息和已完成步骤',
            'danger_color' => '危险色',
            'danger_color_help' => '用于错误消息和验证错误',
            'text_color' => '文本颜色',
            'border_color' => '边框颜色',
            'background_color' => '背景色',
            'border_radius' => '边框半径',
            'border_radius_options' => [
                'none' => '无 (0)',
                'small' => '小 (4px)',
                'medium' => '中 (8px)',
                'large' => '大 (12px)',
                'extra_large' => '特大 (16px)',
                'pill' => '药丸',
            ],
            'enable_shadow' => '启用阴影',
            'enable_shadow_help' => '为表单容器添加微妙的阴影效果',
            'button_radius' => '按钮边框半径',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => '未找到表单。',
        'form_inactive' => '此表单未激活。',
        'submission_success' => '感谢您的提交！',
        'submission_failed' => '发生错误。请重试。',
        'captcha_invalid' => '请完成验证码。',
        'duplicate_submission' => '您已经提交过此表单。',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => '激活',
            'inactive' => '未激活',
        ],
    ],
    'embed' => [
        'title' => '嵌入代码',
        'description' => '复制此代码以在外部网站上嵌入表单',
        'copy' => '复制',
        'copied' => '已复制！',
        'shortcode' => '短代码',
        'url' => '嵌入 URL',
                'url_friendly' => '嵌入URL',
        'url_secure' => '嵌入URL',
        'friendly' => '友好',
        'secure' => '安全',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => '然后在平台管理 → 缓存管理中清除缓存配置。',
        'botble_site_step_1' => '将此添加到目标Botble网站的.env文件中:',
        'botble_site_instructions' => '嵌入到另一个Botble网站',
        'iframe_code_hint' => '使用编辑器中的HTML按钮或自定义HTML UI块来嵌入此iframe。',
        'js_embed' => '通过JavaScript嵌入',
        'js_embed_hint' => '为了更好的控制和响应能力，请使用我们的JavaScript嵌入代码:',
        'iframe_code' => 'Iframe嵌入代码',
    ],

    'export_import' => [
        'title' => '导出 / 导入',
        'description' => '将此表单导出为JSON或从其他站点导入',
        'export' => '导出为JSON',
        'export_description' => '下载此表单的JSON文件以在其他站点使用',
        'import' => '导入表单',
        'import_description' => '从JSON文件导入表单',
        'import_button' => '从JSON导入',
        'select_file' => '选择JSON文件',
        'import_success' => '表单导入成功！',
        'import_error' => '表单导入失败。请检查文件格式。',
        'invalid_file' => '文件格式无效。请上传有效的JSON文件。',
        'invalid_format' => '表单数据格式无效。',
        'exported_at' => '导出时间',
        'exported_from' => '导出自',
        'version' => '版本',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => '翻译表单',
        'description' => '编辑此表单的翻译内容。无法在此更改字段结构——只能翻译标签、占位符和文本。',
        'field_labels' => '字段标签',
        'field_name' => '字段名称',
        'original_label' => '原文',
        'translated_label' => '翻译',
        'placeholder' => '占位符',
        'option' => '选项',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => '表单属性',
        'no_popup_properties' => '此表单未使用弹窗模式。没有可翻译的属性。',
        'submission_messages' => '提交消息',
        'leave_empty_for_default' => '留空以使用默认消息',
        'back_to_default' => '返回默认语言',
        'form_preview' => '表单信息',
        'total_fields' => '字段总数',
        'invalid_language' => '指定的语言无效。',
        'default_language' => '默认',
    ],

    'wizard' => [
        'previous' => '上一步',
        'next' => '下一步',
        'step_number' => '第 :current 步，共 :total 步',
        'progress_restored' => '您之前的进度已恢复。',
        'start_fresh' => '重新开始',
    ],

    'step_condition' => [
        'title' => '步骤条件',
        'description' => '仅在满足特定条件时显示此步骤。如果不满足条件，将跳过此步骤。',
        'show_if' => '显示此步骤如果',
        'no_condition' => '-- 无条件（始终显示） --',
        'condition' => '条件',
        'value' => '值',
        'value_placeholder' => '输入要匹配的值',
        'is_checked' => '已选中 / 已勾选',
        'is_not_checked' => '未选中 / 未勾选',
        'equals' => '等于值',
        'not_equals' => '不等于值',
        'remove_condition' => '删除条件',
        'no_fields_available' => '在之前的步骤中未找到复选框、单选或选择字段。请先在之前的步骤中添加字段。',
        'first_step_error' => '第一步不能有条件，因为没有之前的步骤。',
        'conditional_step' => '条件步骤',
        'add_condition' => '添加条件',
    ],

    'file_upload' => [
        'choose_file' => '选择文件或拖放到此处',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => '浏览',
        'help' => '您可以上传以下文件类型：:types，最大文件大小为 :sizeMB。',
        'remove' => '删除',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[文件在演示模式下隐藏]',
    ],
];
