<?php

return [
    'menu' => [
        'title' => 'BB Form Builder',
        'forms' => 'Forms',
        'submissions' => 'Submissions',
        'reports' => 'Reports',
        'settings' => 'Settings',
    ],
    'forms' => [
        'title' => 'Forms',
        'create' => 'Create Form',
        'edit' => 'Edit Form',
        'view' => 'View: :name',
        'name' => 'Form Name',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => 'Code',
        'code_help' => 'Leave blank to auto-generate. Used in shortcode: [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => 'e.g., contact-form',
        'status' => 'Status',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => 'Submissions',
        'created_at' => 'Created At',
        'actions' => 'Actions',
        'settings' => 'Settings',
        'fields' => 'Fields',
        'short_code' => 'Shortcode',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => 'Submit',
    'tabs' => [
        'builder' => 'Builder',
        'actions' => 'Actions',
        'submission' => 'Submission',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => 'BB Form Builder',
        'components' => 'Form Components',
        'has_captcha' => 'Enable reCAPTCHA',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'Add Step',
        'form_title' => 'Заголовок форми',
        'form_title_placeholder' => 'напр., Зв\'яжіться з нами',
        'form_title_help' => 'Необов\'язковий заголовок, що відображається над формою',
        'form_description' => 'Опис форми',
        'form_description_placeholder' => 'напр., Заповніть форму нижче, і ми зв\'яжемося з вами протягом 24 годин.',
        'form_description_help' => 'Необов\'язковий опис, що відображається під заголовком',
        'field_types' => 'Field Types',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'Wizard Layout',
        'wizard_layout_help' => 'Choose how multi-step forms display their progress indicators',
        'layout_horizontal' => 'Horizontal (steps on top)',
        'layout_vertical' => 'Vertical (steps on left side)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'Вирівнювання форми',
        'form_alignment_start' => 'Ліворуч (Початок)',
        'form_alignment_center' => 'По центру',
        'form_alignment_end' => 'Праворуч (Кінець)',
        'form_spacing' => 'Відступи',
        'form_margin' => 'Зовнішній відступ',
        'form_margin_help' => 'Простір зовні форми (напр., 20px, 1rem, 20px 0)',
        'form_padding' => 'Внутрішній відступ',
        'form_padding_help' => 'Простір всередині форми (напр., 20px, 1rem, 30px 20px)',
        'form_style' => 'Стиль форми',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => 'Намір виходу',
        'popup_trigger_exit_intent_help' => 'Працює лише на настільних пристроях з мишею. Спрацьовує, коли користувач переміщує курсор за межі сторінки. Показується один раз за сесію.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => 'Form Submissions',
        'view' => 'View Submission',
        'info' => 'Submission Info',
        'form' => 'Form',
        'identifier' => 'Identifier',
        'data' => 'Submission Data',
        'submitted_at' => 'Submitted At',
        'ip_address' => 'IP Address',
        'user_agent' => 'User Agent',
        'page_url' => 'URL сторінки',
        'referrer_url' => 'URL джерела переходу',
        'url_tracking_title' => 'Джерело надсилання',
        'no_submissions' => 'No submissions found.',
        'back' => 'Back',
        'delete' => 'Delete',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => 'Submission Settings',
        'on_success' => 'On Success',
        'on_failure' => 'On Failure',
        'action' => 'Action',
        'content' => 'Content',
        'show_message' => 'Show Message',
        'redirect_to' => 'Redirect To',
        'message_placeholder' => 'Thank you for your submission!',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://example.com/thank-you',
    ],
    'actions' => [
        'title' => 'Form Actions',
        'add' => 'Add Action',
        'configure' => 'Configure Actions',
        'placeholder_hint' => 'Use [field_name] to insert field values',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => 'Натисніть на дію в лівій панелі, щоб додати її до форми',
        'no_database_action_warning' => 'Дія "Зберегти в базу даних" не налаштована',
        'no_database_action_warning_hint' => 'Надіслані форми не будуть збережені в базі даних і не з\'являться на сторінці Надсилання.',

        'email' => [
            'name' => 'Email Notification',
            'description' => 'Send email notifications when form is submitted',
            'to' => 'To',
            'to_help' => 'Enter recipient email addresses, separated by commas',
            'subject' => 'Subject',
            'subject_help' => 'Use [field_name] to insert field values',
            'body' => 'Body',
            'body_help' => 'Use [field_name] to insert field values',
        ],
        'database' => [
            'name' => 'Save to Database',
            'description' => 'Store submissions in the database',
            'unique_field' => 'Unique Field',
            'unique_field_help' => 'Field name to prevent duplicate submissions (optional)',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'Endpoint URL',
            'method' => 'HTTP Method',
            'body' => 'Request Body (JSON)',
            'body_help' => 'Use [field_name] to insert field values in JSON',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => 'Form',
        'description' => 'Display a form',
        'form' => 'Select Form',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => 'BB Form Builder Settings',
        'description' => 'Configure form builder settings',
        'allowed_mimes' => 'Allowed File Types',
        'allowed_mimes_help' => 'Comma-separated list of allowed file extensions',
        'max_file_size' => 'Max File Size (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => 'Appearance Settings',
            'description' => 'Customize the look and feel of your forms',
            'primary_color' => 'Primary Color',
            'primary_color_help' => 'Used for buttons, active states, and focus rings',
            'primary_hover_color' => 'Primary Hover Color',
            'success_color' => 'Success Color',
            'success_color_help' => 'Used for success messages and completed steps',
            'danger_color' => 'Danger Color',
            'danger_color_help' => 'Used for error messages and validation errors',
            'text_color' => 'Text Color',
            'border_color' => 'Border Color',
            'background_color' => 'Background Color',
            'border_radius' => 'Border Radius',
            'border_radius_options' => [
                'none' => 'None (0)',
                'small' => 'Small (4px)',
                'medium' => 'Medium (8px)',
                'large' => 'Large (12px)',
                'extra_large' => 'Extra Large (16px)',
                'pill' => 'Pill',
            ],
            'enable_shadow' => 'Enable Box Shadow',
            'enable_shadow_help' => 'Add subtle shadow effect to the form container',
            'button_radius' => 'Button Border Radius',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => 'Form not found.',
        'form_inactive' => 'This form is not active.',
        'submission_success' => 'Thank you for your submission!',
        'submission_failed' => 'An error occurred. Please try again.',
        'captcha_invalid' => 'Please complete the captcha.',
        'duplicate_submission' => 'You have already submitted this form.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => 'Active',
            'inactive' => 'Inactive',
        ],
    ],
    'embed' => [
        'title' => 'Embed Code',
        'description' => 'Copy this code to embed the form on external websites',
        'copy' => 'Copy',
        'copied' => 'Copied!',
        'shortcode' => 'Shortcode',
        'url' => 'Embed URL',
                'url_friendly' => 'URL для вбудовування',
        'url_secure' => 'URL для вбудовування',
        'friendly' => 'Дружній',
        'secure' => 'Безпечний',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => 'Потім очистіть кеш в Адміністрування платформи → Управління кешем.',
        'botble_site_step_1' => 'Додайте це до файлу .env цільового сайту Botble:',
        'botble_site_instructions' => 'Вбудовування на інший сайт Botble',
        'iframe_code_hint' => 'Використовуйте кнопку HTML у редакторі або блок Custom HTML UI для вбудовування.',
        'js_embed' => 'Вбудовування через JavaScript',
        'js_embed_hint' => 'Для більшого контролю та кращої чутливості використовуйте наш код вбудовування JavaScript:',
        'iframe_code' => 'Код вбудовування iframe',
    ],

    'export_import' => [
        'title' => 'Експорт / Імпорт',
        'description' => 'Експортувати цю форму в JSON або імпортувати з іншого сайту',
        'export' => 'Експорт в JSON',
        'export_description' => 'Завантажити цю форму як JSON-файл для використання на іншому сайті',
        'import' => 'Імпорт форми',
        'import_description' => 'Імпортувати форму з JSON-файлу',
        'import_button' => 'Імпорт з JSON',
        'select_file' => 'Виберіть JSON-файл',
        'import_success' => 'Форму успішно імпортовано!',
        'import_error' => 'Не вдалося імпортувати форму. Перевірте формат файлу.',
        'invalid_file' => 'Недійсний формат файлу. Завантажте дійсний JSON-файл.',
        'invalid_format' => 'Недійсний формат даних форми.',
        'exported_at' => 'Експортовано',
        'exported_from' => 'Експортовано з',
        'version' => 'Версія',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => 'Перекласти форму',
        'description' => 'Відредагуйте перекладений вміст цієї форми. Структуру полів тут змінити не можна — можна перекладати лише ярлики, плейсхолдери та текст.',
        'field_labels' => 'Мітки полів',
        'field_name' => 'Назва поля',
        'original_label' => 'Оригінал',
        'translated_label' => 'Переклад',
        'placeholder' => 'Заповнювач',
        'option' => 'Опція',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'Властивості форми',
        'no_popup_properties' => 'Ця форма не використовує режим спливаючого вікна. Немає доступних властивостей для перекладу.',
        'submission_messages' => 'Повідомлення після надсилання',
        'leave_empty_for_default' => 'Залиште порожнім, щоб використати повідомлення за замовчуванням',
        'back_to_default' => 'Повернутися до мови за замовчуванням',
        'form_preview' => 'Інформація про форму',
        'total_fields' => 'Всього полів',
        'invalid_language' => 'Указано недійсну мову.',
        'default_language' => 'За замовчуванням',
    ],

    'wizard' => [
        'previous' => 'Попередній',
        'next' => 'Наступний',
        'step_number' => 'Крок :current з :total',
        'progress_restored' => 'Ваш попередній прогрес було відновлено.',
        'start_fresh' => 'Почати спочатку',
    ],
    'file_upload' => [
        'choose_file' => 'Виберіть файл або перетягніть сюди',
        'choose_image' => 'Виберіть зображення або перетягніть сюди',
        'browse' => 'Огляд',
        'help' => 'Ви можете завантажити наступні типи файлів: :types і максимальний розмір файлу становить :sizeMB.',
        'remove' => 'Видалити',
    ],
    'validation' => [
        'required' => 'Це поле є обов\'язковим.',
        'email' => 'Будь ласка, введіть дійсну адресу електронної пошти.',
        'phone' => 'Будь ласка, введіть дійсний номер телефону.',
        'dangerous_extension' => 'Тип файлу ":extension" заборонений з міркувань безпеки.',
        'invalid_filename' => 'Ім\'я файлу містить недійсні символи.',
        'invalid_image_type' => 'Файл не є дійсним типом зображення.',
        'invalid_image' => 'Файл не є дійсним зображенням.',
        'mime_mismatch' => 'Тип файлу не відповідає його розширенню.',
        'malicious_content' => 'Файл містить потенційно шкідливий вміст.',
        'invalid_file' => 'Завантажений файл недійсний.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[Файл приховано в демо-режимі]',
    ],
];
