<?php

return [
    'menu' => [
        'title' => 'Formulärbyggare',
        'forms' => 'Formulär',
        'submissions' => 'Inlämningar',
        'reports' => 'Reports',
        'settings' => 'Inställningar',
    ],
    'forms' => [
        'title' => 'Formulär',
        'create' => 'Skapa formulär',
        'edit' => 'Redigera formulär',
        'view' => 'View: :name',
        'name' => 'Formulärnamn',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => 'Kod',
        'code_help' => 'Lämna tomt för automatisk generering. Används i shortcode: [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => 't.ex., kontaktformulär',
        'status' => 'Status',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => 'Inlämningar',
        'created_at' => 'Skapad',
        'actions' => 'Åtgärder',
        'settings' => 'Inställningar',
        'fields' => 'Fält',
        'short_code' => 'Shortcode',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => 'Skicka',
    'tabs' => [
        'builder' => 'Byggare',
        'actions' => 'Åtgärder',
        'submission' => 'Inlämning',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => 'Formulärbyggare',
        'components' => 'Form Components',
        'has_captcha' => 'Aktivera reCAPTCHA',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'Lägg till steg',
        'form_title' => 'Formulärtitel',
        'form_title_placeholder' => 't.ex., Kontakta oss',
        'form_title_help' => 'Valfri titel som visas ovanför formuläret',
        'form_description' => 'Formulärbeskrivning',
        'form_description_placeholder' => 't.ex., Fyll i formuläret nedan så återkommer vi inom 24 timmar.',
        'form_description_help' => 'Valfri beskrivning som visas under titeln',
        'field_types' => 'Fälttyper',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'Guidlayout',
        'wizard_layout_help' => 'Välj hur flerstegformulär visar sina framstegsindikatorer',
        'layout_horizontal' => 'Horisontell (steg överst)',
        'layout_vertical' => 'Vertikal (steg till vänster)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'Form Alignment',
        'form_alignment_start' => 'Left (Start)',
        'form_alignment_center' => 'Center',
        'form_alignment_end' => 'Right (End)',
        'form_spacing' => 'Avstånd',
        'form_margin' => 'Marginal',
        'form_margin_help' => 'Utrymme utanför formuläret (t.ex., 20px, 1rem, 20px 0)',
        'form_padding' => 'Utfyllnad',
        'form_padding_help' => 'Utrymme inuti formuläret (t.ex., 20px, 1rem, 30px 20px)',
        'form_style' => 'Form Style',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => 'Exit Intent',
        'popup_trigger_exit_intent_help' => 'Fungerar endast på stationära enheter med mus. Aktiveras när användaren flyttar markören utanför sidan. Visas en gång per session.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => 'Formulärinlämningar',
        'view' => 'Visa inlämning',
        'info' => 'Inlämningsinformation',
        'form' => 'Formulär',
        'identifier' => 'Identifier',
        'data' => 'Inlämningsdata',
        'submitted_at' => 'Inskickad',
        'ip_address' => 'IP-adress',
        'user_agent' => 'Användaragent',
        'page_url' => 'Sidans URL',
        'referrer_url' => 'Hänvisande URL',
        'url_tracking_title' => 'Inskickningskälla',
        'no_submissions' => 'Inga inlämningar hittades.',
        'back' => 'Tillbaka',
        'delete' => 'Radera',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => 'Inlämningsinställningar',
        'on_success' => 'Vid framgång',
        'on_failure' => 'Vid misslyckande',
        'action' => 'Åtgärd',
        'content' => 'Innehåll',
        'show_message' => 'Visa meddelande',
        'redirect_to' => 'Omdirigera till',
        'message_placeholder' => 'Tack för din inlämning!',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://exempel.se/tack',
    ],
    'actions' => [
        'title' => 'Formuläråtgärder',
        'add' => 'Lägg till åtgärd',
        'configure' => 'Konfigurera åtgärder',
        'placeholder_hint' => 'Använd [field_name] för att infoga fältvärden',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => 'Klicka på en åtgärd från vänster panel för att lägga till den i ditt formulär',
        'no_database_action_warning' => 'Ingen "Spara till databas"-åtgärd konfigurerad',
        'no_database_action_warning_hint' => 'Formulärinlämningar kommer inte att sparas i databasen och visas inte på sidan Inlämningar.',

        'email' => [
            'name' => 'E-postavisering',
            'description' => 'Send email notifications when form is submitted',
            'to' => 'Till',
            'to_help' => 'Ange mottagarnas e-postadresser, separerade med kommatecken',
            'subject' => 'Ämne',
            'subject_help' => 'Använd [field_name] för att infoga fältvärden',
            'body' => 'Brödtext',
            'body_help' => 'Använd [field_name] för att infoga fältvärden',
        ],
        'database' => [
            'name' => 'Spara i databas',
            'description' => 'Store submissions in the database',
            'unique_field' => 'Unikt fält',
            'unique_field_help' => 'Fältnamn för att förhindra dubbletter (valfritt)',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'Slutpunkts-URL',
            'method' => 'HTTP-metod',
            'body' => 'Begärandetext (JSON)',
            'body_help' => 'Använd [field_name] för att infoga fältvärden i JSON',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => 'Formulär',
        'description' => 'Visa ett formulär',
        'form' => 'Välj formulär',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => 'Formulärbyggarinställningar',
        'description' => 'Konfigurera formulärbyggarinställningar',
        'allowed_mimes' => 'Tillåtna filtyper',
        'allowed_mimes_help' => 'Kommaseparerad lista över tillåtna filtillägg',
        'max_file_size' => 'Maximal filstorlek (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => 'Utseendeinställningar',
            'description' => 'Anpassa utseendet på dina formulär',
            'primary_color' => 'Primärfärg',
            'primary_color_help' => 'Används för knappar, aktiva tillstånd och fokusringar',
            'primary_hover_color' => 'Primär hoverfärg',
            'success_color' => 'Framgångsfärg',
            'success_color_help' => 'Används för framgångsmeddelanden och slutförda steg',
            'danger_color' => 'Farofärg',
            'danger_color_help' => 'Används för felmeddelanden och valideringsfel',
            'text_color' => 'Textfärg',
            'border_color' => 'Kantfärg',
            'background_color' => 'Bakgrundsfärg',
            'border_radius' => 'Kantradie',
            'border_radius_options' => [
                'none' => 'Ingen (0)',
                'small' => 'Liten (4px)',
                'medium' => 'Medel (8px)',
                'large' => 'Stor (12px)',
                'extra_large' => 'Extra stor (16px)',
                'pill' => 'Piller',
            ],
            'enable_shadow' => 'Aktivera skugga',
            'enable_shadow_help' => 'Lägg till subtil skuggeffekt till formulärbehållaren',
            'button_radius' => 'Knappkantradie',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => 'Formulär hittades inte.',
        'form_inactive' => 'Detta formulär är inte aktivt.',
        'submission_success' => 'Tack för din inlämning!',
        'submission_failed' => 'Ett fel uppstod. Försök igen.',
        'captcha_invalid' => 'Vänligen slutför captcha.',
        'duplicate_submission' => 'Du har redan skickat in detta formulär.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => 'Aktiv',
            'inactive' => 'Inaktiv',
        ],
    ],
    'embed' => [
        'title' => 'Inbäddningskod',
        'description' => 'Kopiera denna kod för att bädda in formuläret på externa webbplatser',
        'copy' => 'Kopiera',
        'copied' => 'Kopierad!',
        'shortcode' => 'Shortcode',
        'url' => 'Inbäddnings-URL',
                'url_friendly' => 'Inbäddnings-URL',
        'url_secure' => 'Inbäddnings-URL',
        'friendly' => 'Vänlig',
        'secure' => 'Säker',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => 'Rensa sedan cachen i Plattformsadministration → Cachehantering.',
        'botble_site_step_1' => 'Lägg till detta i .env-filen på din mål-Botble-webbplats:',
        'botble_site_instructions' => 'Inbäddning på en annan Botble-webbplats',
        'iframe_code_hint' => 'Använd HTML-knappen i redigeraren eller anpassat HTML UI-block för inbäddning.',
        'js_embed' => 'Bädda in via JavaScript',
        'js_embed_hint' => 'För mer kontroll och bättre responsivitet, använd vår JavaScript-inbäddningskod:',
        'iframe_code' => 'Iframe inbäddningskod',
    ],

    'export_import' => [
        'title' => 'Export / Import',
        'description' => 'Export this form to JSON or import from another site',
        'export' => 'Export to JSON',
        'export_description' => 'Download this form as a JSON file to use on another site',
        'import' => 'Import Form',
        'import_description' => 'Import a form from a JSON file',
        'import_button' => 'Import from JSON',
        'select_file' => 'Select JSON file',
        'import_success' => 'Form imported successfully!',
        'import_error' => 'Failed to import form. Please check the file format.',
        'invalid_file' => 'Invalid file format. Please upload a valid JSON file.',
        'invalid_format' => 'Invalid form data format.',
        'exported_at' => 'Exported at',
        'exported_from' => 'Exported from',
        'version' => 'Version',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => 'Översätt formulär',
        'description' => 'Redigera det översatta innehållet för detta formulär. Fältstrukturen kan inte ändras här – endast etiketter, platshållare och text kan översättas.',
        'field_labels' => 'Fältetiketter',
        'field_name' => 'Fältnamn',
        'original_label' => 'Original',
        'translated_label' => 'Översättning',
        'placeholder' => 'Platshållare',
        'option' => 'Alternativ',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'Formulärets egenskaper',
        'no_popup_properties' => 'Detta formulär använder inte popup-läge. Inga översättningsbara egenskaper finns.',
        'submission_messages' => 'Meddelanden vid inskick',
        'leave_empty_for_default' => 'Lämna tomt för att använda standardmeddelandet',
        'back_to_default' => 'Tillbaka till standardspråk',
        'form_preview' => 'Formulärinfo',
        'total_fields' => 'Totalt antal fält',
        'invalid_language' => 'Ogiltigt språk angivet.',
        'default_language' => 'Standard',
    ],

    'wizard' => [
        'previous' => 'Föregående',
        'next' => 'Nästa',
        'step_number' => 'Steg :current av :total',
        'progress_restored' => 'Din tidigare framsteg har återställts.',
        'start_fresh' => 'Börja om',
    ],
    'file_upload' => [
        'choose_file' => 'Välj fil eller dra och släpp här',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => 'Bläddra',
        'help' => 'Du kan ladda upp följande filtyper: :types och maximal filstorlek är :sizeMB.',
        'remove' => 'Ta bort',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[Fil dold i demoläge]',
    ],
];
