<?php

return [
    'menu' => [
        'title' => 'Конструктор форм',
        'forms' => 'Формы',
        'submissions' => 'Отправки',
        'reports' => 'Reports',
        'settings' => 'Настройки',
    ],
    'forms' => [
        'title' => 'Формы',
        'create' => 'Создать форму',
        'edit' => 'Редактировать форму',
        'view' => 'View: :name',
        'name' => 'Название формы',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => 'Код',
        'code_help' => 'Оставьте пустым для автоматической генерации. Используется в шорткоде: [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => 'напр., контактная-форма',
        'status' => 'Статус',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => 'Отправки',
        'created_at' => 'Создано',
        'actions' => 'Действия',
        'settings' => 'Настройки',
        'fields' => 'Поля',
        'short_code' => 'Шорткод',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => 'Отправить',
    'tabs' => [
        'builder' => 'Конструктор',
        'actions' => 'Действия',
        'submission' => 'Отправка',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => 'Конструктор форм',
        'components' => 'Form Components',
        'has_captcha' => 'Включить reCAPTCHA',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'Добавить шаг',
        'form_title' => 'Заголовок формы',
        'form_title_placeholder' => 'напр., Свяжитесь с нами',
        'form_title_help' => 'Необязательный заголовок, отображаемый над формой',
        'form_description' => 'Описание формы',
        'form_description_placeholder' => 'напр., Заполните форму ниже, и мы свяжемся с вами в течение 24 часов.',
        'form_description_help' => 'Необязательное описание, отображаемое под заголовком',
        'field_types' => 'Типы полей',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'Макет мастера',
        'wizard_layout_help' => 'Выберите, как многошаговые формы отображают индикаторы прогресса',
        'layout_horizontal' => 'Горизонтальный (шаги сверху)',
        'layout_vertical' => 'Вертикальный (шаги слева)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'Выравнивание формы',
        'form_alignment_start' => 'Слева (Начало)',
        'form_alignment_center' => 'По центру',
        'form_alignment_end' => 'Справа (Конец)',
        'form_spacing' => 'Отступы',
        'form_margin' => 'Внешний отступ',
        'form_margin_help' => 'Пространство снаружи формы (напр., 20px, 1rem, 20px 0)',
        'form_padding' => 'Внутренний отступ',
        'form_padding_help' => 'Пространство внутри формы (напр., 20px, 1rem, 30px 20px)',
        'form_style' => 'Стиль формы',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => 'Намерение выхода',
        'popup_trigger_exit_intent_help' => 'Работает только на настольных устройствах с мышью. Срабатывает, когда пользователь уводит курсор со страницы. Показывается один раз за сессию.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => 'Отправки форм',
        'view' => 'Просмотр отправки',
        'info' => 'Информация об отправке',
        'form' => 'Форма',
        'identifier' => 'Identifier',
        'data' => 'Данные отправки',
        'submitted_at' => 'Отправлено',
        'ip_address' => 'IP-адрес',
        'user_agent' => 'User Agent',
        'page_url' => 'URL страницы',
        'referrer_url' => 'URL источника перехода',
        'url_tracking_title' => 'Источник отправки',
        'no_submissions' => 'Отправки не найдены.',
        'back' => 'Назад',
        'delete' => 'Удалить',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => 'Настройки отправки',
        'on_success' => 'При успехе',
        'on_failure' => 'При ошибке',
        'action' => 'Действие',
        'content' => 'Содержимое',
        'show_message' => 'Показать сообщение',
        'redirect_to' => 'Перенаправить на',
        'message_placeholder' => 'Спасибо за вашу отправку!',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://example.ru/spasibo',
    ],
    'actions' => [
        'title' => 'Действия формы',
        'add' => 'Добавить действие',
        'configure' => 'Настроить действия',
        'placeholder_hint' => 'Используйте [field_name] для вставки значений полей',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => 'Нажмите на действие в левой панели, чтобы добавить его в форму',
        'no_database_action_warning' => 'Действие "Сохранить в базу данных" не настроено',
        'no_database_action_warning_hint' => 'Отправленные формы не будут сохраняться в базе данных и не появятся на странице Отправки.',

        'email' => [
            'name' => 'Уведомление по email',
            'description' => 'Send email notifications when form is submitted',
            'to' => 'Кому',
            'to_help' => 'Введите адреса электронной почты получателей через запятую',
            'subject' => 'Тема',
            'subject_help' => 'Используйте [field_name] для вставки значений полей',
            'body' => 'Тело письма',
            'body_help' => 'Используйте [field_name] для вставки значений полей',
        ],
        'database' => [
            'name' => 'Сохранить в базу данных',
            'description' => 'Store submissions in the database',
            'unique_field' => 'Уникальное поле',
            'unique_field_help' => 'Имя поля для предотвращения дублирующих отправок (необязательно)',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'URL конечной точки',
            'method' => 'HTTP метод',
            'body' => 'Тело запроса (JSON)',
            'body_help' => 'Используйте [field_name] для вставки значений полей в JSON',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => 'Форма',
        'description' => 'Отобразить форму',
        'form' => 'Выбрать форму',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => 'Настройки конструктора форм',
        'description' => 'Настроить параметры конструктора форм',
        'allowed_mimes' => 'Разрешенные типы файлов',
        'allowed_mimes_help' => 'Список разрешенных расширений файлов через запятую',
        'max_file_size' => 'Максимальный размер файла (МБ)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => 'Настройки внешнего вида',
            'description' => 'Настройте внешний вид ваших форм',
            'primary_color' => 'Основной цвет',
            'primary_color_help' => 'Используется для кнопок, активных состояний и колец фокуса',
            'primary_hover_color' => 'Основной цвет при наведении',
            'success_color' => 'Цвет успеха',
            'success_color_help' => 'Используется для сообщений об успехе и завершенных шагов',
            'danger_color' => 'Цвет опасности',
            'danger_color_help' => 'Используется для сообщений об ошибках и ошибок валидации',
            'text_color' => 'Цвет текста',
            'border_color' => 'Цвет границы',
            'background_color' => 'Цвет фона',
            'border_radius' => 'Радиус границы',
            'border_radius_options' => [
                'none' => 'Нет (0)',
                'small' => 'Маленький (4px)',
                'medium' => 'Средний (8px)',
                'large' => 'Большой (12px)',
                'extra_large' => 'Очень большой (16px)',
                'pill' => 'Таблетка',
            ],
            'enable_shadow' => 'Включить тень',
            'enable_shadow_help' => 'Добавить тонкий эффект тени к контейнеру формы',
            'button_radius' => 'Радиус границы кнопки',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => 'Форма не найдена.',
        'form_inactive' => 'Эта форма неактивна.',
        'submission_success' => 'Спасибо за вашу отправку!',
        'submission_failed' => 'Произошла ошибка. Пожалуйста, попробуйте снова.',
        'captcha_invalid' => 'Пожалуйста, заполните капчу.',
        'duplicate_submission' => 'Вы уже отправили эту форму.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => 'Активна',
            'inactive' => 'Неактивна',
        ],
    ],
    'embed' => [
        'title' => 'Код встраивания',
        'description' => 'Скопируйте этот код для встраивания формы на внешних сайтах',
        'copy' => 'Копировать',
        'copied' => 'Скопировано!',
        'shortcode' => 'Шорткод',
        'url' => 'URL встраивания',
                'url_friendly' => 'URL для встраивания',
        'url_secure' => 'URL для встраивания',
        'friendly' => 'Дружественный',
        'secure' => 'Безопасный',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => 'Затем очистите кэш в Администрирование платформы → Управление кэшем.',
        'botble_site_step_1' => 'Добавьте это в файл .env целевого сайта Botble:',
        'botble_site_instructions' => 'Встраивание на другой сайт Botble',
        'iframe_code_hint' => 'Используйте кнопку HTML в редакторе или блок Custom HTML UI для встраивания.',
        'js_embed' => 'Встраивание через JavaScript',
        'js_embed_hint' => 'Для большего контроля и лучшей отзывчивости используйте наш код встраивания JavaScript:',
        'iframe_code' => 'Код встраивания iframe',
    ],

    'export_import' => [
        'title' => 'Экспорт / Импорт',
        'description' => 'Экспортировать эту форму в JSON или импортировать с другого сайта',
        'export' => 'Экспорт в JSON',
        'export_description' => 'Скачать эту форму как JSON-файл для использования на другом сайте',
        'import' => 'Импорт формы',
        'import_description' => 'Импортировать форму из JSON-файла',
        'import_button' => 'Импорт из JSON',
        'select_file' => 'Выберите JSON-файл',
        'import_success' => 'Форма успешно импортирована!',
        'import_error' => 'Не удалось импортировать форму. Проверьте формат файла.',
        'invalid_file' => 'Недопустимый формат файла. Загрузите допустимый JSON-файл.',
        'invalid_format' => 'Недопустимый формат данных формы.',
        'exported_at' => 'Экспортировано',
        'exported_from' => 'Экспортировано с',
        'version' => 'Версия',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => 'Перевести форму',
        'description' => 'Отредактируйте переведенное содержимое этой формы. Структуру полей здесь менять нельзя — можно переводить только ярлыки, плейсхолдеры и текст.',
        'field_labels' => 'Метки полей',
        'field_name' => 'Название поля',
        'original_label' => 'Оригинал',
        'translated_label' => 'Перевод',
        'placeholder' => 'Заполнитель',
        'option' => 'Опция',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'Свойства формы',
        'no_popup_properties' => 'Эта форма не использует режим всплывающего окна. Нет доступных свойств для перевода.',
        'submission_messages' => 'Сообщения отправки',
        'leave_empty_for_default' => 'Оставьте пустым, чтобы использовать сообщение по умолчанию',
        'back_to_default' => 'Вернуться к языку по умолчанию',
        'form_preview' => 'Информация о форме',
        'total_fields' => 'Всего полей',
        'invalid_language' => 'Указан неверный язык.',
        'default_language' => 'По умолчанию',
    ],

    'wizard' => [
        'previous' => 'Назад',
        'next' => 'Далее',
        'step_number' => 'Шаг :current из :total',
        'progress_restored' => 'Ваш предыдущий прогресс был восстановлен.',
        'start_fresh' => 'Начать заново',
    ],

    'step_condition' => [
        'title' => 'Условие шага',
        'description' => 'Показывать этот шаг только при выполнении определенного условия. Если условие не выполнено, шаг будет пропущен.',
        'show_if' => 'Показывать этот шаг, если',
        'no_condition' => '-- Нет условия (всегда показывать) --',
        'condition' => 'Условие',
        'value' => 'Значение',
        'value_placeholder' => 'Введите значение для сопоставления',
        'is_checked' => 'Отмечено / выбрано',
        'is_not_checked' => 'Не отмечено / не выбрано',
        'equals' => 'Равно значению',
        'not_equals' => 'Не равно значению',
        'remove_condition' => 'Удалить условие',
        'no_fields_available' => 'На предыдущих шагах не найдено полей checkbox, radio или select. Сначала добавьте поля на предыдущие шаги.',
        'first_step_error' => 'Первый шаг не может иметь условия, так как нет предыдущих шагов.',
        'conditional_step' => 'Условный шаг',
        'add_condition' => 'Добавить условие',
    ],

    'file_upload' => [
        'choose_file' => 'Выберите файл или перетащите сюда',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => 'Обзор',
        'help' => 'Вы можете загрузить следующие типы файлов: :types и максимальный размер файла :sizeMB.',
        'remove' => 'Удалить',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[Файл скрыт в демо-режиме]',
    ],
];
