<?php

return [
    'menu' => [
        'title' => 'Construtor de formulários',
        'forms' => 'Formulários',
        'submissions' => 'Envios',
        'reports' => 'Reports',
        'settings' => 'Configurações',
    ],
    'forms' => [
        'title' => 'Formulários',
        'create' => 'Criar formulário',
        'edit' => 'Editar formulário',
        'view' => 'View: :name',
        'name' => 'Nome do formulário',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => 'Código',
        'code_help' => 'Deixe em branco para gerar automaticamente. Usado no shortcode: [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => 'ex., formulario-contato',
        'status' => 'Estado',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => 'Envios',
        'created_at' => 'Criado em',
        'actions' => 'Ações',
        'settings' => 'Configurações',
        'fields' => 'Campos',
        'short_code' => 'Shortcode',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => 'Enviar',
    'tabs' => [
        'builder' => 'Construtor',
        'actions' => 'Ações',
        'submission' => 'Envio',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => 'Construtor de formulários',
        'components' => 'Form Components',
        'has_captcha' => 'Ativar reCAPTCHA',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'Adicionar etapa',
        'form_title' => 'Título do formulário',
        'form_title_placeholder' => 'ex., Contacte-nos',
        'form_title_help' => 'Título opcional exibido acima do formulário',
        'form_description' => 'Descrição do formulário',
        'form_description_placeholder' => 'ex., Preencha o formulário abaixo e responderemos dentro de 24 horas.',
        'form_description_help' => 'Descrição opcional exibida abaixo do título',
        'field_types' => 'Tipos de campo',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'Layout do assistente',
        'wizard_layout_help' => 'Escolha como os formulários de várias etapas exibem seus indicadores de progresso',
        'layout_horizontal' => 'Horizontal (etapas no topo)',
        'layout_vertical' => 'Vertical (etapas à esquerda)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'Alinhamento do formulário',
        'form_alignment_start' => 'Esquerda (Início)',
        'form_alignment_center' => 'Centro',
        'form_alignment_end' => 'Direita (Fim)',
        'form_spacing' => 'Espaçamento',
        'form_margin' => 'Margem',
        'form_margin_help' => 'Espaço fora do formulário (ex., 20px, 1rem, 20px 0)',
        'form_padding' => 'Preenchimento',
        'form_padding_help' => 'Espaço dentro do formulário (ex., 20px, 1rem, 30px 20px)',
        'form_style' => 'Estilo do formulário',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => 'Exit Intent',
        'popup_trigger_exit_intent_help' => 'Funciona apenas em dispositivos desktop com rato. Ativa quando o utilizador move o cursor para fora da página. Mostra uma vez por sessão.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => 'Envios de formulários',
        'view' => 'Ver envio',
        'info' => 'Informações do envio',
        'form' => 'Formulário',
        'identifier' => 'Identifier',
        'data' => 'Dados do envio',
        'submitted_at' => 'Enviado em',
        'ip_address' => 'Endereço IP',
        'user_agent' => 'Agente do utilizador',
        'page_url' => 'URL da página',
        'referrer_url' => 'URL de referência',
        'url_tracking_title' => 'Origem do envio',
        'no_submissions' => 'Nenhum envio encontrado.',
        'back' => 'Voltar',
        'delete' => 'Eliminar',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => 'Configurações de envio',
        'on_success' => 'Em caso de sucesso',
        'on_failure' => 'Em caso de falha',
        'action' => 'Ação',
        'content' => 'Conteúdo',
        'show_message' => 'Mostrar mensagem',
        'redirect_to' => 'Redirecionar para',
        'message_placeholder' => 'Obrigado pelo seu envio!',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://exemplo.pt/obrigado',
    ],
    'actions' => [
        'title' => 'Ações do formulário',
        'add' => 'Adicionar ação',
        'configure' => 'Configurar ações',
        'placeholder_hint' => 'Use [field_name] para inserir valores de campo',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => 'Clique numa ação do painel esquerdo para adicioná-la ao seu formulário',
        'no_database_action_warning' => 'Nenhuma ação "Guardar na base de dados" configurada',
        'no_database_action_warning_hint' => 'As submissões de formulários não serão armazenadas na base de dados e não aparecerão na página de Submissões.',

        'email' => [
            'name' => 'Notificação por email',
            'description' => 'Send email notifications when form is submitted',
            'to' => 'Para',
            'to_help' => 'Insira os endereços de email dos destinatários, separados por vírgulas',
            'subject' => 'Assunto',
            'subject_help' => 'Use [field_name] para inserir valores de campo',
            'body' => 'Corpo',
            'body_help' => 'Use [field_name] para inserir valores de campo',
        ],
        'database' => [
            'name' => 'Guardar na base de dados',
            'description' => 'Store submissions in the database',
            'unique_field' => 'Campo único',
            'unique_field_help' => 'Nome do campo para evitar envios duplicados (opcional)',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'URL do endpoint',
            'method' => 'Método HTTP',
            'body' => 'Corpo do pedido (JSON)',
            'body_help' => 'Use [field_name] para inserir valores de campo em JSON',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => 'Formulário',
        'description' => 'Exibir um formulário',
        'form' => 'Selecionar formulário',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => 'Configurações do construtor de formulários',
        'description' => 'Configurar definições do construtor de formulários',
        'allowed_mimes' => 'Tipos de ficheiro permitidos',
        'allowed_mimes_help' => 'Lista separada por vírgulas de extensões de ficheiro permitidas',
        'max_file_size' => 'Tamanho máximo do ficheiro (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => 'Configurações de aparência',
            'description' => 'Personalize a aparência dos seus formulários',
            'primary_color' => 'Cor primária',
            'primary_color_help' => 'Usado para botões, estados ativos e anéis de foco',
            'primary_hover_color' => 'Cor primária ao passar o rato',
            'success_color' => 'Cor de sucesso',
            'success_color_help' => 'Usado para mensagens de sucesso e etapas concluídas',
            'danger_color' => 'Cor de perigo',
            'danger_color_help' => 'Usado para mensagens de erro e erros de validação',
            'text_color' => 'Cor do texto',
            'border_color' => 'Cor da borda',
            'background_color' => 'Cor de fundo',
            'border_radius' => 'Raio da borda',
            'border_radius_options' => [
                'none' => 'Nenhum (0)',
                'small' => 'Pequeno (4px)',
                'medium' => 'Médio (8px)',
                'large' => 'Grande (12px)',
                'extra_large' => 'Extra grande (16px)',
                'pill' => 'Pílula',
            ],
            'enable_shadow' => 'Ativar sombra',
            'enable_shadow_help' => 'Adicionar efeito de sombra subtil ao contentor do formulário',
            'button_radius' => 'Raio da borda do botão',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => 'Formulário não encontrado.',
        'form_inactive' => 'Este formulário não está ativo.',
        'submission_success' => 'Obrigado pelo seu envio!',
        'submission_failed' => 'Ocorreu um erro. Por favor, tente novamente.',
        'captcha_invalid' => 'Por favor, complete o captcha.',
        'duplicate_submission' => 'Já enviou este formulário.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => 'Ativo',
            'inactive' => 'Inativo',
        ],
    ],
    'embed' => [
        'title' => 'Código de incorporação',
        'description' => 'Copie este código para incorporar o formulário em sites externos',
        'copy' => 'Copiar',
        'copied' => 'Copiado!',
        'shortcode' => 'Shortcode',
        'url' => 'URL de incorporação',
                'url_friendly' => 'URL de incorporação',
        'url_secure' => 'URL de incorporação',
        'friendly' => 'Amigável',
        'secure' => 'Seguro',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => 'Em seguida, limpe o cache em Administração da plataforma → Gerenciamento de cache.',
        'botble_site_step_1' => 'Adicione isto ao arquivo .env do seu site Botble de destino:',
        'botble_site_instructions' => 'Incorporar em outro site Botble',
        'iframe_code_hint' => 'Use o botão HTML no Editor ou bloco HTML personalizado para incorporar.',
        'js_embed' => 'Incorporar via JavaScript',
        'js_embed_hint' => 'Para mais controle e melhor responsividade, use nosso código de incorporação JavaScript:',
        'iframe_code' => 'Código de incorporação iframe',
    ],

    'export_import' => [
        'title' => 'Exportar / Importar',
        'description' => 'Exportar este formulário para JSON ou importar de outro site',
        'export' => 'Exportar para JSON',
        'export_description' => 'Baixar este formulário como arquivo JSON para usar em outro site',
        'import' => 'Importar formulário',
        'import_description' => 'Importar um formulário de um arquivo JSON',
        'import_button' => 'Importar do JSON',
        'select_file' => 'Selecionar arquivo JSON',
        'import_success' => 'Formulário importado com sucesso!',
        'import_error' => 'Falha ao importar formulário. Por favor verifique o formato do arquivo.',
        'invalid_file' => 'Formato de arquivo inválido. Por favor carregue um arquivo JSON válido.',
        'invalid_format' => 'Formato de dados do formulário inválido.',
        'exported_at' => 'Exportado em',
        'exported_from' => 'Exportado de',
        'version' => 'Versão',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => 'Traduzir formulário',
        'description' => 'Edite o conteúdo traduzido deste formulário. A estrutura dos campos não pode ser alterada aqui — apenas etiquetas, placeholders e texto podem ser traduzidos.',
        'field_labels' => 'Rótulos dos campos',
        'field_name' => 'Nome do campo',
        'original_label' => 'Original',
        'translated_label' => 'Tradução',
        'placeholder' => 'Placeholder',
        'option' => 'Opção',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'Propriedades do formulário',
        'no_popup_properties' => 'Este formulário não utiliza modo popup. Não há propriedades traduzíveis disponíveis.',
        'submission_messages' => 'Mensagens de envio',
        'leave_empty_for_default' => 'Deixe vazio para usar a mensagem padrão',
        'back_to_default' => 'Voltar para o idioma padrão',
        'form_preview' => 'Informações do formulário',
        'total_fields' => 'Total de campos',
        'invalid_language' => 'Idioma especificado inválido.',
        'default_language' => 'Padrão',
    ],

    'wizard' => [
        'previous' => 'Anterior',
        'next' => 'Seguinte',
        'step_number' => 'Etapa :current de :total',
        'progress_restored' => 'O seu progresso anterior foi restaurado.',
        'start_fresh' => 'Começar de Novo',
    ],

    'step_condition' => [
        'title' => 'Condição da etapa',
        'description' => 'Mostre esta etapa apenas quando uma condição específica for atendida. Se a condição não for atendida, a etapa será ignorada.',
        'show_if' => 'Mostre esta etapa se',
        'no_condition' => '-- Sem condição (mostrar sempre) --',
        'condition' => 'Condição',
        'value' => 'Valor',
        'value_placeholder' => 'Introduzir valor para comparar',
        'is_checked' => 'Está marcado / selecionado',
        'is_not_checked' => 'Não está marcado / não selecionado',
        'equals' => 'Igual ao valor',
        'not_equals' => 'Diferente do valor',
        'remove_condition' => 'Remover condição',
        'no_fields_available' => 'Nenhum campo checkbox, radio ou select encontrado nas etapas anteriores. Adicione campos às etapas anteriores primeiro.',
        'first_step_error' => 'A primeira etapa não pode ter condições, pois não existem etapas anteriores.',
        'conditional_step' => 'Etapa condicional',
        'add_condition' => 'Adicionar condição',
    ],

    'file_upload' => [
        'choose_file' => 'Escolher ficheiro ou arrastar e soltar aqui',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => 'Procurar',
        'help' => 'Pode carregar os seguintes tipos de ficheiro: :types e o tamanho máximo do ficheiro é :sizeMB.',
        'remove' => 'Remover',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[Arquivo oculto no modo de demonstração]',
    ],
];
