<?php

return [
    'menu' => [
        'title' => 'Formulierbouwer',
        'forms' => 'Formulieren',
        'submissions' => 'Inzendingen',
        'reports' => 'Reports',
        'settings' => 'Instellingen',
    ],
    'forms' => [
        'title' => 'Formulieren',
        'create' => 'Formulier maken',
        'edit' => 'Formulier bewerken',
        'view' => 'View: :name',
        'name' => 'Formuliernaam',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => 'Code',
        'code_help' => 'Laat leeg voor automatische generatie. Gebruikt in shortcode: [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => 'bijv., contactformulier',
        'status' => 'Status',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => 'Inzendingen',
        'created_at' => 'Aangemaakt op',
        'actions' => 'Acties',
        'settings' => 'Instellingen',
        'fields' => 'Velden',
        'short_code' => 'Shortcode',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => 'Verzenden',
    'tabs' => [
        'builder' => 'Bouwer',
        'actions' => 'Acties',
        'submission' => 'Inzending',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => 'Formulierbouwer',
        'components' => 'Form Components',
        'has_captcha' => 'reCAPTCHA inschakelen',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'Stap toevoegen',
        'form_title' => 'Formuliertitel',
        'form_title_placeholder' => 'bijv., Neem contact op',
        'form_title_help' => 'Optionele titel die boven het formulier wordt weergegeven',
        'form_description' => 'Formulierbeschrijving',
        'form_description_placeholder' => 'bijv., Vul het onderstaande formulier in en we nemen binnen 24 uur contact met u op.',
        'form_description_help' => 'Optionele beschrijving die onder de titel wordt weergegeven',
        'field_types' => 'Veldtypen',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'Wizard-indeling',
        'wizard_layout_help' => 'Kies hoe formulieren met meerdere stappen hun voortgangsindicatoren weergeven',
        'layout_horizontal' => 'Horizontaal (stappen bovenaan)',
        'layout_vertical' => 'Verticaal (stappen links)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'Formulieruitlijning',
        'form_alignment_start' => 'Links (Begin)',
        'form_alignment_center' => 'Midden',
        'form_alignment_end' => 'Rechts (Einde)',
        'form_spacing' => 'Afstand',
        'form_margin' => 'Marge',
        'form_margin_help' => 'Ruimte buiten het formulier (bijv., 20px, 1rem, 20px 0)',
        'form_padding' => 'Opvulling',
        'form_padding_help' => 'Ruimte binnen het formulier (bijv., 20px, 1rem, 30px 20px)',
        'form_style' => 'Formulierstijl',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => 'Exit Intent',
        'popup_trigger_exit_intent_help' => 'Werkt alleen op desktopapparaten met muis. Wordt geactiveerd wanneer de gebruiker de cursor van de pagina af beweegt. Wordt één keer per sessie getoond.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => 'Formulierinzendingen',
        'view' => 'Inzending bekijken',
        'info' => 'Inzendingsinformatie',
        'form' => 'Formulier',
        'identifier' => 'Identifier',
        'data' => 'Inzendingsgegevens',
        'submitted_at' => 'Ingediend op',
        'ip_address' => 'IP-adres',
        'user_agent' => 'User Agent',
        'page_url' => 'Pagina-URL',
        'referrer_url' => 'Verwijzende URL',
        'url_tracking_title' => 'Inzendingsbron',
        'no_submissions' => 'Geen inzendingen gevonden.',
        'back' => 'Terug',
        'delete' => 'Verwijderen',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => 'Inzendinginstellingen',
        'on_success' => 'Bij succes',
        'on_failure' => 'Bij mislukking',
        'action' => 'Actie',
        'content' => 'Inhoud',
        'show_message' => 'Bericht tonen',
        'redirect_to' => 'Doorverwijzen naar',
        'message_placeholder' => 'Bedankt voor uw inzending!',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://voorbeeld.nl/bedankt',
    ],
    'actions' => [
        'title' => 'Formulieracties',
        'add' => 'Actie toevoegen',
        'configure' => 'Acties configureren',
        'placeholder_hint' => 'Gebruik [field_name] om veldwaarden in te voegen',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => 'Klik op een actie in het linkerpaneel om deze aan uw formulier toe te voegen',
        'no_database_action_warning' => 'Geen "Opslaan in database"-actie geconfigureerd',
        'no_database_action_warning_hint' => 'Formulierinzendingen worden niet opgeslagen in de database en verschijnen niet op de Inzendingen-pagina.',

        'email' => [
            'name' => 'E-mailmelding',
            'description' => 'Send email notifications when form is submitted',
            'to' => 'Aan',
            'to_help' => 'Voer e-mailadressen van ontvangers in, gescheiden door komma\'s',
            'subject' => 'Onderwerp',
            'subject_help' => 'Gebruik [field_name] om veldwaarden in te voegen',
            'body' => 'Inhoud',
            'body_help' => 'Gebruik [field_name] om veldwaarden in te voegen',
        ],
        'database' => [
            'name' => 'Opslaan in database',
            'description' => 'Store submissions in the database',
            'unique_field' => 'Uniek veld',
            'unique_field_help' => 'Veldnaam om dubbele inzendingen te voorkomen (optioneel)',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'Endpoint URL',
            'method' => 'HTTP-methode',
            'body' => 'Verzoekbody (JSON)',
            'body_help' => 'Gebruik [field_name] om veldwaarden in JSON in te voegen',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => 'Formulier',
        'description' => 'Een formulier weergeven',
        'form' => 'Formulier selecteren',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => 'Formulierbouwer-instellingen',
        'description' => 'Formulierbouwer-instellingen configureren',
        'allowed_mimes' => 'Toegestane bestandstypen',
        'allowed_mimes_help' => 'Door komma\'s gescheiden lijst van toegestane bestandsextensies',
        'max_file_size' => 'Maximale bestandsgrootte (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => 'Weergave-instellingen',
            'description' => 'Pas het uiterlijk van uw formulieren aan',
            'primary_color' => 'Primaire kleur',
            'primary_color_help' => 'Gebruikt voor knoppen, actieve statussen en focusringen',
            'primary_hover_color' => 'Primaire hoverkleur',
            'success_color' => 'Succeskleur',
            'success_color_help' => 'Gebruikt voor succesberichten en voltooide stappen',
            'danger_color' => 'Gevaarkleur',
            'danger_color_help' => 'Gebruikt voor foutmeldingen en validatiefouten',
            'text_color' => 'Tekstkleur',
            'border_color' => 'Randkleur',
            'background_color' => 'Achtergrondkleur',
            'border_radius' => 'Randradius',
            'border_radius_options' => [
                'none' => 'Geen (0)',
                'small' => 'Klein (4px)',
                'medium' => 'Gemiddeld (8px)',
                'large' => 'Groot (12px)',
                'extra_large' => 'Extra groot (16px)',
                'pill' => 'Pil',
            ],
            'enable_shadow' => 'Schaduw inschakelen',
            'enable_shadow_help' => 'Voeg een subtiel schaduweffect toe aan de formuliercontainer',
            'button_radius' => 'Knoprandradius',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => 'Formulier niet gevonden.',
        'form_inactive' => 'Dit formulier is niet actief.',
        'submission_success' => 'Bedankt voor uw inzending!',
        'submission_failed' => 'Er is een fout opgetreden. Probeer het opnieuw.',
        'captcha_invalid' => 'Voltooi de captcha.',
        'duplicate_submission' => 'U heeft dit formulier al ingediend.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => 'Actief',
            'inactive' => 'Inactief',
        ],
    ],
    'embed' => [
        'title' => 'Insluitcode',
        'description' => 'Kopieer deze code om het formulier op externe websites in te sluiten',
        'copy' => 'Kopiëren',
        'copied' => 'Gekopieerd!',
        'shortcode' => 'Shortcode',
        'url' => 'Insluit-URL',
                'url_friendly' => 'Insluit-URL',
        'url_secure' => 'Insluit-URL',
        'friendly' => 'Vriendelijk',
        'secure' => 'Beveiligd',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => 'Wis vervolgens de cache in Platformbeheer → Cachebeheer.',
        'botble_site_step_1' => 'Voeg dit toe aan het .env-bestand van uw doel-Botble-site:',
        'botble_site_instructions' => 'Insluiten op een andere Botble-site',
        'iframe_code_hint' => 'Gebruik de HTML-knop in de editor of een aangepast HTML UI-blok om in te sluiten.',
        'js_embed' => 'Insluiten via JavaScript',
        'js_embed_hint' => 'Voor meer controle en betere responsiviteit, gebruik onze JavaScript insluitcode:',
        'iframe_code' => 'Iframe insluitcode',
    ],

    'export_import' => [
        'title' => 'Exporteren / Importeren',
        'description' => 'Dit formulier exporteren naar JSON of importeren van een andere site',
        'export' => 'Exporteren naar JSON',
        'export_description' => 'Dit formulier downloaden als JSON-bestand om op een andere site te gebruiken',
        'import' => 'Formulier importeren',
        'import_description' => 'Een formulier importeren uit een JSON-bestand',
        'import_button' => 'Importeren uit JSON',
        'select_file' => 'Selecteer JSON-bestand',
        'import_success' => 'Formulier succesvol geïmporteerd!',
        'import_error' => 'Kan formulier niet importeren. Controleer het bestandsformaat.',
        'invalid_file' => 'Ongeldig bestandsformaat. Upload een geldig JSON-bestand.',
        'invalid_format' => 'Ongeldig formuliergegevensformaat.',
        'exported_at' => 'Geëxporteerd op',
        'exported_from' => 'Geëxporteerd van',
        'version' => 'Versie',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => 'Formulier vertalen',
        'description' => 'Bewerk de vertaalde inhoud voor dit formulier. De veldstructuur kan hier niet worden gewijzigd – alleen labels, placeholders en tekst kunnen worden vertaald.',
        'field_labels' => 'Veldlabels',
        'field_name' => 'Veldnaam',
        'original_label' => 'Origineel',
        'translated_label' => 'Vertaling',
        'placeholder' => 'Placeholder',
        'option' => 'Optie',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'Formuliereigenschappen',
        'no_popup_properties' => 'Dit formulier gebruikt geen pop-upmodus. Geen vertaalbare eigenschappen beschikbaar.',
        'submission_messages' => 'Berichten bij indiening',
        'leave_empty_for_default' => 'Laat leeg om het standaardbericht te gebruiken',
        'back_to_default' => 'Terug naar standaardtaal',
        'form_preview' => 'Formulierinfo',
        'total_fields' => 'Totaal aantal velden',
        'invalid_language' => 'Ongeldige taal opgegeven.',
        'default_language' => 'Standaard',
    ],

    'wizard' => [
        'previous' => 'Vorige',
        'next' => 'Volgende',
        'step_number' => 'Stap :current van :total',
        'progress_restored' => 'Uw vorige voortgang is hersteld.',
        'start_fresh' => 'Opnieuw beginnen',
    ],

    'step_condition' => [
        'title' => 'Stapvoorwaarde',
        'description' => 'Toon deze stap alleen wanneer aan een specifieke voorwaarde is voldaan. Als niet aan de voorwaarde wordt voldaan, wordt de stap overgeslagen.',
        'show_if' => 'Toon deze stap als',
        'no_condition' => '-- Geen voorwaarde (altijd tonen) --',
        'condition' => 'Voorwaarde',
        'value' => 'Waarde',
        'value_placeholder' => 'Voer waarde in om te matchen',
        'is_checked' => 'Is aangevinkt / geselecteerd',
        'is_not_checked' => 'Is niet aangevinkt / niet geselecteerd',
        'equals' => 'Is gelijk aan waarde',
        'not_equals' => 'Is niet gelijk aan waarde',
        'remove_condition' => 'Voorwaarde verwijderen',
        'no_fields_available' => 'Geen checkbox-, radio- of selectievelden gevonden in vorige stappen. Voeg eerst velden toe aan eerdere stappen.',
        'first_step_error' => 'De eerste stap kan geen voorwaarden hebben omdat er geen vorige stappen zijn.',
        'conditional_step' => 'Voorwaardelijke stap',
        'add_condition' => 'Voorwaarde toevoegen',
    ],

    'file_upload' => [
        'choose_file' => 'Kies bestand of sleep hier naartoe',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => 'Bladeren',
        'help' => 'U kunt de volgende bestandstypen uploaden: :types en de maximale bestandsgrootte is :sizeMB.',
        'remove' => 'Verwijderen',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[Bestand verborgen in demomodus]',
    ],
];
