<?php

return [
    'menu' => [
        'title' => '양식 빌더',
        'forms' => '양식',
        'submissions' => '제출',
        'reports' => 'Reports',
        'settings' => '설정',
    ],
    'forms' => [
        'title' => '양식',
        'create' => '양식 만들기',
        'edit' => '양식 편집',
        'view' => 'View: :name',
        'name' => '양식 이름',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => '코드',
        'code_help' => '자동 생성하려면 비워 두세요. 숏코드에 사용: [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => '예: contact-form',
        'status' => '상태',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => '제출',
        'created_at' => '생성일',
        'actions' => '작업',
        'settings' => '설정',
        'fields' => '필드',
        'short_code' => '숏코드',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => '제출',
    'tabs' => [
        'builder' => '빌더',
        'actions' => '작업',
        'submission' => '제출',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => '양식 빌더',
        'components' => 'Form Components',
        'has_captcha' => 'reCAPTCHA 활성화',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => '단계 추가',
        'form_title' => '양식 제목',
        'form_title_placeholder' => '예: 문의하기',
        'form_title_help' => '양식 위에 표시되는 선택적 제목',
        'form_description' => '양식 설명',
        'form_description_placeholder' => '예: 아래 양식을 작성하시면 24시간 이내에 연락드리겠습니다.',
        'form_description_help' => '제목 아래에 표시되는 선택적 설명',
        'field_types' => '필드 유형',
        'field_settings' => 'Field Settings',
        'wizard_layout' => '마법사 레이아웃',
        'wizard_layout_help' => '다단계 양식이 진행 표시기를 표시하는 방법 선택',
        'layout_horizontal' => '가로 (상단에 단계)',
        'layout_vertical' => '세로 (왼쪽에 단계)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => '양식 정렬',
        'form_alignment_start' => '왼쪽 (시작)',
        'form_alignment_center' => '가운데',
        'form_alignment_end' => '오른쪽 (끝)',
        'form_spacing' => '간격',
        'form_margin' => '외부 여백',
        'form_margin_help' => '양식 외부 간격 (예: 20px, 1rem, 20px 0)',
        'form_padding' => '내부 여백',
        'form_padding_help' => '양식 내부 간격 (예: 20px, 1rem, 30px 20px)',
        'form_style' => '양식 스타일',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => '이탈 의도',
        'popup_trigger_exit_intent_help' => '마우스가 있는 데스크톱 기기에서만 작동합니다. 사용자가 커서를 페이지 밖으로 이동할 때 트리거됩니다. 세션당 한 번 표시.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => '양식 제출',
        'view' => '제출 보기',
        'info' => '제출 정보',
        'form' => '양식',
        'identifier' => 'Identifier',
        'data' => '제출 데이터',
        'submitted_at' => '제출일',
        'ip_address' => 'IP 주소',
        'user_agent' => '사용자 에이전트',
        'page_url' => '페이지 URL',
        'referrer_url' => '리퍼러 URL',
        'url_tracking_title' => '제출 출처',
        'no_submissions' => '제출을 찾을 수 없습니다.',
        'back' => '뒤로',
        'delete' => '삭제',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => '제출 설정',
        'on_success' => '성공 시',
        'on_failure' => '실패 시',
        'action' => '작업',
        'content' => '내용',
        'show_message' => '메시지 표시',
        'redirect_to' => '리디렉션',
        'message_placeholder' => '제출해 주셔서 감사합니다!',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://example.kr/thank-you',
    ],
    'actions' => [
        'title' => '양식 작업',
        'add' => '작업 추가',
        'configure' => '작업 구성',
        'placeholder_hint' => '[field_name]을 사용하여 필드 값 삽입',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => '왼쪽 패널에서 작업을 클릭하여 양식에 추가하세요',
        'no_database_action_warning' => '"데이터베이스에 저장" 작업이 구성되지 않았습니다',
        'no_database_action_warning_hint' => '양식 제출 데이터가 데이터베이스에 저장되지 않으며 제출 페이지에 표시되지 않습니다.',

        'email' => [
            'name' => '이메일 알림',
            'description' => 'Send email notifications when form is submitted',
            'to' => '받는 사람',
            'to_help' => '쉼표로 구분된 수신자 이메일 주소 입력',
            'subject' => '제목',
            'subject_help' => '[field_name]을 사용하여 필드 값 삽입',
            'body' => '본문',
            'body_help' => '[field_name]을 사용하여 필드 값 삽입',
        ],
        'database' => [
            'name' => '데이터베이스에 저장',
            'description' => 'Store submissions in the database',
            'unique_field' => '고유 필드',
            'unique_field_help' => '중복 제출을 방지하는 필드 이름 (선택 사항)',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => '엔드포인트 URL',
            'method' => 'HTTP 메서드',
            'body' => '요청 본문 (JSON)',
            'body_help' => '[field_name]을 사용하여 JSON에 필드 값 삽입',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => '양식',
        'description' => '양식 표시',
        'form' => '양식 선택',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => '양식 빌더 설정',
        'description' => '양식 빌더 설정 구성',
        'allowed_mimes' => '허용된 파일 유형',
        'allowed_mimes_help' => '쉼표로 구분된 허용된 파일 확장자 목록',
        'max_file_size' => '최대 파일 크기 (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => '외관 설정',
            'description' => '양식의 모양 사용자 정의',
            'primary_color' => '기본 색상',
            'primary_color_help' => '버튼, 활성 상태 및 포커스 링에 사용',
            'primary_hover_color' => '기본 호버 색상',
            'success_color' => '성공 색상',
            'success_color_help' => '성공 메시지 및 완료된 단계에 사용',
            'danger_color' => '위험 색상',
            'danger_color_help' => '오류 메시지 및 유효성 검사 오류에 사용',
            'text_color' => '텍스트 색상',
            'border_color' => '테두리 색상',
            'background_color' => '배경색',
            'border_radius' => '테두리 반경',
            'border_radius_options' => [
                'none' => '없음 (0)',
                'small' => '작음 (4px)',
                'medium' => '중간 (8px)',
                'large' => '큼 (12px)',
                'extra_large' => '매우 큼 (16px)',
                'pill' => '알약',
            ],
            'enable_shadow' => '박스 그림자 활성화',
            'enable_shadow_help' => '양식 컨테이너에 미묘한 그림자 효과 추가',
            'button_radius' => '버튼 테두리 반경',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => '양식을 찾을 수 없습니다.',
        'form_inactive' => '이 양식은 활성화되지 않았습니다.',
        'submission_success' => '제출해 주셔서 감사합니다!',
        'submission_failed' => '오류가 발생했습니다. 다시 시도하세요.',
        'captcha_invalid' => '캡차를 완료하세요.',
        'duplicate_submission' => '이미 이 양식을 제출했습니다.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => '활성',
            'inactive' => '비활성',
        ],
    ],
    'embed' => [
        'title' => '임베드 코드',
        'description' => '이 코드를 복사하여 외부 웹사이트에 양식 임베드',
        'copy' => '복사',
        'copied' => '복사됨!',
        'shortcode' => '숏코드',
        'url' => '임베드 URL',
                'url_friendly' => '임베드 URL',
        'url_secure' => '임베드 URL',
        'friendly' => '친숙한',
        'secure' => '보안',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => '그런 다음 플랫폼 관리 → 캐시 관리에서 캐시를 지우세요.',
        'botble_site_step_1' => '대상 Botble 사이트의 .env 파일에 추가하세요:',
        'botble_site_instructions' => '다른 Botble 사이트에 임베드',
        'iframe_code_hint' => '에디터의 HTML 버튼 또는 사용자 정의 HTML UI 블록을 사용하여 임베드하세요.',
        'js_embed' => 'JavaScript로 임베드',
        'js_embed_hint' => '더 많은 제어와 더 나은 반응성을 위해 JavaScript 임베드 코드를 사용하세요:',
        'iframe_code' => 'Iframe 임베드 코드',
    ],

    'export_import' => [
        'title' => '내보내기 / 가져오기',
        'description' => '이 양식을 JSON으로 내보내거나 다른 사이트에서 가져오기',
        'export' => 'JSON으로 내보내기',
        'export_description' => '다른 사이트에서 사용할 수 있도록 이 양식을 JSON 파일로 다운로드',
        'import' => '양식 가져오기',
        'import_description' => 'JSON 파일에서 양식 가져오기',
        'import_button' => 'JSON에서 가져오기',
        'select_file' => 'JSON 파일 선택',
        'import_success' => '양식을 성공적으로 가져왔습니다!',
        'import_error' => '양식을 가져오지 못했습니다. 파일 형식을 확인하세요.',
        'invalid_file' => '잘못된 파일 형식입니다. 유효한 JSON 파일을 업로드하세요.',
        'invalid_format' => '잘못된 양식 데이터 형식입니다.',
        'exported_at' => '내보낸 날짜',
        'exported_from' => '내보낸 위치',
        'version' => '버전',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => '양식 번역',
        'description' => '이 양식의 번역된 내용을 편집하세요. 필드 구조는 여기서 변경할 수 없으며, 라벨, 플레이스홀더, 텍스트만 번역할 수 있습니다.',
        'field_labels' => '필드 라벨',
        'field_name' => '필드 이름',
        'original_label' => '원본',
        'translated_label' => '번역',
        'placeholder' => '플레이스홀더',
        'option' => '옵션',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => '양식 속성',
        'no_popup_properties' => '이 양식은 팝업 모드를 사용하지 않습니다. 번역할 수 있는 속성이 없습니다.',
        'submission_messages' => '제출 메시지',
        'leave_empty_for_default' => '기본 메시지를 사용하려면 비워 두세요',
        'back_to_default' => '기본 언어로 돌아가기',
        'form_preview' => '양식 정보',
        'total_fields' => '필드 합계',
        'invalid_language' => '잘못된 언어가 지정되었습니다.',
        'default_language' => '기본값',
    ],

    'wizard' => [
        'previous' => '이전',
        'next' => '다음',
        'step_number' => '단계 :current / :total',
        'progress_restored' => '이전 진행 상황이 복원되었습니다.',
        'start_fresh' => '처음부터 시작',
    ],

    'step_condition' => [
        'title' => '단계 조건',
        'description' => '특정 조건이 충족된 경우에만 이 단계를 표시합니다. 조건이 충족되지 않으면 단계가 건너뛰어집니다.',
        'show_if' => '다음 조건일 때 이 단계 표시',
        'no_condition' => '-- 조건 없음 (항상 표시) --',
        'condition' => '조건',
        'value' => '값',
        'value_placeholder' => '일치시킬 값 입력',
        'is_checked' => '선택됨 / 체크됨',
        'is_not_checked' => '선택 안 됨 / 체크 안 됨',
        'equals' => '값과 같음',
        'not_equals' => '값과 같지 않음',
        'remove_condition' => '조건 제거',
        'no_fields_available' => '이전 단계에서 체크박스, 라디오 또는 선택 필드를 찾을 수 없습니다. 먼저 이전 단계에 필드를 추가하세요.',
        'first_step_error' => '첫 번째 단계는 이전 단계가 없으므로 조건을 가질 수 없습니다.',
        'conditional_step' => '조건부 단계',
        'add_condition' => '조건 추가',
    ],

    'file_upload' => [
        'choose_file' => '파일 선택 또는 여기에 드래그 앤 드롭',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => '찾아보기',
        'help' => '다음 파일 유형을 업로드할 수 있습니다: :types 및 최대 파일 크기는 :sizeMB입니다.',
        'remove' => '제거',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[데모 모드에서 파일이 숨겨졌습니다]',
    ],
];
