<?php

return [
    'menu' => [
        'title' => 'フォームビルダー',
        'forms' => 'フォーム',
        'submissions' => '送信',
        'reports' => 'Reports',
        'settings' => '設定',
    ],
    'forms' => [
        'title' => 'フォーム',
        'create' => 'フォームを作成',
        'edit' => 'フォームを編集',
        'view' => 'View: :name',
        'name' => 'フォーム名',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => 'コード',
        'code_help' => '自動生成する場合は空白のままにします。ショートコードで使用：[bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => '例：contact-form',
        'status' => 'ステータス',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => '送信数',
        'created_at' => '作成日',
        'actions' => 'アクション',
        'settings' => '設定',
        'fields' => 'フィールド',
        'short_code' => 'ショートコード',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => '送信',
    'tabs' => [
        'builder' => 'ビルダー',
        'actions' => 'アクション',
        'submission' => '送信',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => 'フォームビルダー',
        'components' => 'Form Components',
        'has_captcha' => 'reCAPTCHAを有効にする',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'ステップを追加',
        'form_title' => 'フォームタイトル',
        'form_title_placeholder' => '例：お問い合わせ',
        'form_title_help' => 'フォームの上に表示されるオプションのタイトル',
        'form_description' => 'フォームの説明',
        'form_description_placeholder' => '例：以下のフォームにご記入ください。24時間以内にご連絡いたします。',
        'form_description_help' => 'タイトルの下に表示されるオプションの説明',
        'field_types' => 'フィールドタイプ',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'ウィザードレイアウト',
        'wizard_layout_help' => 'マルチステップフォームの進行状況インジケーターの表示方法を選択',
        'layout_horizontal' => '横（上部にステップ）',
        'layout_vertical' => '縦（左側にステップ）',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'フォームの配置',
        'form_alignment_start' => '左（開始）',
        'form_alignment_center' => '中央',
        'form_alignment_end' => '右（終了）',
        'form_spacing' => '間隔',
        'form_margin' => '外側の余白',
        'form_margin_help' => 'フォームの外側の余白（例：20px、1rem、20px 0）',
        'form_padding' => '内側の余白',
        'form_padding_help' => 'フォームの内側の余白（例：20px、1rem、30px 20px）',
        'form_style' => 'フォームスタイル',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => '離脱意図',
        'popup_trigger_exit_intent_help' => 'マウス付きのデスクトップデバイスでのみ動作します。ユーザーがカーソルをページ外に移動すると発動。セッションごとに1回表示。',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => 'フォーム送信',
        'view' => '送信を表示',
        'info' => '送信情報',
        'form' => 'フォーム',
        'identifier' => 'Identifier',
        'data' => '送信データ',
        'submitted_at' => '送信日時',
        'ip_address' => 'IPアドレス',
        'user_agent' => 'ユーザーエージェント',
        'page_url' => 'ページURL',
        'referrer_url' => '参照元URL',
        'url_tracking_title' => '送信元',
        'no_submissions' => '送信が見つかりません。',
        'back' => '戻る',
        'delete' => '削除',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => '送信設定',
        'on_success' => '成功時',
        'on_failure' => '失敗時',
        'action' => 'アクション',
        'content' => 'コンテンツ',
        'show_message' => 'メッセージを表示',
        'redirect_to' => 'リダイレクト先',
        'message_placeholder' => 'ご送信ありがとうございます！',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://example.jp/thank-you',
    ],
    'actions' => [
        'title' => 'フォームアクション',
        'add' => 'アクションを追加',
        'configure' => 'アクションを設定',
        'placeholder_hint' => '[field_name]を使用してフィールド値を挿入',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => '左パネルからアクションをクリックしてフォームに追加',
        'no_database_action_warning' => '「データベースに保存」アクションが設定されていません',
        'no_database_action_warning_hint' => 'フォーム送信データはデータベースに保存されず、送信ページにも表示されません。',

        'email' => [
            'name' => 'メール通知',
            'description' => 'Send email notifications when form is submitted',
            'to' => '宛先',
            'to_help' => '受信者のメールアドレスをカンマ区切りで入力',
            'subject' => '件名',
            'subject_help' => '[field_name]を使用してフィールド値を挿入',
            'body' => '本文',
            'body_help' => '[field_name]を使用してフィールド値を挿入',
        ],
        'database' => [
            'name' => 'データベースに保存',
            'description' => 'Store submissions in the database',
            'unique_field' => '一意のフィールド',
            'unique_field_help' => '重複送信を防ぐフィールド名（オプション）',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'エンドポイントURL',
            'method' => 'HTTPメソッド',
            'body' => 'リクエストボディ（JSON）',
            'body_help' => '[field_name]を使用してJSONにフィールド値を挿入',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => 'フォーム',
        'description' => 'フォームを表示',
        'form' => 'フォームを選択',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => 'フォームビルダー設定',
        'description' => 'フォームビルダーの設定を構成',
        'allowed_mimes' => '許可されたファイルタイプ',
        'allowed_mimes_help' => '許可されたファイル拡張子のカンマ区切りリスト',
        'max_file_size' => '最大ファイルサイズ（MB）',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => '外観設定',
            'description' => 'フォームの外観をカスタマイズ',
            'primary_color' => 'プライマリカラー',
            'primary_color_help' => 'ボタン、アクティブ状態、フォーカスリングに使用',
            'primary_hover_color' => 'プライマリホバーカラー',
            'success_color' => '成功カラー',
            'success_color_help' => '成功メッセージと完了ステップに使用',
            'danger_color' => '危険カラー',
            'danger_color_help' => 'エラーメッセージと検証エラーに使用',
            'text_color' => 'テキストカラー',
            'border_color' => 'ボーダーカラー',
            'background_color' => '背景色',
            'border_radius' => 'ボーダー半径',
            'border_radius_options' => [
                'none' => 'なし（0）',
                'small' => '小（4px）',
                'medium' => '中（8px）',
                'large' => '大（12px）',
                'extra_large' => '特大（16px）',
                'pill' => 'ピル',
            ],
            'enable_shadow' => 'ボックスシャドウを有効にする',
            'enable_shadow_help' => 'フォームコンテナに微妙な影効果を追加',
            'button_radius' => 'ボタンボーダー半径',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => 'フォームが見つかりません。',
        'form_inactive' => 'このフォームはアクティブではありません。',
        'submission_success' => 'ご送信ありがとうございます！',
        'submission_failed' => 'エラーが発生しました。もう一度お試しください。',
        'captcha_invalid' => 'キャプチャを完了してください。',
        'duplicate_submission' => 'このフォームは既に送信されています。',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => 'アクティブ',
            'inactive' => '非アクティブ',
        ],
    ],
    'embed' => [
        'title' => '埋め込みコード',
        'description' => 'このコードをコピーして外部ウェブサイトにフォームを埋め込む',
        'copy' => 'コピー',
        'copied' => 'コピーしました！',
        'shortcode' => 'ショートコード',
        'url' => '埋め込みURL',
                'url_friendly' => '埋め込みURL',
        'url_secure' => '埋め込みURL',
        'friendly' => 'フレンドリー',
        'secure' => 'セキュア',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => '次に、プラットフォーム管理 → キャッシュ管理でキャッシュをクリアしてください。',
        'botble_site_step_1' => 'ターゲットのBotbleサイトの.envファイルに追加してください:',
        'botble_site_instructions' => '別のBotbleサイトへの埋め込み',
        'iframe_code_hint' => 'エディタのHTMLボタンまたはカスタムHTML UIブロックを使用して埋め込みます。',
        'js_embed' => 'JavaScriptで埋め込み',
        'js_embed_hint' => 'より細かい制御とレスポンシブ対応のために、JavaScript埋め込みコードをご利用ください:',
        'iframe_code' => 'Iframe埋め込みコード',
    ],

    'export_import' => [
        'title' => 'エクスポート / インポート',
        'description' => 'このフォームをJSONにエクスポートするか、他のサイトからインポート',
        'export' => 'JSONにエクスポート',
        'export_description' => 'このフォームをJSONファイルとしてダウンロードして他のサイトで使用',
        'import' => 'フォームをインポート',
        'import_description' => 'JSONファイルからフォームをインポート',
        'import_button' => 'JSONからインポート',
        'select_file' => 'JSONファイルを選択',
        'import_success' => 'フォームのインポートに成功しました！',
        'import_error' => 'フォームのインポートに失敗しました。ファイル形式を確認してください。',
        'invalid_file' => '無効なファイル形式です。有効なJSONファイルをアップロードしてください。',
        'invalid_format' => '無効なフォームデータ形式です。',
        'exported_at' => 'エクスポート日時',
        'exported_from' => 'エクスポート元',
        'version' => 'バージョン',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => 'フォームを翻訳',
        'description' => 'このフォームの翻訳済みコンテンツを編集します。フィールド構造はここでは変更できません。ラベル、プレースホルダー、テキストのみ翻訳できます。',
        'field_labels' => 'フィールドラベル',
        'field_name' => 'フィールド名',
        'original_label' => 'オリジナル',
        'translated_label' => '翻訳',
        'placeholder' => 'プレースホルダー',
        'option' => 'オプション',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'フォームのプロパティ',
        'no_popup_properties' => 'このフォームはポップアップモードを使用していません。翻訳可能なプロパティはありません。',
        'submission_messages' => '送信メッセージ',
        'leave_empty_for_default' => '空のままにするとデフォルトメッセージを使用します',
        'back_to_default' => 'デフォルト言語に戻る',
        'form_preview' => 'フォーム情報',
        'total_fields' => 'フィールド合計',
        'invalid_language' => '指定された言語が無効です。',
        'default_language' => 'デフォルト',
    ],

    'wizard' => [
        'previous' => '前へ',
        'next' => '次へ',
        'step_number' => 'ステップ :current / :total',
        'progress_restored' => '以前の進捗が復元されました。',
        'start_fresh' => '最初から始める',
    ],

    'step_condition' => [
        'title' => 'ステップ条件',
        'description' => '特定の条件が満たされた場合にのみこのステップを表示します。条件が満たされない場合、ステップはスキップされます。',
        'show_if' => '次の場合にこのステップを表示',
        'no_condition' => '-- 条件なし（常に表示） --',
        'condition' => '条件',
        'value' => '値',
        'value_placeholder' => '一致する値を入力',
        'is_checked' => 'チェックされている / 選択されている',
        'is_not_checked' => 'チェックされていない / 選択されていない',
        'equals' => '値と等しい',
        'not_equals' => '値と等しくない',
        'remove_condition' => '条件を削除',
        'no_fields_available' => '前のステップにチェックボックス、ラジオ、またはセレクトフィールドが見つかりません。最初に前のステップにフィールドを追加してください。',
        'first_step_error' => '最初のステップには前のステップがないため、条件を設定できません。',
        'conditional_step' => '条件付きステップ',
        'add_condition' => '条件を追加',
    ],

    'file_upload' => [
        'choose_file' => 'ファイルを選択またはここにドラッグ＆ドロップ',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => '参照',
        'help' => '次のファイルタイプをアップロードできます：:types、最大ファイルサイズは:sizeMBです。',
        'remove' => '削除',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[デモモードでファイルが非表示になっています]',
    ],
];
