<?php

return [
    'menu' => [
        'title' => 'BB Form Builder',
        'forms' => 'Forms',
        'submissions' => 'Submissions',
        'reports' => 'Reports',
        'settings' => 'Settings',
    ],
    'forms' => [
        'title' => 'Forms',
        'create' => 'Create Form',
        'edit' => 'Edit Form',
        'view' => 'View: :name',
        'name' => 'Form Name',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => 'Code',
        'code_help' => 'Leave blank to auto-generate. Used in shortcode: [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => 'e.g., contact-form',
        'status' => 'Status',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => 'Submissions',
        'created_at' => 'Created At',
        'actions' => 'Actions',
        'settings' => 'Settings',
        'fields' => 'Fields',
        'short_code' => 'Shortcode',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => 'Submit',
    'tabs' => [
        'builder' => 'Builder',
        'actions' => 'Actions',
        'submission' => 'Submission',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => 'BB Form Builder',
        'components' => 'Form Components',
        'has_captcha' => 'Enable reCAPTCHA',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'Add Step',
        'form_title' => 'כותרת הטופס',
        'form_title_placeholder' => 'לדוגמה, צור קשר',
        'form_title_help' => 'כותרת אופציונלית המוצגת מעל הטופס',
        'form_description' => 'תיאור הטופס',
        'form_description_placeholder' => 'לדוגמה, מלא את הטופס למטה ונחזור אליך תוך 24 שעות.',
        'form_description_help' => 'תיאור אופציונלי המוצג מתחת לכותרת',
        'field_types' => 'Field Types',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'Wizard Layout',
        'wizard_layout_help' => 'Choose how multi-step forms display their progress indicators',
        'layout_horizontal' => 'Horizontal (steps on top)',
        'layout_vertical' => 'Vertical (steps on left side)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'יישור הטופס',
        'form_alignment_start' => 'שמאל (התחלה)',
        'form_alignment_center' => 'מרכז',
        'form_alignment_end' => 'ימין (סוף)',
        'form_spacing' => 'ריווח',
        'form_margin' => 'שוליים חיצוניים',
        'form_margin_help' => 'רווח מחוץ לטופס (לדוגמה, 20px, 1rem, 20px 0)',
        'form_padding' => 'ריפוד פנימי',
        'form_padding_help' => 'רווח בתוך הטופס (לדוגמה, 20px, 1rem, 30px 20px)',
        'form_style' => 'סגנון הטופס',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => 'כוונת יציאה',
        'popup_trigger_exit_intent_help' => 'פועל רק במחשבים שולחניים עם עכבר. מופעל כאשר המשתמש מזיז את הסמן מחוץ לדף. מוצג פעם אחת בכל הפעלה.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => 'Form Submissions',
        'view' => 'View Submission',
        'info' => 'Submission Info',
        'form' => 'Form',
        'identifier' => 'Identifier',
        'data' => 'Submission Data',
        'submitted_at' => 'Submitted At',
        'ip_address' => 'IP Address',
        'user_agent' => 'User Agent',
        'page_url' => 'כתובת URL של הדף',
        'referrer_url' => 'כתובת URL מפנה',
        'url_tracking_title' => 'מקור ההגשה',
        'no_submissions' => 'No submissions found.',
        'back' => 'Back',
        'delete' => 'Delete',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => 'Submission Settings',
        'on_success' => 'On Success',
        'on_failure' => 'On Failure',
        'action' => 'Action',
        'content' => 'Content',
        'show_message' => 'Show Message',
        'redirect_to' => 'Redirect To',
        'message_placeholder' => 'Thank you for your submission!',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://example.com/thank-you',
    ],
    'actions' => [
        'title' => 'Form Actions',
        'add' => 'Add Action',
        'configure' => 'Configure Actions',
        'placeholder_hint' => 'Use [field_name] to insert field values',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => 'לחץ על פעולה מהפאנל השמאלי כדי להוסיף אותה לטופס שלך',
        'no_database_action_warning' => 'לא הוגדרה פעולת "שמירה במסד נתונים"',
        'no_database_action_warning_hint' => 'שליחות טפסים לא יישמרו במסד הנתונים ולא יופיעו בדף השליחות.',

        'email' => [
            'name' => 'Email Notification',
            'description' => 'Send email notifications when form is submitted',
            'to' => 'To',
            'to_help' => 'Enter recipient email addresses, separated by commas',
            'subject' => 'Subject',
            'subject_help' => 'Use [field_name] to insert field values',
            'body' => 'Body',
            'body_help' => 'Use [field_name] to insert field values',
        ],
        'database' => [
            'name' => 'Save to Database',
            'description' => 'Store submissions in the database',
            'unique_field' => 'Unique Field',
            'unique_field_help' => 'Field name to prevent duplicate submissions (optional)',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'Endpoint URL',
            'method' => 'HTTP Method',
            'body' => 'Request Body (JSON)',
            'body_help' => 'Use [field_name] to insert field values in JSON',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => 'Form',
        'description' => 'Display a form',
        'form' => 'Select Form',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => 'BB Form Builder Settings',
        'description' => 'Configure form builder settings',
        'allowed_mimes' => 'Allowed File Types',
        'allowed_mimes_help' => 'Comma-separated list of allowed file extensions',
        'max_file_size' => 'Max File Size (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => 'Appearance Settings',
            'description' => 'Customize the look and feel of your forms',
            'primary_color' => 'Primary Color',
            'primary_color_help' => 'Used for buttons, active states, and focus rings',
            'primary_hover_color' => 'Primary Hover Color',
            'success_color' => 'Success Color',
            'success_color_help' => 'Used for success messages and completed steps',
            'danger_color' => 'Danger Color',
            'danger_color_help' => 'Used for error messages and validation errors',
            'text_color' => 'Text Color',
            'border_color' => 'Border Color',
            'background_color' => 'Background Color',
            'border_radius' => 'Border Radius',
            'border_radius_options' => [
                'none' => 'None (0)',
                'small' => 'Small (4px)',
                'medium' => 'Medium (8px)',
                'large' => 'Large (12px)',
                'extra_large' => 'Extra Large (16px)',
                'pill' => 'Pill',
            ],
            'enable_shadow' => 'Enable Box Shadow',
            'enable_shadow_help' => 'Add subtle shadow effect to the form container',
            'button_radius' => 'Button Border Radius',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => 'Form not found.',
        'form_inactive' => 'This form is not active.',
        'submission_success' => 'Thank you for your submission!',
        'submission_failed' => 'An error occurred. Please try again.',
        'captcha_invalid' => 'Please complete the captcha.',
        'duplicate_submission' => 'You have already submitted this form.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => 'Active',
            'inactive' => 'Inactive',
        ],
    ],
    'embed' => [
        'title' => 'Embed Code',
        'description' => 'Copy this code to embed the form on external websites',
        'copy' => 'Copy',
        'copied' => 'Copied!',
        'shortcode' => 'Shortcode',
        'url' => 'Embed URL',
                'url_friendly' => 'כתובת URL להטמעה',
        'url_secure' => 'כתובת URL להטמעה',
        'friendly' => 'ידידותי',
        'secure' => 'מאובטח',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => 'לאחר מכן נקה את המטמון בניהול פלטפורמה ← ניהול מטמון.',
        'botble_site_step_1' => 'הוסף זאת לקובץ .env של אתר Botble היעד:',
        'botble_site_instructions' => 'הטמעה באתר Botble אחר',
        'iframe_code_hint' => 'השתמש בכפתור HTML בעורך או בבלוק HTML מותאם אישית להטמעה.',
        'js_embed' => 'הטמעה באמצעות JavaScript',
        'js_embed_hint' => 'לשליטה רבה יותר ותגובתיות טובה יותר, השתמש בקוד ההטמעה JavaScript שלנו:',
        'iframe_code' => 'קוד הטמעת iframe',
    ],

    'export_import' => [
        'title' => 'Export / Import',
        'description' => 'Export this form to JSON or import from another site',
        'export' => 'Export to JSON',
        'export_description' => 'Download this form as a JSON file to use on another site',
        'import' => 'Import Form',
        'import_description' => 'Import a form from a JSON file',
        'import_button' => 'Import from JSON',
        'select_file' => 'Select JSON file',
        'import_success' => 'Form imported successfully!',
        'import_error' => 'Failed to import form. Please check the file format.',
        'invalid_file' => 'Invalid file format. Please upload a valid JSON file.',
        'invalid_format' => 'Invalid form data format.',
        'exported_at' => 'Exported at',
        'exported_from' => 'Exported from',
        'version' => 'Version',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => 'תרגום טופס',
        'description' => 'ערכו את התוכן המתורגם של טופס זה. לא ניתן לשנות כאן את מבנה השדות – ניתן לתרגם רק תוויות, מצייני מקום וטקסטים.',
        'field_labels' => 'תוויות שדות',
        'field_name' => 'שם השדה',
        'original_label' => 'מקור',
        'translated_label' => 'תרגום',
        'placeholder' => 'מציין מקום',
        'option' => 'אפשרות',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'מאפייני הטופס',
        'no_popup_properties' => 'טופס זה אינו משתמש במצב קופץ. אין מאפיינים זמינים לתרגום.',
        'submission_messages' => 'הודעות שליחה',
        'leave_empty_for_default' => 'השאר ריק כדי להשתמש בהודעה ברירת המחדל',
        'back_to_default' => 'חזרה לשפת ברירת המחדל',
        'form_preview' => 'מידע על הטופס',
        'total_fields' => 'סך השדות',
        'invalid_language' => 'שפה לא חוקית צוינה.',
        'default_language' => 'ברירת מחדל',
    ],

    'wizard' => [
        'previous' => 'הקודם',
        'next' => 'הבא',
        'step_number' => 'שלב :current מתוך :total',
        'progress_restored' => 'ההתקדמות הקודמת שלך שוחזרה.',
        'start_fresh' => 'התחל מחדש',
    ],
    'file_upload' => [
        'choose_file' => 'בחר קובץ או גרור ושחרר כאן',
        'choose_image' => 'בחר תמונה או גרור ושחרר כאן',
        'browse' => 'עיון',
        'help' => 'ניתן להעלות את סוגי הקבצים הבאים: :types וגודל קובץ מקסימלי הוא :sizeMB.',
        'remove' => 'הסר',
    ],
    'validation' => [
        'required' => 'שדה זה הוא חובה.',
        'email' => 'נא להזין כתובת דוא"ל תקפה.',
        'phone' => 'נא להזין מספר טלפון תקף.',
        'dangerous_extension' => 'סוג הקובץ ":extension" אינו מורשה מסיבות אבטחה.',
        'invalid_filename' => 'שם הקובץ מכיל תווים לא תקפים.',
        'invalid_image_type' => 'הקובץ אינו סוג תמונה תקף.',
        'invalid_image' => 'הקובץ אינו תמונה תקפה.',
        'mime_mismatch' => 'סוג הקובץ אינו תואם לסיומת שלו.',
        'malicious_content' => 'הקובץ מכיל תוכן שעלול להיות מזיק.',
        'invalid_file' => 'הקובץ שהועלה אינו תקף.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[הקובץ מוסתר במצב הדגמה]',
    ],
];
