<?php

return [
    'menu' => [
        'title' => 'Constructeur de formulaires',
        'forms' => 'Formulaires',
        'submissions' => 'Soumissions',
        'reports' => 'Reports',
        'settings' => 'Paramètres',
    ],
    'forms' => [
        'title' => 'Formulaires',
        'create' => 'Créer un formulaire',
        'edit' => 'Modifier le formulaire',
        'view' => 'View: :name',
        'name' => 'Nom du formulaire',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => 'Code',
        'code_help' => 'Laisser vide pour générer automatiquement. Utilisé dans le shortcode : [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => 'ex., formulaire-contact',
        'status' => 'Statut',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => 'Soumissions',
        'created_at' => 'Créé le',
        'actions' => 'Actions',
        'settings' => 'Paramètres',
        'fields' => 'Champs',
        'short_code' => 'Shortcode',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => 'Soumettre',
    'tabs' => [
        'builder' => 'Constructeur',
        'actions' => 'Actions',
        'submission' => 'Soumission',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => 'Constructeur de formulaires',
        'components' => 'Form Components',
        'has_captcha' => 'Activer reCAPTCHA',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'Ajouter une étape',
        'form_title' => 'Titre du formulaire',
        'form_title_placeholder' => 'ex., Contactez-nous',
        'form_title_help' => 'Titre optionnel affiché au-dessus du formulaire',
        'form_description' => 'Description du formulaire',
        'form_description_placeholder' => 'ex., Remplissez le formulaire ci-dessous et nous vous répondrons dans les 24 heures.',
        'form_description_help' => 'Description optionnelle affichée sous le titre',
        'field_types' => 'Types de champs',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'Disposition de l\'assistant',
        'wizard_layout_help' => 'Choisissez comment les formulaires multi-étapes affichent leurs indicateurs de progression',
        'layout_horizontal' => 'Horizontal (étapes en haut)',
        'layout_vertical' => 'Vertical (étapes à gauche)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'Alignement du formulaire',
        'form_alignment_start' => 'Gauche (Début)',
        'form_alignment_center' => 'Centre',
        'form_alignment_end' => 'Droite (Fin)',
        'form_spacing' => 'Espacement',
        'form_margin' => 'Marge',
        'form_margin_help' => 'Espace à l\'extérieur du formulaire (ex., 20px, 1rem, 20px 0)',
        'form_padding' => 'Rembourrage',
        'form_padding_help' => 'Espace à l\'intérieur du formulaire (ex., 20px, 1rem, 30px 20px)',
        'form_style' => 'Style du formulaire',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => 'Exit Intent',
        'popup_trigger_exit_intent_help' => 'Fonctionne uniquement sur les appareils de bureau avec souris. Se déclenche lorsque l\'utilisateur déplace le curseur hors de la page. S\'affiche une fois par session.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => 'Soumissions de formulaires',
        'view' => 'Voir la soumission',
        'info' => 'Informations sur la soumission',
        'form' => 'Formulaire',
        'identifier' => 'Identifier',
        'data' => 'Données de soumission',
        'submitted_at' => 'Soumis le',
        'ip_address' => 'Adresse IP',
        'user_agent' => 'Agent utilisateur',
        'page_url' => 'URL de la page',
        'referrer_url' => 'URL de référence',
        'url_tracking_title' => 'Source de la soumission',
        'no_submissions' => 'Aucune soumission trouvée.',
        'back' => 'Retour',
        'delete' => 'Supprimer',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => 'Paramètres de soumission',
        'on_success' => 'En cas de succès',
        'on_failure' => 'En cas d\'échec',
        'action' => 'Action',
        'content' => 'Contenu',
        'show_message' => 'Afficher le message',
        'redirect_to' => 'Rediriger vers',
        'message_placeholder' => 'Merci pour votre soumission !',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://exemple.com/merci',
    ],
    'actions' => [
        'title' => 'Actions du formulaire',
        'add' => 'Ajouter une action',
        'configure' => 'Configurer les actions',
        'placeholder_hint' => 'Utilisez [field_name] pour insérer des valeurs de champ',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => 'Cliquez sur une action dans le panneau de gauche pour l\'ajouter à votre formulaire',
        'no_database_action_warning' => 'Aucune action "Enregistrer dans la base de données" configurée',
        'no_database_action_warning_hint' => 'Les soumissions de formulaire ne seront pas stockées dans la base de données et n\'apparaîtront pas sur la page des soumissions.',

        'email' => [
            'name' => 'Notification par e-mail',
            'description' => 'Send email notifications when form is submitted',
            'to' => 'À',
            'to_help' => 'Entrez les adresses e-mail des destinataires, séparées par des virgules',
            'subject' => 'Sujet',
            'subject_help' => 'Utilisez [field_name] pour insérer des valeurs de champ',
            'body' => 'Corps',
            'body_help' => 'Utilisez [field_name] pour insérer des valeurs de champ',
        ],
        'database' => [
            'name' => 'Enregistrer dans la base de données',
            'description' => 'Store submissions in the database',
            'unique_field' => 'Champ unique',
            'unique_field_help' => 'Nom du champ pour éviter les soumissions en double (facultatif)',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'URL du point de terminaison',
            'method' => 'Méthode HTTP',
            'body' => 'Corps de la requête (JSON)',
            'body_help' => 'Utilisez [field_name] pour insérer des valeurs de champ en JSON',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => 'Formulaire',
        'description' => 'Afficher un formulaire',
        'form' => 'Sélectionner le formulaire',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => 'Paramètres du constructeur de formulaires',
        'description' => 'Configurer les paramètres du constructeur de formulaires',
        'allowed_mimes' => 'Types de fichiers autorisés',
        'allowed_mimes_help' => 'Liste séparée par des virgules des extensions de fichiers autorisées',
        'max_file_size' => 'Taille maximale du fichier (Mo)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => 'Paramètres d\'apparence',
            'description' => 'Personnaliser l\'apparence de vos formulaires',
            'primary_color' => 'Couleur primaire',
            'primary_color_help' => 'Utilisé pour les boutons, les états actifs et les anneaux de focus',
            'primary_hover_color' => 'Couleur primaire au survol',
            'success_color' => 'Couleur de succès',
            'success_color_help' => 'Utilisé pour les messages de succès et les étapes terminées',
            'danger_color' => 'Couleur de danger',
            'danger_color_help' => 'Utilisé pour les messages d\'erreur et les erreurs de validation',
            'text_color' => 'Couleur du texte',
            'border_color' => 'Couleur de la bordure',
            'background_color' => 'Couleur de fond',
            'border_radius' => 'Rayon de la bordure',
            'border_radius_options' => [
                'none' => 'Aucun (0)',
                'small' => 'Petit (4px)',
                'medium' => 'Moyen (8px)',
                'large' => 'Grand (12px)',
                'extra_large' => 'Très grand (16px)',
                'pill' => 'Pilule',
            ],
            'enable_shadow' => 'Activer l\'ombre de la boîte',
            'enable_shadow_help' => 'Ajouter un effet d\'ombre subtil au conteneur du formulaire',
            'button_radius' => 'Rayon de la bordure du bouton',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => 'Formulaire non trouvé.',
        'form_inactive' => 'Ce formulaire n\'est pas actif.',
        'submission_success' => 'Merci pour votre soumission !',
        'submission_failed' => 'Une erreur s\'est produite. Veuillez réessayer.',
        'captcha_invalid' => 'Veuillez compléter le captcha.',
        'duplicate_submission' => 'Vous avez déjà soumis ce formulaire.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => 'Actif',
            'inactive' => 'Inactif',
        ],
    ],
    'embed' => [
        'title' => 'Code d\'intégration',
        'description' => 'Copiez ce code pour intégrer le formulaire sur des sites web externes',
        'copy' => 'Copier',
        'copied' => 'Copié !',
        'shortcode' => 'Shortcode',
        'url' => 'URL d\'intégration',
                'url_friendly' => 'URL d\'intégration',
        'url_secure' => 'URL d\'intégration',
        'friendly' => 'Convivial',
        'secure' => 'Sécurisé',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => 'Ensuite, videz le cache dans Administration de la plateforme → Gestion du cache.',
        'botble_site_step_1' => 'Ajoutez ceci au fichier .env de votre site Botble cible:',
        'botble_site_instructions' => 'Intégration sur un autre site Botble',
        'iframe_code_hint' => 'Utilisez le bouton HTML dans l\'éditeur ou le bloc HTML personnalisé pour intégrer.',
        'js_embed' => 'Intégrer via JavaScript',
        'js_embed_hint' => 'Pour plus de contrôle et une meilleure réactivité, utilisez notre code d\'intégration JavaScript:',
        'iframe_code' => 'Code d\'intégration iframe',
    ],

    'export_import' => [
        'title' => 'Export / Import',
        'description' => 'Exporter ce formulaire en JSON ou importer depuis un autre site',
        'export' => 'Exporter en JSON',
        'export_description' => 'Télécharger ce formulaire sous forme de fichier JSON pour l\'utiliser sur un autre site',
        'import' => 'Importer un formulaire',
        'import_description' => 'Importer un formulaire depuis un fichier JSON',
        'import_button' => 'Importer depuis JSON',
        'select_file' => 'Sélectionner un fichier JSON',
        'import_success' => 'Formulaire importé avec succès !',
        'import_error' => 'Échec de l\'importation du formulaire. Veuillez vérifier le format du fichier.',
        'invalid_file' => 'Format de fichier invalide. Veuillez télécharger un fichier JSON valide.',
        'invalid_format' => 'Format de données de formulaire invalide.',
        'exported_at' => 'Exporté le',
        'exported_from' => 'Exporté depuis',
        'version' => 'Version',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => 'Traduire le formulaire',
        'description' => 'Modifiez le contenu traduit de ce formulaire. La structure des champs ne peut pas être modifiée ici ; seules les étiquettes, les espaces réservés et les textes peuvent être traduits.',
        'field_labels' => 'Libellés des champs',
        'field_name' => 'Nom du champ',
        'original_label' => 'Original',
        'translated_label' => 'Traduction',
        'placeholder' => 'Texte indicatif',
        'option' => 'Option',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'Propriétés du formulaire',
        'no_popup_properties' => 'Ce formulaire n\'utilise pas le mode popup. Aucune propriété traduisible disponible.',
        'submission_messages' => 'Messages d\'envoi',
        'leave_empty_for_default' => 'Laissez vide pour utiliser le message par défaut',
        'back_to_default' => 'Retour à la langue par défaut',
        'form_preview' => 'Informations du formulaire',
        'total_fields' => 'Nombre total de champs',
        'invalid_language' => 'Langue spécifiée invalide.',
        'default_language' => 'Par défaut',
    ],

    'wizard' => [
        'previous' => 'Précédent',
        'next' => 'Suivant',
        'step_number' => 'Étape :current sur :total',
        'progress_restored' => 'Votre progression précédente a été restaurée.',
        'start_fresh' => 'Recommencer',
    ],

    'step_condition' => [
        'title' => 'Condition d\'étape',
        'description' => 'Afficher cette étape uniquement lorsqu\'une condition spécifique est remplie. Si la condition n\'est pas remplie, l\'étape sera ignorée.',
        'show_if' => 'Afficher cette étape si',
        'no_condition' => '-- Aucune condition (toujours afficher) --',
        'condition' => 'Condition',
        'value' => 'Valeur',
        'value_placeholder' => 'Entrez la valeur à correspondre',
        'is_checked' => 'Est coché / sélectionné',
        'is_not_checked' => 'N\'est pas coché / non sélectionné',
        'equals' => 'Égal à la valeur',
        'not_equals' => 'N\'est pas égal à la valeur',
        'remove_condition' => 'Supprimer la condition',
        'no_fields_available' => 'Aucun champ de case à cocher, radio ou sélection trouvé dans les étapes précédentes. Ajoutez d\'abord des champs aux étapes précédentes.',
        'first_step_error' => 'La première étape ne peut pas avoir de conditions car il n\'y a pas d\'étapes précédentes.',
        'conditional_step' => 'Étape conditionnelle',
        'add_condition' => 'Ajouter une condition',
    ],

    'file_upload' => [
        'choose_file' => 'Choisir un fichier ou glisser-déposer ici',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => 'Parcourir',
        'help' => 'Vous pouvez télécharger les types de fichiers suivants : :types et la taille maximale du fichier est :sizeMB.',
        'remove' => 'Supprimer',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[Fichier masqué en mode démo]',
    ],
];
