<?php

return [
    'menu' => [
        'title' => 'Constructor de formularios',
        'forms' => 'Formularios',
        'submissions' => 'Envíos',
        'reports' => 'Reports',
        'settings' => 'Configuración',
    ],
    'forms' => [
        'title' => 'Formularios',
        'create' => 'Crear formulario',
        'edit' => 'Editar formulario',
        'view' => 'View: :name',
        'name' => 'Nombre del formulario',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => 'Código',
        'code_help' => 'Dejar en blanco para generar automáticamente. Se usa en shortcode: [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => 'ej., formulario-contacto',
        'status' => 'Estado',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => 'Envíos',
        'created_at' => 'Creado el',
        'actions' => 'Acciones',
        'settings' => 'Configuración',
        'fields' => 'Campos',
        'short_code' => 'Shortcode',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => 'Enviar',
    'tabs' => [
        'builder' => 'Constructor',
        'actions' => 'Acciones',
        'submission' => 'Envío',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => 'Constructor de formularios',
        'components' => 'Form Components',
        'has_captcha' => 'Habilitar reCAPTCHA',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'Agregar paso',
        'form_title' => 'Título del formulario',
        'form_title_placeholder' => 'ej., Contáctenos',
        'form_title_help' => 'Título opcional que se muestra encima del formulario',
        'form_description' => 'Descripción del formulario',
        'form_description_placeholder' => 'ej., Complete el formulario a continuación y nos pondremos en contacto con usted dentro de las 24 horas.',
        'form_description_help' => 'Descripción opcional que se muestra debajo del título',
        'field_types' => 'Tipos de campo',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'Diseño del asistente',
        'wizard_layout_help' => 'Elija cómo los formularios de varios pasos muestran sus indicadores de progreso',
        'layout_horizontal' => 'Horizontal (pasos arriba)',
        'layout_vertical' => 'Vertical (pasos a la izquierda)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'Alineación del formulario',
        'form_alignment_start' => 'Izquierda (Inicio)',
        'form_alignment_center' => 'Centro',
        'form_alignment_end' => 'Derecha (Fin)',
        'form_spacing' => 'Espaciado',
        'form_margin' => 'Margen',
        'form_margin_help' => 'Espacio fuera del formulario (ej., 20px, 1rem, 20px 0)',
        'form_padding' => 'Relleno',
        'form_padding_help' => 'Espacio dentro del formulario (ej., 20px, 1rem, 30px 20px)',
        'form_style' => 'Estilo del formulario',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => 'Exit Intent',
        'popup_trigger_exit_intent_help' => 'Solo funciona en dispositivos de escritorio con ratón. Se activa cuando el usuario mueve el cursor fuera de la página. Se muestra una vez por sesión.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => 'Envíos de formularios',
        'view' => 'Ver envío',
        'info' => 'Información del envío',
        'form' => 'Formulario',
        'identifier' => 'Identifier',
        'data' => 'Datos del envío',
        'submitted_at' => 'Enviado el',
        'ip_address' => 'Dirección IP',
        'user_agent' => 'Agente de usuario',
        'page_url' => 'URL de la página',
        'referrer_url' => 'URL de referencia',
        'url_tracking_title' => 'Origen del envío',
        'no_submissions' => 'No se encontraron envíos.',
        'back' => 'Volver',
        'delete' => 'Eliminar',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => 'Configuración de envío',
        'on_success' => 'En caso de éxito',
        'on_failure' => 'En caso de fallo',
        'action' => 'Acción',
        'content' => 'Contenido',
        'show_message' => 'Mostrar mensaje',
        'redirect_to' => 'Redirigir a',
        'message_placeholder' => '¡Gracias por su envío!',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://ejemplo.com/gracias',
    ],
    'actions' => [
        'title' => 'Acciones del formulario',
        'add' => 'Agregar acción',
        'configure' => 'Configurar acciones',
        'placeholder_hint' => 'Use [field_name] para insertar valores de campo',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => 'Haga clic en una acción del panel izquierdo para agregarla a su formulario',
        'no_database_action_warning' => 'No hay acción "Guardar en base de datos" configurada',
        'no_database_action_warning_hint' => 'Los envíos de formularios no se almacenarán en la base de datos y no aparecerán en la página de Envíos.',

        'email' => [
            'name' => 'Notificación por correo electrónico',
            'description' => 'Send email notifications when form is submitted',
            'to' => 'Para',
            'to_help' => 'Ingrese las direcciones de correo electrónico de los destinatarios, separadas por comas',
            'subject' => 'Asunto',
            'subject_help' => 'Use [field_name] para insertar valores de campo',
            'body' => 'Cuerpo',
            'body_help' => 'Use [field_name] para insertar valores de campo',
        ],
        'database' => [
            'name' => 'Guardar en base de datos',
            'description' => 'Store submissions in the database',
            'unique_field' => 'Campo único',
            'unique_field_help' => 'Nombre del campo para evitar envíos duplicados (opcional)',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'URL del endpoint',
            'method' => 'Método HTTP',
            'body' => 'Cuerpo de la solicitud (JSON)',
            'body_help' => 'Use [field_name] para insertar valores de campo en JSON',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => 'Formulario',
        'description' => 'Mostrar un formulario',
        'form' => 'Seleccionar formulario',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => 'Configuración del constructor de formularios',
        'description' => 'Configurar ajustes del constructor de formularios',
        'allowed_mimes' => 'Tipos de archivo permitidos',
        'allowed_mimes_help' => 'Lista separada por comas de extensiones de archivo permitidas',
        'max_file_size' => 'Tamaño máximo de archivo (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => 'Configuración de apariencia',
            'description' => 'Personalizar el aspecto de sus formularios',
            'primary_color' => 'Color primario',
            'primary_color_help' => 'Usado para botones, estados activos y anillos de enfoque',
            'primary_hover_color' => 'Color primario al pasar el mouse',
            'success_color' => 'Color de éxito',
            'success_color_help' => 'Usado para mensajes de éxito y pasos completados',
            'danger_color' => 'Color de peligro',
            'danger_color_help' => 'Usado para mensajes de error y errores de validación',
            'text_color' => 'Color del texto',
            'border_color' => 'Color del borde',
            'background_color' => 'Color de fondo',
            'border_radius' => 'Radio del borde',
            'border_radius_options' => [
                'none' => 'Ninguno (0)',
                'small' => 'Pequeño (4px)',
                'medium' => 'Mediano (8px)',
                'large' => 'Grande (12px)',
                'extra_large' => 'Extra grande (16px)',
                'pill' => 'Píldora',
            ],
            'enable_shadow' => 'Habilitar sombra de caja',
            'enable_shadow_help' => 'Agregar efecto de sombra sutil al contenedor del formulario',
            'button_radius' => 'Radio del borde del botón',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => 'Formulario no encontrado.',
        'form_inactive' => 'Este formulario no está activo.',
        'submission_success' => '¡Gracias por su envío!',
        'submission_failed' => 'Ocurrió un error. Por favor, inténtelo de nuevo.',
        'captcha_invalid' => 'Por favor, complete el captcha.',
        'duplicate_submission' => 'Ya ha enviado este formulario.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => 'Activo',
            'inactive' => 'Inactivo',
        ],
    ],
    'embed' => [
        'title' => 'Código de inserción',
        'description' => 'Copie este código para insertar el formulario en sitios web externos',
        'copy' => 'Copiar',
        'copied' => '¡Copiado!',
        'shortcode' => 'Shortcode',
        'url' => 'URL de inserción',
                'url_friendly' => 'URL de incrustación',
        'url_secure' => 'URL de incrustación',
        'friendly' => 'Amigable',
        'secure' => 'Seguro',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => 'Luego borre el caché en Administración de plataforma → Gestión de caché.',
        'botble_site_step_1' => 'Agregue esto al archivo .env de su sitio Botble de destino:',
        'botble_site_instructions' => 'Incrustar en otro sitio Botble',
        'iframe_code_hint' => 'Use el botón HTML en el Editor o el bloque HTML personalizado para incrustar.',
        'js_embed' => 'Incrustar vía JavaScript',
        'js_embed_hint' => 'Para más control y mejor capacidad de respuesta, use nuestro código JavaScript de incrustación:',
        'iframe_code' => 'Código de incrustación iframe',
    ],

    'export_import' => [
        'title' => 'Exportar / Importar',
        'description' => 'Exportar este formulario a JSON o importar desde otro sitio',
        'export' => 'Exportar a JSON',
        'export_description' => 'Descargar este formulario como archivo JSON para usar en otro sitio',
        'import' => 'Importar formulario',
        'import_description' => 'Importar un formulario desde un archivo JSON',
        'import_button' => 'Importar desde JSON',
        'select_file' => 'Seleccionar archivo JSON',
        'import_success' => '¡Formulario importado exitosamente!',
        'import_error' => 'Error al importar el formulario. Por favor verifique el formato del archivo.',
        'invalid_file' => 'Formato de archivo inválido. Por favor suba un archivo JSON válido.',
        'invalid_format' => 'Formato de datos del formulario inválido.',
        'exported_at' => 'Exportado el',
        'exported_from' => 'Exportado desde',
        'version' => 'Versión',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => 'Traducir formulario',
        'description' => 'Edita el contenido traducido de este formulario. La estructura de campos no se puede cambiar aquí; solo se pueden traducir etiquetas, marcadores de posición y textos.',
        'field_labels' => 'Etiquetas de campo',
        'field_name' => 'Nombre del campo',
        'original_label' => 'Original',
        'translated_label' => 'Traducción',
        'placeholder' => 'Marcador de posición',
        'option' => 'Opción',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'Propiedades del formulario',
        'no_popup_properties' => 'Este formulario no usa el modo emergente. No hay propiedades traducibles disponibles.',
        'submission_messages' => 'Mensajes de envío',
        'leave_empty_for_default' => 'Déjalo vacío para usar el mensaje predeterminado',
        'back_to_default' => 'Volver al idioma predeterminado',
        'form_preview' => 'Información del formulario',
        'total_fields' => 'Total de campos',
        'invalid_language' => 'Idioma especificado no válido.',
        'default_language' => 'Predeterminado',
    ],

    'wizard' => [
        'previous' => 'Anterior',
        'next' => 'Siguiente',
        'step_number' => 'Paso :current de :total',
        'progress_restored' => 'Tu progreso anterior ha sido restaurado.',
        'start_fresh' => 'Empezar de nuevo',
    ],

    'step_condition' => [
        'title' => 'Condición del paso',
        'description' => 'Mostrar este paso solo cuando se cumpla una condición específica. Si no se cumple la condición, se omitirá el paso.',
        'show_if' => 'Mostrar este paso si',
        'no_condition' => '-- Sin condición (mostrar siempre) --',
        'condition' => 'Condición',
        'value' => 'Valor',
        'value_placeholder' => 'Ingrese el valor a comparar',
        'is_checked' => 'Está marcado / seleccionado',
        'is_not_checked' => 'No está marcado / no seleccionado',
        'equals' => 'Igual al valor',
        'not_equals' => 'No igual al valor',
        'remove_condition' => 'Eliminar condición',
        'no_fields_available' => 'No se encontraron campos de casilla, radio o selección en pasos anteriores. Agregue campos a los pasos anteriores primero.',
        'first_step_error' => 'El primer paso no puede tener condiciones ya que no hay pasos anteriores.',
        'conditional_step' => 'Paso condicional',
        'add_condition' => 'Agregar condición',
    ],

    'file_upload' => [
        'choose_file' => 'Elegir archivo o arrastrar y soltar aquí',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => 'Examinar',
        'help' => 'Puede cargar los siguientes tipos de archivo: :types y el tamaño máximo de archivo es :sizeMB.',
        'remove' => 'Eliminar',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[Archivo oculto en modo demo]',
    ],
];
