<?php

return [
    'menu' => [
        'title' => 'BB Form Builder',
        'forms' => 'Forms',
        'submissions' => 'Submissions',
        'reports' => 'Reports',
        'settings' => 'Settings',
    ],

    'forms' => [
        'title' => 'Forms',
        'create' => 'Create Form',
        'edit' => 'Edit Form',
        'view' => 'View: :name',
        'name' => 'Form Name',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won\'t see this.',
        'code' => 'Code',
        'code_help' => 'Leave blank to auto-generate. Used in shortcode: [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => 'e.g., contact-form',
        'status' => 'Status',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => 'Submissions',
        'created_at' => 'Created At',
        'actions' => 'Actions',
        'settings' => 'Settings',
        'fields' => 'Fields',
        'short_code' => 'Shortcode',
    ],

    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],

    'submit' => 'Submit',

    'tabs' => [
        'builder' => 'Form Builder',
        'actions' => 'Actions',
        'submission' => 'Submission',
        'settings' => 'Form Settings',
    ],

    'builder' => [
        'title' => 'BB Form Builder',
        'components' => 'Form Components',
        'has_captcha' => 'Enable reCAPTCHA',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'Add Step',
        'form_title' => 'Form Title',
        'form_title_placeholder' => 'e.g., Contact Us',
        'form_title_help' => 'Optional title displayed above the form',
        'form_description' => 'Form Description',
        'form_description_placeholder' => 'e.g., Fill out the form below and we\'ll get back to you within 24 hours.',
        'form_description_help' => 'Optional description displayed below the title',
        'field_types' => 'Field Types',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'Wizard Layout',
        'wizard_layout_help' => 'Choose how multi-step forms display their progress indicators',
        'layout_horizontal' => 'Horizontal (steps on top)',
        'layout_vertical' => 'Vertical (steps on left side)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'Form Alignment',
        'form_alignment_start' => 'Left (Start)',
        'form_alignment_center' => 'Center',
        'form_alignment_end' => 'Right (End)',
        'form_spacing' => 'Spacing',
        'form_margin' => 'Margin',
        'form_margin_help' => 'Space outside the form (e.g., 20px, 1rem, 20px 0)',
        'form_padding' => 'Padding',
        'form_padding_help' => 'Space inside the form (e.g., 20px, 1rem, 30px 20px)',
        'form_style' => 'Form Style',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'step_title_hint' => 'Double-click on a step title to rename it.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => 'Exit Intent',
        'popup_trigger_exit_intent_help' => 'Only works on desktop devices with mouse. Triggers when user moves cursor to leave the page. Shows once per session.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],

    'submissions' => [
        'title' => 'Form Submissions',
        'view' => 'View Submission',
        'info' => 'Submission Info',
        'form' => 'Form',
        'identifier' => 'Identifier',
        'data' => 'Submission Data',
        'submitted_at' => 'Submitted At',
        'ip_address' => 'IP Address',
        'user_agent' => 'User Agent',
        'page_url' => 'Page URL',
        'referrer_url' => 'Referrer URL',
        'url_tracking_title' => 'Submission Source',
        'no_submissions' => 'No submissions found.',
        'back' => 'Back',
        'delete' => 'Delete',
    ],

    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],

    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],

    'submission_config' => [
        'title' => 'Submission Settings',
        'on_success' => 'On Success',
        'on_failure' => 'On Failure',
        'action' => 'Action',
        'content' => 'Content',
        'show_message' => 'Show Message',
        'redirect_to' => 'Redirect To',
        'message_placeholder' => 'Thank you for your submission!',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://example.com/thank-you',
    ],

    'actions' => [
        'title' => 'Form Actions',
        'add' => 'Add Action',
        'configure' => 'Configure Actions',
        'placeholder_hint' => 'Use [field_name] to insert field values',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => 'Click on an action from the left panel to add it to your form',
        'no_database_action_warning' => 'No "Save to Database" action configured',
        'no_database_action_warning_hint' => 'Form submissions will not be stored in the database and won\'t appear on the Submissions page.',

        'email' => [
            'name' => 'Email Notification',
            'description' => 'Send email notifications when form is submitted',
            'to' => 'To',
            'to_help' => 'Enter recipient email addresses, separated by commas',
            'subject' => 'Subject',
            'subject_help' => 'Use [field_name] to insert field values',
            'body' => 'Body',
            'body_help' => 'Use [field_name] to insert field values',
        ],

        'database' => [
            'name' => 'Save to Database',
            'description' => 'Store submissions in the database',
            'unique_field' => 'Unique Field',
            'unique_field_help' => 'Field name to prevent duplicate submissions (optional)',
        ],

        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'Endpoint URL',
            'method' => 'HTTP Method',
            'body' => 'Request Body (JSON)',
            'body_help' => 'Use [field_name] to insert field values in JSON',
        ],

        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],

        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],

        'loading_options' => 'Loading options...',
    ],

    'shortcode' => [
        'title' => 'Form',
        'description' => 'Display a form',
        'form' => 'Select Form',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],

    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],

    'settings' => [
        'title' => 'BB Form Builder Settings',
        'description' => 'Configure form builder settings',
        'allowed_mimes' => 'Allowed File Types',
        'allowed_mimes_help' => 'Comma-separated list of allowed file extensions',
        'max_file_size' => 'Max File Size (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => 'Appearance Settings',
            'description' => 'Customize the look and feel of your forms',
            'primary_color' => 'Primary Color',
            'primary_color_help' => 'Used for buttons, active states, and focus rings',
            'primary_hover_color' => 'Primary Hover Color',
            'success_color' => 'Success Color',
            'success_color_help' => 'Used for success messages and completed steps',
            'danger_color' => 'Danger Color',
            'danger_color_help' => 'Used for error messages and validation errors',
            'text_color' => 'Text Color',
            'border_color' => 'Border Color',
            'background_color' => 'Background Color',
            'border_radius' => 'Border Radius',
            'border_radius_options' => [
                'none' => 'None (0)',
                'small' => 'Small (4px)',
                'medium' => 'Medium (8px)',
                'large' => 'Large (12px)',
                'extra_large' => 'Extra Large (16px)',
                'pill' => 'Pill',
            ],
            'enable_shadow' => 'Enable Box Shadow',
            'enable_shadow_help' => 'Add subtle shadow effect to the form container',
            'button_radius' => 'Button Border Radius',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],

    'messages' => [
        'form_not_found' => 'Form not found.',
        'form_inactive' => 'This form is not active.',
        'submission_success' => 'Thank you for your submission!',
        'submission_failed' => 'An error occurred. Please try again.',
        'captcha_invalid' => 'Please complete the captcha.',
        'duplicate_submission' => 'You have already submitted this form.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],

    'enums' => [
        'statuses' => [
            'active' => 'Active',
            'inactive' => 'Inactive',
        ],
    ],

    'embed' => [
        'title' => 'Embed Code',
        'description' => 'Copy this code to embed the form on external websites',
        'copy' => 'Copy',
        'copied' => 'Copied!',
        'shortcode' => 'Shortcode',
        'url_friendly' => 'Embed URL',
        'url_secure' => 'Embed URL',
        'friendly' => 'Friendly',
        'secure' => 'Secure',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'iframe_code' => 'Iframe Embed Code',
        'iframe_code_hint' => 'Use the HTML button in Editor or Custom HTML UI block to embed this iframe.',
        'js_embed' => 'Embed via JavaScript',
        'js_embed_hint' => 'For more control and better responsiveness, use our JavaScript embed code:',
        'botble_site_instructions' => 'Embedding on another Botble site',
        'botble_site_step_1' => 'Add this to the .env file of your target Botble site:',
        'botble_site_step_2' => 'Then clear cache config in Platform Administration → Cache management.',
    ],

    'export_import' => [
        'title' => 'Export / Import',
        'description' => 'Export this form to JSON or import from another site',
        'export' => 'Export to JSON',
        'export_description' => 'Download this form as a JSON file to use on another site',
        'import' => 'Import Form',
        'import_description' => 'Import a form from a JSON file',
        'import_button' => 'Import from JSON',
        'select_file' => 'Select JSON file',
        'import_success' => 'Form imported successfully!',
        'import_error' => 'Failed to import form. Please check the file format.',
        'invalid_file' => 'Invalid file format. Please upload a valid JSON file.',
        'invalid_format' => 'Invalid form data format.',
        'exported_at' => 'Exported at',
        'exported_from' => 'Exported from',
        'version' => 'Version',
    ],

    'popup' => [
        'close' => 'Close',
    ],

    'translation' => [
        'title' => 'Translate Form',
        'description' => 'Edit translated content for this form. Field structure cannot be changed here - only labels, placeholders, and text can be translated.',
        'field_labels' => 'Field Labels',
        'field_name' => 'Field Name',
        'original_label' => 'Original',
        'translated_label' => 'Translation',
        'placeholder' => 'Placeholder',
        'option' => 'Option',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'Form Properties',
        'no_popup_properties' => 'This form is not using popup mode. No translatable properties available.',
        'submission_messages' => 'Submission Messages',
        'leave_empty_for_default' => 'Leave empty to use default message',
        'back_to_default' => 'Back to Default Language',
        'form_preview' => 'Form Info',
        'total_fields' => 'Total Fields',
        'invalid_language' => 'Invalid language specified.',
        'default_language' => 'Default',
    ],

    'wizard' => [
        'previous' => 'Previous',
        'next' => 'Next',
        'step_number' => 'Step :current of :total',
        'progress_restored' => 'Your previous progress has been restored.',
        'start_fresh' => 'Start Fresh',
    ],

    'step_condition' => [
        'title' => 'Step Condition',
        'description' => 'Show this step only when a specific condition is met. If the condition is not met, the step will be skipped.',
        'show_if' => 'Show this step if',
        'no_condition' => '-- No condition (always show) --',
        'condition' => 'Condition',
        'value' => 'Value',
        'value_placeholder' => 'Enter value to match',
        'is_checked' => 'Is checked / selected',
        'is_not_checked' => 'Is not checked / not selected',
        'equals' => 'Equals value',
        'not_equals' => 'Does not equal value',
        'remove_condition' => 'Remove Condition',
        'no_fields_available' => 'No checkbox, radio, or select fields found in previous steps. Add fields to earlier steps first.',
        'first_step_error' => 'The first step cannot have conditions since there are no previous steps.',
        'conditional_step' => 'Conditional step',
        'add_condition' => 'Add condition',
    ],

    'file_upload' => [
        'choose_file' => 'Choose file or drag & drop here',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => 'Browse',
        'help' => 'You can upload the following file types: :types and max file size is :sizeMB.',
        'remove' => 'Remove',
    ],

    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],

    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],

    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',

        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[File hidden in demo mode]',
    ],
];
