<?php

return [
    'menu' => [
        'title' => 'Formular-Builder',
        'forms' => 'Formulare',
        'submissions' => 'Einreichungen',
        'reports' => 'Reports',
        'settings' => 'Einstellungen',
    ],
    'forms' => [
        'title' => 'Formulare',
        'create' => 'Formular erstellen',
        'edit' => 'Formular bearbeiten',
        'view' => 'View: :name',
        'name' => 'Formularname',
        'name_placeholder' => 'e.g., Summer Event Registration',
        'name_help' => 'A clear internal name; visitors won’t see this.',
        'code' => 'Code',
        'code_help' => 'Leer lassen für automatische Generierung. Wird im Shortcode verwendet: [bb-form-builder code="..."][/bb-form-builder]',
        'code_placeholder' => 'z.B., kontakt-formular',
        'status' => 'Status',
        'status_help' => 'Controls whether the form is visible and can accept submissions.',
        'submissions_count' => 'Einreichungen',
        'created_at' => 'Erstellt am',
        'actions' => 'Aktionen',
        'settings' => 'Einstellungen',
        'fields' => 'Felder',
        'short_code' => 'Shortcode',
    ],
    'view' => [
        'form_info' => 'Form Information',
        'fields_count' => 'Fields',
        'total_submissions' => 'Total Submissions',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions (Last 30 Days)',
        'recent_submissions' => 'Submissions',
        'submissions' => 'Submissions',
    ],
    'submit' => 'Absenden',
    'tabs' => [
        'builder' => 'Builder',
        'actions' => 'Aktionen',
        'submission' => 'Einreichung',
        'settings' => 'Form Settings',
    ],
    'builder' => [
        'title' => 'Formular-Builder',
        'components' => 'Form Components',
        'has_captcha' => 'reCAPTCHA aktivieren',
        'has_math_captcha' => 'Enable Math CAPTCHA',
        'add_step' => 'Schritt hinzufügen',
        'form_title' => 'Formulartitel',
        'form_title_placeholder' => 'z.B., Kontaktieren Sie uns',
        'form_title_help' => 'Optionaler Titel, der über dem Formular angezeigt wird',
        'form_description' => 'Formularbeschreibung',
        'form_description_placeholder' => 'z.B., Füllen Sie das Formular aus und wir melden uns innerhalb von 24 Stunden bei Ihnen.',
        'form_description_help' => 'Optionale Beschreibung, die unter dem Titel angezeigt wird',
        'field_types' => 'Feldtypen',
        'field_settings' => 'Field Settings',
        'wizard_layout' => 'Assistenten-Layout',
        'wizard_layout_help' => 'Wählen Sie, wie mehrstufige Formulare ihre Fortschrittsindikatoren anzeigen',
        'layout_horizontal' => 'Horizontal (Schritte oben)',
        'layout_vertical' => 'Vertikal (Schritte links)',
        'form_size' => 'Form Size',
        'form_size_large' => 'Large (100%)',
        'form_size_medium' => 'Medium (720px)',
        'form_size_small' => 'Small (480px)',
        'form_size_full' => 'Full Size (100%)',
        'form_size_xxl' => 'XXL (1400px)',
        'form_size_xl' => 'XL (1200px)',
        'form_size_lg' => 'Large (992px)',
        'form_size_md' => 'Medium (768px)',
        'form_size_sm' => 'Small (576px)',
        'form_alignment' => 'Formularausrichtung',
        'form_alignment_start' => 'Links (Anfang)',
        'form_alignment_center' => 'Mitte',
        'form_alignment_end' => 'Rechts (Ende)',
        'form_spacing' => 'Abstände',
        'form_margin' => 'Außenabstand',
        'form_margin_help' => 'Abstand außerhalb des Formulars (z.B., 20px, 1rem, 20px 0)',
        'form_padding' => 'Innenabstand',
        'form_padding_help' => 'Abstand innerhalb des Formulars (z.B., 20px, 1rem, 30px 20px)',
        'form_style' => 'Formularstil',
        'form_style_default' => 'Default',
        'form_style_modern' => 'Modern',
        'form_style_minimal' => 'Minimal',
        'form_style_bold' => 'Bold',
        'form_style_glass' => 'Glassmorphism',
        'allow_embed' => 'Allow Embed',
        'allow_embed_help' => 'Allow this form to be embedded on external websites via iframe',
        'untitled_form' => 'Untitled Form',
        'drag_hint' => 'Drag & Drop the components from the left panel to include them in the form. You can also delete any component from the form if it\'s not relevant.',
        'preview' => 'Preview',
        'undo' => 'Undo',
        'redo' => 'Redo',
        'popup_settings' => 'Popup Display Settings',
        'display_mode' => 'Display Mode',
        'display_mode_inline' => 'Inline (embedded in page)',
        'display_mode_popup' => 'Popup (modal window)',
        'display_mode_help' => 'Choose how the form should be displayed on your website',
        'popup_trigger' => 'Popup Trigger',
        'popup_trigger_button' => 'Button Click',
        'popup_trigger_time_delay' => 'Time Delay',
        'popup_trigger_scroll' => 'Scroll Percentage',
        'popup_trigger_exit_intent' => 'Exit Intent',
        'popup_trigger_exit_intent_help' => 'Funktioniert nur auf Desktop-Geräten mit Maus. Wird ausgelöst, wenn der Benutzer den Cursor von der Seite wegbewegt. Wird einmal pro Sitzung angezeigt.',
        'popup_button_text' => 'Button Text',
        'popup_button_text_default' => 'Open Form',
        'popup_delay' => 'Delay (seconds)',
        'popup_delay_help' => 'Time in seconds before the popup appears',
        'popup_scroll_percentage' => 'Scroll Percentage',
        'popup_scroll_percentage_help' => 'Popup appears when user scrolls this percentage of the page',
        'popup_title' => 'Popup Title',
        'popup_title_placeholder' => 'e.g., Contact Us',
        'popup_title_help' => 'Optional title displayed at the top of the popup',
        'popup_max_width' => 'Popup Size',
        'popup_max_width_sm' => 'Small (400px)',
        'popup_max_width_md' => 'Medium (600px)',
        'popup_max_width_lg' => 'Large (800px)',
        'popup_max_width_xl' => 'Extra Large (1000px)',
        'popup_close_on_overlay' => 'Close when clicking outside',
        'popup_show_close_button' => 'Show close button',
        'other_settings' => 'Other Settings',
    ],
    'submissions' => [
        'title' => 'Formulareinreichungen',
        'view' => 'Einreichung anzeigen',
        'info' => 'Einreichungsinformationen',
        'form' => 'Formular',
        'identifier' => 'Identifier',
        'data' => 'Einreichungsdaten',
        'submitted_at' => 'Eingereicht am',
        'ip_address' => 'IP-Adresse',
        'user_agent' => 'Benutzeragent',
        'page_url' => 'Seiten-URL',
        'referrer_url' => 'Referrer-URL',
        'url_tracking_title' => 'Einreichungsquelle',
        'no_submissions' => 'Keine Einreichungen gefunden.',
        'back' => 'Zurück',
        'delete' => 'Löschen',
    ],
    'export' => [
        'heading' => 'Export Form Submissions',
        'description' => 'Download submissions for selected forms',
        'form' => 'Form',
        'all_forms' => 'All forms',
        'limit' => 'Limit',
        'limit_placeholder' => 'Optional max rows',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'start_date_placeholder' => 'From date',
        'end_date_placeholder' => 'To date',
        'total' => 'Total submissions',
        'content_only' => 'Content only (flatten fields)',
        'content_only_help' => 'Flatten submission answers into columns (best for CSV/email tools).',
    ],
    'reports' => [
        'title' => 'Reports',
        'overview' => 'Overview',
        'total_forms' => 'Total Forms',
        'total_submissions' => 'Total Submissions',
        'active_forms' => 'Active Forms',
        'today' => 'Today',
        'this_week' => 'This Week',
        'this_month' => 'This Month',
        'submissions_chart' => 'Submissions Over Time (Last 30 Days)',
        'top_forms' => 'Top Performing Forms',
        'form_stats' => 'Form Statistics',
        'recent_submissions' => 'Recent Submissions',
        'form_name' => 'Form Name',
        'status' => 'Status',
        'total' => 'Total',
        'view_form' => 'View Form',
        'no_data' => 'No data available',
        'submissions' => 'Submissions',
    ],
    'submission_config' => [
        'title' => 'Einreichungseinstellungen',
        'on_success' => 'Bei Erfolg',
        'on_failure' => 'Bei Fehler',
        'action' => 'Aktion',
        'content' => 'Inhalt',
        'show_message' => 'Nachricht anzeigen',
        'redirect_to' => 'Weiterleiten zu',
        'message_placeholder' => 'Vielen Dank für Ihre Einreichung!',
        'failure_placeholder' => 'An error occurred. Please try again.',
        'url_placeholder' => 'https://beispiel.de/danke',
    ],
    'actions' => [
        'title' => 'Formularaktionen',
        'add' => 'Aktion hinzufügen',
        'configure' => 'Aktionen konfigurieren',
        'placeholder_hint' => 'Verwenden Sie [field_name], um Feldwerte einzufügen',
        'available_placeholders' => 'Available Placeholders',
        'placeholder_example' => 'Example: [email], [name], [phone]',
        'available_actions' => 'Available Actions',
        'configured_actions' => 'Configured Actions',
        'category_notifications' => 'Notifications',
        'category_storage' => 'Data Storage',
        'category_integrations' => 'Integrations',
        'no_actions' => 'No actions configured',
        'no_actions_hint' => 'Klicken Sie auf eine Aktion im linken Bereich, um sie zu Ihrem Formular hinzuzufügen',
        'no_database_action_warning' => 'Keine "In Datenbank speichern"-Aktion konfiguriert',
        'no_database_action_warning_hint' => 'Formulareinreichungen werden nicht in der Datenbank gespeichert und erscheinen nicht auf der Einreichungsseite.',

        'email' => [
            'name' => 'E-Mail-Benachrichtigung',
            'description' => 'Send email notifications when form is submitted',
            'to' => 'An',
            'to_help' => 'Geben Sie die E-Mail-Adressen der Empfänger ein, getrennt durch Kommas',
            'subject' => 'Betreff',
            'subject_help' => 'Verwenden Sie [field_name], um Feldwerte einzufügen',
            'body' => 'Inhalt',
            'body_help' => 'Verwenden Sie [field_name], um Feldwerte einzufügen',
        ],
        'database' => [
            'name' => 'In Datenbank speichern',
            'description' => 'Store submissions in the database',
            'unique_field' => 'Eindeutiges Feld',
            'unique_field_help' => 'Feldname, um doppelte Einreichungen zu verhindern (optional)',
        ],
        'api' => [
            'name' => 'API Webhook',
            'description' => 'Send data to external API endpoint',
            'end_point' => 'Endpunkt-URL',
            'method' => 'HTTP-Methode',
            'body' => 'Anfrage-Body (JSON)',
            'body_help' => 'Verwenden Sie [field_name], um Feldwerte in JSON einzufügen',
        ],
        'mailchimp' => [
            'name' => 'Mailchimp',
            'description' => 'Subscribe users to Mailchimp list',
            'list' => 'Audience List',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name (not the Mailchimp merge tag). Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name (not the Mailchimp merge tag). Example: if your name input has name="full_name", enter "full_name". The name will be automatically split into FNAME/LNAME',
            'api_key_not_configured' => 'Mailchimp API key not configured',
            'no_lists' => 'No lists found. Please check your API key.',
        ],
        'getresponse' => [
            'name' => 'GetResponse',
            'description' => 'Add contacts to GetResponse campaign',
            'campaign' => 'Campaign',
            'email_field' => 'Email Field Name',
            'email_field_help' => 'Enter the form field name. Example: if your email input has name="email", enter "email"',
            'name_field' => 'Name Field Name',
            'name_field_help' => 'Optional: Enter the form field name. Example: if your name input has name="full_name", enter "full_name"',
            'api_key_not_configured' => 'GetResponse API key not configured',
            'no_campaigns' => 'No campaigns found. Please check your API key.',
        ],
        'loading_options' => 'Loading options...',
    ],
    'shortcode' => [
        'title' => 'Formular',
        'description' => 'Ein Formular anzeigen',
        'form' => 'Formular auswählen',
        'style' => 'Form Style',
        'use_form_default' => 'Use form default',
    ],
    'styles' => [
        'default' => 'Default',
        'modern' => 'Modern',
        'minimal' => 'Minimal',
        'bold' => 'Bold',
        'glass' => 'Glassmorphism',
    ],
    'settings' => [
        'title' => 'Formular-Builder-Einstellungen',
        'description' => 'Formular-Builder-Einstellungen konfigurieren',
        'allowed_mimes' => 'Erlaubte Dateitypen',
        'allowed_mimes_help' => 'Kommagetrennte Liste erlaubter Dateierweiterungen',
        'max_file_size' => 'Maximale Dateigröße (MB)',
        'success_message_timeout' => 'Success Message Timeout (seconds)',
        'success_message_timeout_help' => 'How long to keep the success message visible. Set to 0 to keep it on screen.',
        'appearance' => [
            'title' => 'Erscheinungseinstellungen',
            'description' => 'Passen Sie das Aussehen Ihrer Formulare an',
            'primary_color' => 'Primärfarbe',
            'primary_color_help' => 'Wird für Schaltflächen, aktive Zustände und Fokusringe verwendet',
            'primary_hover_color' => 'Primärfarbe beim Hovern',
            'success_color' => 'Erfolgsfarbe',
            'success_color_help' => 'Wird für Erfolgsmeldungen und abgeschlossene Schritte verwendet',
            'danger_color' => 'Gefahrenfarbe',
            'danger_color_help' => 'Wird für Fehlermeldungen und Validierungsfehler verwendet',
            'text_color' => 'Textfarbe',
            'border_color' => 'Rahmenfarbe',
            'background_color' => 'Hintergrundfarbe',
            'border_radius' => 'Rahmenradius',
            'border_radius_options' => [
                'none' => 'Keine (0)',
                'small' => 'Klein (4px)',
                'medium' => 'Mittel (8px)',
                'large' => 'Groß (12px)',
                'extra_large' => 'Extra groß (16px)',
                'pill' => 'Pille',
            ],
            'enable_shadow' => 'Box-Schatten aktivieren',
            'enable_shadow_help' => 'Fügen Sie dem Formularcontainer einen subtilen Schatteneffekt hinzu',
            'button_radius' => 'Schaltflächen-Rahmenradius',
        ],
        'integrations' => [
            'title' => 'Integrations',
            'description' => 'Configure API keys for email marketing integrations',
            'mailchimp_api_key' => 'Mailchimp API Key',
            'mailchimp_api_key_help' => 'Get your API key from Mailchimp Account → Extras → API keys',
            'mailchimp_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx-us1',
            'getresponse_api_key' => 'GetResponse API Key',
            'getresponse_api_key_help' => 'Get your API key from GetResponse → Menu → Integrations & API → API',
            'getresponse_api_key_placeholder' => 'Ex: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',
        ],
    ],
    'messages' => [
        'form_not_found' => 'Formular nicht gefunden.',
        'form_inactive' => 'Dieses Formular ist nicht aktiv.',
        'submission_success' => 'Vielen Dank für Ihre Einreichung!',
        'submission_failed' => 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es erneut.',
        'captcha_invalid' => 'Bitte vervollständigen Sie das Captcha.',
        'duplicate_submission' => 'Sie haben dieses Formular bereits eingereicht.',
        'embed_disabled' => 'Embedding is not allowed for this form.',
    ],
    'enums' => [
        'statuses' => [
            'active' => 'Aktiv',
            'inactive' => 'Inaktiv',
        ],
    ],
    'embed' => [
        'title' => 'Einbettungscode',
        'description' => 'Kopieren Sie diesen Code, um das Formular auf externen Websites einzubetten',
        'copy' => 'Kopieren',
        'copied' => 'Kopiert!',
        'shortcode' => 'Shortcode',
        'url' => 'Einbettungs-URL',
                'url_friendly' => 'Einbettungs-URL',
        'url_secure' => 'Einbettungs-URL',
        'friendly' => 'Freundlich',
        'secure' => 'Sicher',
        'disabled_hint' => 'Enable "Allow Embed" above to use this URL',
        'botble_site_step_2' => 'Dann leeren Sie den Cache-Konfig unter Plattformverwaltung → Cache-Verwaltung.',
        'botble_site_step_1' => 'Fügen Sie dies zur .env-Datei Ihrer Ziel-Botble-Website hinzu:',
        'botble_site_instructions' => 'Einbetten auf einer anderen Botble-Website',
        'iframe_code_hint' => 'Verwenden Sie die HTML-Schaltfläche im Editor oder den benutzerdefinierten HTML-UI-Block zum Einbetten.',
        'js_embed' => 'Einbetten über JavaScript',
        'js_embed_hint' => 'Für mehr Kontrolle und bessere Reaktionsfähigkeit verwenden Sie unseren JavaScript-Einbettungscode:',
        'iframe_code' => 'Iframe-Einbettungscode',
    ],

    'export_import' => [
        'title' => 'Export / Import',
        'description' => 'Dieses Formular als JSON exportieren oder von einer anderen Website importieren',
        'export' => 'Als JSON exportieren',
        'export_description' => 'Dieses Formular als JSON-Datei herunterladen, um es auf einer anderen Website zu verwenden',
        'import' => 'Formular importieren',
        'import_description' => 'Ein Formular aus einer JSON-Datei importieren',
        'import_button' => 'Aus JSON importieren',
        'select_file' => 'JSON-Datei auswählen',
        'import_success' => 'Formular erfolgreich importiert!',
        'import_error' => 'Formular konnte nicht importiert werden. Bitte überprüfen Sie das Dateiformat.',
        'invalid_file' => 'Ungültiges Dateiformat. Bitte laden Sie eine gültige JSON-Datei hoch.',
        'invalid_format' => 'Ungültiges Formulardatenformat.',
        'exported_at' => 'Exportiert am',
        'exported_from' => 'Exportiert von',
        'version' => 'Version',
    ],
    'popup' => [
        'close' => 'Close',
    ],
    'translation' => [
        'title' => 'Formular übersetzen',
        'description' => 'Bearbeite die übersetzten Inhalte dieses Formulars. Die Feldstruktur kann hier nicht geändert werden – nur Beschriftungen, Platzhalter und Texte können übersetzt werden.',
        'field_labels' => 'Feldbeschriftungen',
        'field_name' => 'Feldname',
        'original_label' => 'Original',
        'translated_label' => 'Übersetzung',
        'placeholder' => 'Platzhalter',
        'option' => 'Option',
        'step_titles' => 'Step Titles',
        'step_id' => 'Step ID',
        'properties' => 'Formulareigenschaften',
        'no_popup_properties' => 'Dieses Formular verwendet keinen Popup-Modus. Keine übersetzbaren Eigenschaften verfügbar.',
        'submission_messages' => 'Meldungen zur Einsendung',
        'leave_empty_for_default' => 'Leer lassen, um die Standardnachricht zu verwenden',
        'back_to_default' => 'Zur Standardsprache zurück',
        'form_preview' => 'Formularinfo',
        'total_fields' => 'Gesamtfelder',
        'invalid_language' => 'Ungültige Sprache angegeben.',
        'default_language' => 'Standard',
    ],

    'wizard' => [
        'previous' => 'Zurück',
        'next' => 'Weiter',
        'step_number' => 'Schritt :current von :total',
        'progress_restored' => 'Ihr vorheriger Fortschritt wurde wiederhergestellt.',
        'start_fresh' => 'Neu beginnen',
    ],

    'step_condition' => [
        'title' => 'Schrittbedingung',
        'description' => 'Diesen Schritt nur anzeigen, wenn eine bestimmte Bedingung erfüllt ist. Wenn die Bedingung nicht erfüllt ist, wird der Schritt übersprungen.',
        'show_if' => 'Diesen Schritt anzeigen, wenn',
        'no_condition' => '-- Keine Bedingung (immer anzeigen) --',
        'condition' => 'Bedingung',
        'value' => 'Wert',
        'value_placeholder' => 'Wert zur Übereinstimmung eingeben',
        'is_checked' => 'Ist aktiviert / ausgewählt',
        'is_not_checked' => 'Ist nicht aktiviert / nicht ausgewählt',
        'equals' => 'Entspricht dem Wert',
        'not_equals' => 'Entspricht nicht dem Wert',
        'remove_condition' => 'Bedingung entfernen',
        'no_fields_available' => 'Keine Checkbox-, Radio- oder Auswahlfelder in vorherigen Schritten gefunden. Fügen Sie zuerst Felder zu früheren Schritten hinzu.',
        'first_step_error' => 'Der erste Schritt kann keine Bedingungen haben, da es keine vorherigen Schritte gibt.',
        'conditional_step' => 'Bedingter Schritt',
        'add_condition' => 'Bedingung hinzufügen',
    ],

    'file_upload' => [
        'choose_file' => 'Datei auswählen oder hierher ziehen',
        'choose_image' => 'Choose image or drag & drop here',
        'browse' => 'Durchsuchen',
        'help' => 'Sie können die folgenden Dateitypen hochladen: :types und die maximale Dateigröße beträgt :sizeMB.',
        'remove' => 'Entfernen',
    ],
    'validation' => [
        'required' => 'This field is required.',
        'email' => 'Please enter a valid email address.',
        'phone' => 'Please enter a valid phone number.',
        'dangerous_extension' => 'File type ":extension" is not allowed for security reasons.',
        'invalid_filename' => 'The file name contains invalid characters.',
        'invalid_image_type' => 'The file is not a valid image type.',
        'invalid_image' => 'The file is not a valid image.',
        'mime_mismatch' => 'The file type does not match its extension.',
        'malicious_content' => 'The file contains potentially malicious content.',
        'invalid_file' => 'The uploaded file is not valid.',
    ],
    'js' => [
        'something_went_wrong' => 'Something went wrong. Please try again.',
        'deactivate_license_confirm' => 'Are you sure you want to deactivate your license?',
        'show_purchase_code' => 'Show purchase code',
        'hide_purchase_code' => 'Hide purchase code',
    ],
    'license' => [
        'title' => 'License Activation',
        'description' => 'Your license is invalid. Please activate your license to use the BB Form Builder plugin!',
        'activated_title' => 'License Activated Successfully',
        'purchase_code_label' => 'Purchase code',
        'purchase_code_placeholder' => 'Ex: 10101000-0101-0100-0010-001101000010',
        'purchase_code_helper' => 'What\'s this?',
        'agreement_text' => 'Confirm that, according to the Envato License Terms, each license entitles one person for a single project. Creating multiple unregistered installations is a copyright violation.',
        'more_info' => 'More info',
        'activate' => 'Activate license',
        'activating' => 'Activating...',
        'deactivate' => 'Deactivate license',
        'deactivating' => 'Deactivating...',
        'licensed_to' => 'Licensed to',
        'activated_at' => 'Activated at',
        'need_reset' => 'Need reset your license? Please log in to our customer license manager site to reset your license.',
        'reset_link' => 'customer license manager site',
        'activated_successfully' => 'Your license has been activated successfully.',
        'deactivated_successfully' => 'Deactivated license successfully!',
        'activation_error' => 'Something went wrong. Please try again later.',
        'deactivation_error' => 'Something went wrong. Please try again later.',
        'deactivate_confirm' => 'Are you sure you want to deactivate your license?',
        'invalid_purchase_code' => 'Invalid purchase code. Please check your purchase code and try again.',
        'help_title' => 'Need Help?',
        'what_is_purchase_code' => 'What is a Purchase Code?',
        'purchase_code_description' => 'A purchase code is a unique identifier for your CodeCanyon purchase. It proves that you have legally purchased the item.',
        'where_to_find' => 'Where to find your Purchase Code?',
        'find_purchase_code_description' => 'You can find your purchase code in your CodeCanyon downloads page or in the email receipt you received after purchase.',
        'learn_more' => 'Learn More',
        'license_terms' => 'License Terms',
        'license_terms_description' => 'By activating this license, you agree to the Envato License Terms. Each license is valid for one domain only.',
        'view_license_terms' => 'View License Terms',
        'activation_required' => 'License Activation Required',
        'license_active_description' => 'Your BB Form Builder license is active and valid. You can receive updates and support.',
        'license_valid' => 'License Valid',
        'updates_enabled' => 'Updates Enabled',
        'receive_updates' => 'Receive automatic updates',
        'support_enabled' => 'Support Enabled',
        'get_support' => 'Get premium support',
        'manage_license' => 'Manage License',
        'manage_license_description' => 'You can deactivate your license if you want to use it on another domain.',
        'important_note' => 'Important Note',
        'deactivation_note' => 'Deactivating your license will disable updates and support for this installation. You can reactivate it later.',
        'secure_activation' => 'Secure & Encrypted',
        'secure_description' => 'Your purchase code is encrypted and stored securely',
        'updates_description' => 'Get automatic updates and new features',
        'support_description' => 'Access to premium support and documentation',
        'need_help' => 'Need Help?',
        'need_help_description' => 'If you have any issues with license activation, please contact our support team.',
        'reset_license' => 'Reset License',
        'access_denied' => 'Access Denied',
        'activation_required_message' => 'You need to activate your BB Form Builder license to access this feature. Please activate your license to continue.',
        'toggle_visibility' => 'Toggle purchase code visibility',
        'one_domain_note' => 'Each license is valid for one domain only',
        'valid_purchase_note' => 'You must have a valid purchase from CodeCanyon',
        'internet_required_note' => 'Internet connection is required for activation',
    ],

    'demo' => [
        'file_hidden' => '[Datei im Demo-Modus ausgeblendet]',
    ],
];
