'use strict'

class FormBuilderImport {
    static jsonDecode(str, fallback = null) {
        if (typeof str === 'string') {
            try {
                return JSON.parse(str)
            } catch (e) {
                return fallback
            }
        }
        return null
    }
}

;(function ($) {
    const $body = $('body')

    // Handle import button click
    $body.on('click', '.btn-import-form', function (e) {
        e.preventDefault()
        e.stopPropagation()
        $(document).find('form.import-form-group').find('input[type=file]').val('').trigger('click')
    })

    // Handle file selection
    $body.on('change', 'form.import-form-group input[type=file]', function (e) {
        const $form = $(e.currentTarget).closest('form')
        const file = e.currentTarget.files[0]

        if (file) {
            const reader = new FileReader()
            reader.readAsText(file)
            reader.onload = function (event) {
                const jsonData = FormBuilderImport.jsonDecode(event.target.result)

                if (!jsonData) {
                    Botble.showError('Invalid JSON file')
                    return
                }

                Botble.blockUI()

                $httpClient
                    .make()
                    .post($form.attr('action'), { json_data: jsonData })
                    .then(function (response) {
                        const data = response.data
                        if (data.error) {
                            Botble.showError(data.message)
                        } else {
                            Botble.showSuccess(data.message)
                            if (data.data && data.data.next_url) {
                                window.location.href = data.data.next_url
                            } else {
                                // Refresh table
                                const tableId = $form.find('table').prop('id')
                                if (window.LaravelDataTables && window.LaravelDataTables[tableId]) {
                                    window.LaravelDataTables[tableId].draw()
                                } else {
                                    window.location.reload()
                                }
                            }
                        }
                    })
                    .finally(function () {
                        Botble.unblockUI()
                    })
            }
        }
    })
})(jQuery)
