<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    public function up(): void
    {
        Schema::table('fb_form_builder_submissions', function (Blueprint $table): void {
            $table->text('page_url')->nullable()->after('user_agent');
            $table->text('referrer_url')->nullable()->after('page_url');
        });
    }

    public function down(): void
    {
        Schema::table('fb_form_builder_submissions', function (Blueprint $table): void {
            $table->dropColumn(['page_url', 'referrer_url']);
        });
    }
};
