<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('fb_forms_translations')) {
            return;
        }

        Schema::create('fb_forms_translations', function (Blueprint $table): void {
            $table->string('lang_code', 20);
            $table->foreignId('fb_forms_id');

            $table->string('name')->nullable();
            $table->longText('content')->nullable();
            $table->longText('properties')->nullable();
            $table->longText('submission')->nullable();

            $table->primary(['lang_code', 'fb_forms_id'], 'fb_forms_translations_primary');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fb_forms_translations');
    }
};
