<?php

use Botble\Base\Enums\BaseStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    public function up(): void
    {
        Schema::create('fb_forms', function (Blueprint $table): void {
            $table->id();
            $table->string('name', 255);
            $table->string('code', 120)->unique();
            $table->longText('content')->nullable();
            $table->text('properties')->nullable();
            $table->longText('actions')->nullable();
            $table->text('submission')->nullable();
            $table->string('status', 60)->index()->default(BaseStatusEnum::PUBLISHED);
            $table->timestamps();
        });

        Schema::create('fb_form_builder_submissions', function (Blueprint $table): void {
            $table->id();
            $table->unsignedBigInteger('form_id')->index();
            $table->json('content');
            $table->string('unique_identifier', 255)->nullable()->index();
            $table->ipAddress();
            $table->text('user_agent')->nullable();
            $table->timestamps();

            $table->foreign('form_id')->references('id')->on('fb_forms')->cascadeOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fb_form_builder_submissions');
        Schema::dropIfExists('fb_forms');
    }
};
