<?php

return [
    'mimes' => 'jpg,jpeg,png,gif,txt,csv,pdf,doc,docx,xls,xlsx',

    'image_mimes' => 'jpg,jpeg,png,gif,webp',

    'max_file_size' => 10,

    'success_message_timeout' => 5,

    'dangerous_extensions' => [

        'php', 'php3', 'php4', 'php5', 'php7', 'php8', 'phtml', 'phar',
        'exe', 'com', 'bat', 'cmd', 'msi', 'scr', 'pif',

        'sh', 'bash', 'zsh', 'csh', 'ksh', 'pl', 'py', 'rb', 'ps1', 'psm1',
        'vbs', 'vbe', 'js', 'jse', 'ws', 'wsf', 'wsc', 'wsh',

        'asp', 'aspx', 'cer', 'csr', 'jsp', 'jspx', 'cfm', 'cfc',
        'htaccess', 'htpasswd',

        'svg', 'svgz', 'swf', 'jar', 'war', 'ear',
        'dll', 'so', 'dylib', 'bin', 'elf',
        'cgi', 'shtml', 'xhtml',

        'hta', 'mht', 'mhtml',
    ],

    'mime_type_mapping' => [
        'jpg' => ['image/jpeg'],
        'jpeg' => ['image/jpeg'],
        'png' => ['image/png'],
        'gif' => ['image/gif'],
        'webp' => ['image/webp'],
        'pdf' => ['application/pdf'],
        'doc' => ['application/msword'],
        'docx' => ['application/vnd.openxmlformats-officedocument.wordprocessingml.document'],
        'xls' => ['application/vnd.ms-excel'],
        'xlsx' => ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'],
        'txt' => ['text/plain'],
        'csv' => ['text/csv', 'text/plain', 'application/csv'],
    ],

    'actions' => [
        'email' => [
            'name' => 'plugins/bb-form-builder::form.actions.email.name',
            'icon' => 'ti ti-mail',
            'multiple' => true,
            'fields' => [
                'to' => [
                    'type' => 'text',
                    'label' => 'plugins/bb-form-builder::form.actions.email.to',
                    'required' => true,
                    'help' => 'plugins/bb-form-builder::form.actions.email.to_help',
                ],
                'subject' => [
                    'type' => 'text',
                    'label' => 'plugins/bb-form-builder::form.actions.email.subject',
                    'required' => true,
                    'help' => 'plugins/bb-form-builder::form.actions.email.subject_help',
                ],
                'body' => [
                    'type' => 'textarea',
                    'label' => 'plugins/bb-form-builder::form.actions.email.body',
                    'required' => true,
                    'help' => 'plugins/bb-form-builder::form.actions.email.body_help',
                    'rows' => 6,
                ],
            ],
        ],
        'database' => [
            'name' => 'plugins/bb-form-builder::form.actions.database.name',
            'icon' => 'ti ti-database',
            'multiple' => false,
            'fields' => [
                'unique_field' => [
                    'type' => 'text',
                    'label' => 'plugins/bb-form-builder::form.actions.database.unique_field',
                    'required' => false,
                    'help' => 'plugins/bb-form-builder::form.actions.database.unique_field_help',
                ],
            ],
        ],
        'api' => [
            'name' => 'plugins/bb-form-builder::form.actions.api.name',
            'icon' => 'ti ti-webhook',
            'multiple' => true,
            'fields' => [
                'end_point' => [
                    'type' => 'text',
                    'label' => 'plugins/bb-form-builder::form.actions.api.end_point',
                    'required' => true,
                ],
                'method' => [
                    'type' => 'select',
                    'label' => 'plugins/bb-form-builder::form.actions.api.method',
                    'options' => [
                        'POST' => 'POST',
                        'GET' => 'GET',
                    ],
                    'required' => true,
                ],
                'body' => [
                    'type' => 'textarea',
                    'label' => 'plugins/bb-form-builder::form.actions.api.body',
                    'required' => false,
                    'help' => 'plugins/bb-form-builder::form.actions.api.body_help',
                    'rows' => 4,
                ],
            ],
        ],
        'mailchimp' => [
            'name' => 'plugins/bb-form-builder::form.actions.mailchimp.name',
            'icon' => 'ti ti-mail-star',
            'multiple' => true,
            'fields' => [
                'list_id' => [
                    'type' => 'select',
                    'label' => 'plugins/bb-form-builder::form.actions.mailchimp.list',
                    'required' => true,
                    'options_url' => 'mailchimp/lists',
                ],
                'email_field' => [
                    'type' => 'text',
                    'label' => 'plugins/bb-form-builder::form.actions.mailchimp.email_field',
                    'required' => true,
                    'help' => 'plugins/bb-form-builder::form.actions.mailchimp.email_field_help',
                ],
                'name_field' => [
                    'type' => 'text',
                    'label' => 'plugins/bb-form-builder::form.actions.mailchimp.name_field',
                    'required' => false,
                    'help' => 'plugins/bb-form-builder::form.actions.mailchimp.name_field_help',
                ],
            ],
        ],
        'getresponse' => [
            'name' => 'plugins/bb-form-builder::form.actions.getresponse.name',
            'icon' => 'ti ti-mail-forward',
            'multiple' => true,
            'fields' => [
                'campaign_id' => [
                    'type' => 'select',
                    'label' => 'plugins/bb-form-builder::form.actions.getresponse.campaign',
                    'required' => true,
                    'options_url' => 'getresponse/campaigns',
                ],
                'email_field' => [
                    'type' => 'text',
                    'label' => 'plugins/bb-form-builder::form.actions.getresponse.email_field',
                    'required' => true,
                    'help' => 'plugins/bb-form-builder::form.actions.getresponse.email_field_help',
                ],
                'name_field' => [
                    'type' => 'text',
                    'label' => 'plugins/bb-form-builder::form.actions.getresponse.name_field',
                    'required' => false,
                    'help' => 'plugins/bb-form-builder::form.actions.getresponse.name_field_help',
                ],
            ],
        ],
    ],
];
